/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Dedicated Host Reservation offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HostOffering implements ToCopyableBuilder<HostOffering.Builder, HostOffering> {
    private final String currencyCode;

    private final Integer duration;

    private final String hourlyPrice;

    private final String instanceFamily;

    private final String offeringId;

    private final String paymentOption;

    private final String upfrontPrice;

    private HostOffering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.upfrontPrice = builder.upfrontPrice;
    }

    /**
     * <p>
     * The currency of the offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency of the offering.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency of the offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency of the offering.
     * @see CurrencyCodeValues
     */
    public String currencyCodeString() {
        return currencyCode;
    }

    /**
     * <p>
     * The duration of the offering (in seconds).
     * </p>
     * 
     * @return The duration of the offering (in seconds).
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The hourly price of the offering.
     * </p>
     * 
     * @return The hourly price of the offering.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The instance family of the offering.
     * </p>
     * 
     * @return The instance family of the offering.
     */
    public String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The available payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionString}.
     * </p>
     * 
     * @return The available payment option.
     * @see PaymentOption
     */
    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The available payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionString}.
     * </p>
     * 
     * @return The available payment option.
     * @see PaymentOption
     */
    public String paymentOptionString() {
        return paymentOption;
    }

    /**
     * <p>
     * The upfront price of the offering. Does not apply to No Upfront offerings.
     * </p>
     * 
     * @return The upfront price of the offering. Does not apply to No Upfront offerings.
     */
    public String upfrontPrice() {
        return upfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionString());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostOffering)) {
            return false;
        }
        HostOffering other = (HostOffering) obj;
        return Objects.equals(currencyCodeString(), other.currencyCodeString()) && Objects.equals(duration(), other.duration())
                && Objects.equals(hourlyPrice(), other.hourlyPrice()) && Objects.equals(instanceFamily(), other.instanceFamily())
                && Objects.equals(offeringId(), other.offeringId())
                && Objects.equals(paymentOptionString(), other.paymentOptionString())
                && Objects.equals(upfrontPrice(), other.upfrontPrice());
    }

    @Override
    public String toString() {
        return ToString.builder("HostOffering").add("CurrencyCode", currencyCodeString()).add("Duration", duration())
                .add("HourlyPrice", hourlyPrice()).add("InstanceFamily", instanceFamily()).add("OfferingId", offeringId())
                .add("PaymentOption", paymentOptionString()).add("UpfrontPrice", upfrontPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCodeString()));
        case "Duration":
            return Optional.of(clazz.cast(duration()));
        case "HourlyPrice":
            return Optional.of(clazz.cast(hourlyPrice()));
        case "InstanceFamily":
            return Optional.of(clazz.cast(instanceFamily()));
        case "OfferingId":
            return Optional.of(clazz.cast(offeringId()));
        case "PaymentOption":
            return Optional.of(clazz.cast(paymentOptionString()));
        case "UpfrontPrice":
            return Optional.of(clazz.cast(upfrontPrice()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HostOffering> {
        /**
         * <p>
         * The currency of the offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the offering.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the offering.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The duration of the offering (in seconds).
         * </p>
         * 
         * @param duration
         *        The duration of the offering (in seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The hourly price of the offering.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The instance family of the offering.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The available payment option.
         * </p>
         * 
         * @param paymentOption
         *        The available payment option.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The available payment option.
         * </p>
         * 
         * @param paymentOption
         *        The available payment option.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The upfront price of the offering. Does not apply to No Upfront offerings.
         * </p>
         * 
         * @param upfrontPrice
         *        The upfront price of the offering. Does not apply to No Upfront offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPrice(String upfrontPrice);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private Integer duration;

        private String hourlyPrice;

        private String instanceFamily;

        private String offeringId;

        private String paymentOption;

        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HostOffering model) {
            currencyCode(model.currencyCode);
            duration(model.duration);
            hourlyPrice(model.hourlyPrice);
            instanceFamily(model.instanceFamily);
            offeringId(model.offeringId);
            paymentOption(model.paymentOption);
            upfrontPrice(model.upfrontPrice);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getUpfrontPrice() {
            return upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        @Override
        public HostOffering build() {
            return new HostOffering(this);
        }
    }
}
