/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of GetPasswordData.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPasswordDataResponse extends EC2Response implements
        ToCopyableBuilder<GetPasswordDataResponse.Builder, GetPasswordDataResponse> {
    private final String instanceId;

    private final String passwordData;

    private final Instant timestamp;

    private GetPasswordDataResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.passwordData = builder.passwordData;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The ID of the Windows instance.
     * </p>
     * 
     * @return The ID of the Windows instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The password of the instance. Returns an empty string if the password is not available.
     * </p>
     * 
     * @return The password of the instance. Returns an empty string if the password is not available.
     */
    public String passwordData() {
        return passwordData;
    }

    /**
     * <p>
     * The time the data was last updated.
     * </p>
     * 
     * @return The time the data was last updated.
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(passwordData());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPasswordDataResponse)) {
            return false;
        }
        GetPasswordDataResponse other = (GetPasswordDataResponse) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(passwordData(), other.passwordData())
                && Objects.equals(timestamp(), other.timestamp());
    }

    @Override
    public String toString() {
        return ToString.builder("GetPasswordDataResponse").add("InstanceId", instanceId()).add("PasswordData", passwordData())
                .add("Timestamp", timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "PasswordData":
            return Optional.of(clazz.cast(passwordData()));
        case "Timestamp":
            return Optional.of(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, GetPasswordDataResponse> {
        /**
         * <p>
         * The ID of the Windows instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the Windows instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The password of the instance. Returns an empty string if the password is not available.
         * </p>
         * 
         * @param passwordData
         *        The password of the instance. Returns an empty string if the password is not available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordData(String passwordData);

        /**
         * <p>
         * The time the data was last updated.
         * </p>
         * 
         * @param timestamp
         *        The time the data was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String instanceId;

        private String passwordData;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPasswordDataResponse model) {
            instanceId(model.instanceId);
            passwordData(model.passwordData);
            timestamp(model.timestamp);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPasswordData() {
            return passwordData;
        }

        @Override
        public final Builder passwordData(String passwordData) {
            this.passwordData = passwordData;
            return this;
        }

        public final void setPasswordData(String passwordData) {
            this.passwordData = passwordData;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public GetPasswordDataResponse build() {
            return new GetPasswordDataResponse(this);
        }
    }
}
