/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVolumeAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumeAttributeResponse extends EC2Response implements
        ToCopyableBuilder<DescribeVolumeAttributeResponse.Builder, DescribeVolumeAttributeResponse> {
    private final Boolean autoEnableIO;

    private final List<ProductCode> productCodes;

    private final String volumeId;

    private DescribeVolumeAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnableIO = builder.autoEnableIO;
        this.productCodes = builder.productCodes;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The state of <code>autoEnableIO</code> attribute.
     * </p>
     * 
     * @return The state of <code>autoEnableIO</code> attribute.
     */
    public Boolean autoEnableIO() {
        return autoEnableIO;
    }

    /**
     * <p>
     * A list of product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableIO());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeAttributeResponse)) {
            return false;
        }
        DescribeVolumeAttributeResponse other = (DescribeVolumeAttributeResponse) obj;
        return Objects.equals(autoEnableIO(), other.autoEnableIO()) && Objects.equals(productCodes(), other.productCodes())
                && Objects.equals(volumeId(), other.volumeId());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVolumeAttributeResponse").add("AutoEnableIO", autoEnableIO())
                .add("ProductCodes", productCodes()).add("VolumeId", volumeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnableIO":
            return Optional.of(clazz.cast(autoEnableIO()));
        case "ProductCodes":
            return Optional.of(clazz.cast(productCodes()));
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeVolumeAttributeResponse> {
        /**
         * <p>
         * The state of <code>autoEnableIO</code> attribute.
         * </p>
         * 
         * @param autoEnableIO
         *        The state of <code>autoEnableIO</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableIO(Boolean autoEnableIO);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private Boolean autoEnableIO;

        private List<ProductCode> productCodes;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeAttributeResponse model) {
            autoEnableIO(model.autoEnableIO);
            productCodes(model.productCodes);
            volumeId(model.volumeId);
        }

        public final Boolean getAutoEnableIO() {
            return autoEnableIO;
        }

        @Override
        public final Builder autoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
            return this;
        }

        public final void setAutoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public DescribeVolumeAttributeResponse build() {
            return new DescribeVolumeAttributeResponse(this);
        }
    }
}
