/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeReservedInstancesOfferings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReservedInstancesOfferingsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeReservedInstancesOfferingsResponse.Builder, DescribeReservedInstancesOfferingsResponse> {
    private final List<ReservedInstancesOffering> reservedInstancesOfferings;

    private final String nextToken;

    private DescribeReservedInstancesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesOfferings = builder.reservedInstancesOfferings;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of Reserved Instances offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of Reserved Instances offerings.
     */
    public List<ReservedInstancesOffering> reservedInstancesOfferings() {
        return reservedInstancesOfferings;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesOfferings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsResponse)) {
            return false;
        }
        DescribeReservedInstancesOfferingsResponse other = (DescribeReservedInstancesOfferingsResponse) obj;
        return Objects.equals(reservedInstancesOfferings(), other.reservedInstancesOfferings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeReservedInstancesOfferingsResponse")
                .add("ReservedInstancesOfferings", reservedInstancesOfferings()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesOfferings":
            return Optional.of(clazz.cast(reservedInstancesOfferings()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeReservedInstancesOfferingsResponse> {
        /**
         * <p>
         * A list of Reserved Instances offerings.
         * </p>
         * 
         * @param reservedInstancesOfferings
         *        A list of Reserved Instances offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> reservedInstancesOfferings);

        /**
         * <p>
         * A list of Reserved Instances offerings.
         * </p>
         * 
         * @param reservedInstancesOfferings
         *        A list of Reserved Instances offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferings(ReservedInstancesOffering... reservedInstancesOfferings);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<ReservedInstancesOffering> reservedInstancesOfferings;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsResponse model) {
            reservedInstancesOfferings(model.reservedInstancesOfferings);
            nextToken(model.nextToken);
        }

        public final Collection<ReservedInstancesOffering.Builder> getReservedInstancesOfferings() {
            return reservedInstancesOfferings != null ? reservedInstancesOfferings.stream()
                    .map(ReservedInstancesOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copy(reservedInstancesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferings(ReservedInstancesOffering... reservedInstancesOfferings) {
            reservedInstancesOfferings(Arrays.asList(reservedInstancesOfferings));
            return this;
        }

        public final void setReservedInstancesOfferings(
                Collection<ReservedInstancesOffering.BuilderImpl> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copyFromBuilder(reservedInstancesOfferings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeReservedInstancesOfferingsResponse build() {
            return new DescribeReservedInstancesOfferingsResponse(this);
        }
    }
}
