/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeReservedInstancesModifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReservedInstancesModificationsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeReservedInstancesModificationsResponse.Builder, DescribeReservedInstancesModificationsResponse> {
    private final String nextToken;

    private final List<ReservedInstancesModification> reservedInstancesModifications;

    private DescribeReservedInstancesModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedInstancesModifications = builder.reservedInstancesModifications;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Reserved Instance modification information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Reserved Instance modification information.
     */
    public List<ReservedInstancesModification> reservedInstancesModifications() {
        return reservedInstancesModifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesModifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesModificationsResponse)) {
            return false;
        }
        DescribeReservedInstancesModificationsResponse other = (DescribeReservedInstancesModificationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(reservedInstancesModifications(), other.reservedInstancesModifications());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeReservedInstancesModificationsResponse").add("NextToken", nextToken())
                .add("ReservedInstancesModifications", reservedInstancesModifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "ReservedInstancesModifications":
            return Optional.of(clazz.cast(reservedInstancesModifications()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder,
            CopyableBuilder<Builder, DescribeReservedInstancesModificationsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Reserved Instance modification information.
         * </p>
         * 
         * @param reservedInstancesModifications
         *        The Reserved Instance modification information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModifications(Collection<ReservedInstancesModification> reservedInstancesModifications);

        /**
         * <p>
         * The Reserved Instance modification information.
         * </p>
         * 
         * @param reservedInstancesModifications
         *        The Reserved Instance modification information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModifications(ReservedInstancesModification... reservedInstancesModifications);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<ReservedInstancesModification> reservedInstancesModifications;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesModificationsResponse model) {
            nextToken(model.nextToken);
            reservedInstancesModifications(model.reservedInstancesModifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ReservedInstancesModification.Builder> getReservedInstancesModifications() {
            return reservedInstancesModifications != null ? reservedInstancesModifications.stream()
                    .map(ReservedInstancesModification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesModifications(
                Collection<ReservedInstancesModification> reservedInstancesModifications) {
            this.reservedInstancesModifications = ReservedInstancesModificationListCopier.copy(reservedInstancesModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesModifications(ReservedInstancesModification... reservedInstancesModifications) {
            reservedInstancesModifications(Arrays.asList(reservedInstancesModifications));
            return this;
        }

        public final void setReservedInstancesModifications(
                Collection<ReservedInstancesModification.BuilderImpl> reservedInstancesModifications) {
            this.reservedInstancesModifications = ReservedInstancesModificationListCopier
                    .copyFromBuilder(reservedInstancesModifications);
        }

        @Override
        public DescribeReservedInstancesModificationsResponse build() {
            return new DescribeReservedInstancesModificationsResponse(this);
        }
    }
}
