/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeRegions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeRegionsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeRegionsResponse.Builder, DescribeRegionsResponse> {
    private final List<Region> regions;

    private DescribeRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.regions = builder.regions;
    }

    /**
     * <p>
     * Information about one or more regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more regions.
     */
    public List<Region> regions() {
        return regions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionsResponse)) {
            return false;
        }
        DescribeRegionsResponse other = (DescribeRegionsResponse) obj;
        return Objects.equals(regions(), other.regions());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeRegionsResponse").add("Regions", regions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Regions":
            return Optional.of(clazz.cast(regions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeRegionsResponse> {
        /**
         * <p>
         * Information about one or more regions.
         * </p>
         * 
         * @param regions
         *        Information about one or more regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<Region> regions);

        /**
         * <p>
         * Information about one or more regions.
         * </p>
         * 
         * @param regions
         *        Information about one or more regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Region... regions);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<Region> regions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegionsResponse model) {
            regions(model.regions);
        }

        public final Collection<Region.Builder> getRegions() {
            return regions != null ? regions.stream().map(Region::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<Region.BuilderImpl> regions) {
            this.regions = RegionListCopier.copyFromBuilder(regions);
        }

        @Override
        public DescribeRegionsResponse build() {
            return new DescribeRegionsResponse(this);
        }
    }
}
