/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeNetworkInterfaceAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNetworkInterfaceAttributeRequest extends EC2Request implements
        ToCopyableBuilder<DescribeNetworkInterfaceAttributeRequest.Builder, DescribeNetworkInterfaceAttributeRequest> {
    private final String attribute;

    private final String networkInterfaceId;

    private DescribeNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    /**
     * <p>
     * The attribute of the network interface. This parameter is required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link NetworkInterfaceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeString}.
     * </p>
     * 
     * @return The attribute of the network interface. This parameter is required.
     * @see NetworkInterfaceAttribute
     */
    public NetworkInterfaceAttribute attribute() {
        return NetworkInterfaceAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute of the network interface. This parameter is required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link NetworkInterfaceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeString}.
     * </p>
     * 
     * @return The attribute of the network interface. This parameter is required.
     * @see NetworkInterfaceAttribute
     */
    public String attributeString() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeString());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfaceAttributeRequest)) {
            return false;
        }
        DescribeNetworkInterfaceAttributeRequest other = (DescribeNetworkInterfaceAttributeRequest) obj;
        return Objects.equals(attributeString(), other.attributeString())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeNetworkInterfaceAttributeRequest").add("Attribute", attributeString())
                .add("NetworkInterfaceId", networkInterfaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.of(clazz.cast(attributeString()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeNetworkInterfaceAttributeRequest> {
        /**
         * <p>
         * The attribute of the network interface. This parameter is required.
         * </p>
         * 
         * @param attribute
         *        The attribute of the network interface. This parameter is required.
         * @see NetworkInterfaceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute of the network interface. This parameter is required.
         * </p>
         * 
         * @param attribute
         *        The attribute of the network interface. This parameter is required.
         * @see NetworkInterfaceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceAttribute
         */
        Builder attribute(NetworkInterfaceAttribute attribute);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String attribute;

        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfaceAttributeRequest model) {
            attribute(model.attribute);
            networkInterfaceId(model.networkInterfaceId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(NetworkInterfaceAttribute attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInterfaceAttributeRequest build() {
            return new DescribeNetworkInterfaceAttributeRequest(this);
        }
    }
}
