/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeKeyPairs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeKeyPairsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeKeyPairsResponse.Builder, DescribeKeyPairsResponse> {
    private final List<KeyPairInfo> keyPairs;

    private DescribeKeyPairsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPairs = builder.keyPairs;
    }

    /**
     * <p>
     * Information about one or more key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more key pairs.
     */
    public List<KeyPairInfo> keyPairs() {
        return keyPairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyPairs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsResponse)) {
            return false;
        }
        DescribeKeyPairsResponse other = (DescribeKeyPairsResponse) obj;
        return Objects.equals(keyPairs(), other.keyPairs());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeKeyPairsResponse").add("KeyPairs", keyPairs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyPairs":
            return Optional.of(clazz.cast(keyPairs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeKeyPairsResponse> {
        /**
         * <p>
         * Information about one or more key pairs.
         * </p>
         * 
         * @param keyPairs
         *        Information about one or more key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(Collection<KeyPairInfo> keyPairs);

        /**
         * <p>
         * Information about one or more key pairs.
         * </p>
         * 
         * @param keyPairs
         *        Information about one or more key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(KeyPairInfo... keyPairs);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<KeyPairInfo> keyPairs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsResponse model) {
            keyPairs(model.keyPairs);
        }

        public final Collection<KeyPairInfo.Builder> getKeyPairs() {
            return keyPairs != null ? keyPairs.stream().map(KeyPairInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPairInfo> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPairInfo... keyPairs) {
            keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPairInfo.BuilderImpl> keyPairs) {
            this.keyPairs = KeyPairListCopier.copyFromBuilder(keyPairs);
        }

        @Override
        public DescribeKeyPairsResponse build() {
            return new DescribeKeyPairsResponse(this);
        }
    }
}
