/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeCustomerGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCustomerGatewaysResponse extends EC2Response implements
        ToCopyableBuilder<DescribeCustomerGatewaysResponse.Builder, DescribeCustomerGatewaysResponse> {
    private final List<CustomerGateway> customerGateways;

    private DescribeCustomerGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.customerGateways = builder.customerGateways;
    }

    /**
     * <p>
     * Information about one or more customer gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more customer gateways.
     */
    public List<CustomerGateway> customerGateways() {
        return customerGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerGateways());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerGatewaysResponse)) {
            return false;
        }
        DescribeCustomerGatewaysResponse other = (DescribeCustomerGatewaysResponse) obj;
        return Objects.equals(customerGateways(), other.customerGateways());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeCustomerGatewaysResponse").add("CustomerGateways", customerGateways()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerGateways":
            return Optional.of(clazz.cast(customerGateways()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeCustomerGatewaysResponse> {
        /**
         * <p>
         * Information about one or more customer gateways.
         * </p>
         * 
         * @param customerGateways
         *        Information about one or more customer gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGateways(Collection<CustomerGateway> customerGateways);

        /**
         * <p>
         * Information about one or more customer gateways.
         * </p>
         * 
         * @param customerGateways
         *        Information about one or more customer gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGateways(CustomerGateway... customerGateways);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<CustomerGateway> customerGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerGatewaysResponse model) {
            customerGateways(model.customerGateways);
        }

        public final Collection<CustomerGateway.Builder> getCustomerGateways() {
            return customerGateways != null ? customerGateways.stream().map(CustomerGateway::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customerGateways(Collection<CustomerGateway> customerGateways) {
            this.customerGateways = CustomerGatewayListCopier.copy(customerGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGateways(CustomerGateway... customerGateways) {
            customerGateways(Arrays.asList(customerGateways));
            return this;
        }

        public final void setCustomerGateways(Collection<CustomerGateway.BuilderImpl> customerGateways) {
            this.customerGateways = CustomerGatewayListCopier.copyFromBuilder(customerGateways);
        }

        @Override
        public DescribeCustomerGatewaysResponse build() {
            return new DescribeCustomerGatewaysResponse(this);
        }
    }
}
