/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAddressesResponse extends EC2Response implements
        ToCopyableBuilder<DescribeAddressesResponse.Builder, DescribeAddressesResponse> {
    private final List<Address> addresses;

    private DescribeAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.addresses = builder.addresses;
    }

    /**
     * <p>
     * Information about one or more Elastic IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more Elastic IP addresses.
     */
    public List<Address> addresses() {
        return addresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addresses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesResponse)) {
            return false;
        }
        DescribeAddressesResponse other = (DescribeAddressesResponse) obj;
        return Objects.equals(addresses(), other.addresses());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAddressesResponse").add("Addresses", addresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Addresses":
            return Optional.of(clazz.cast(addresses()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeAddressesResponse> {
        /**
         * <p>
         * Information about one or more Elastic IP addresses.
         * </p>
         * 
         * @param addresses
         *        Information about one or more Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<Address> addresses);

        /**
         * <p>
         * Information about one or more Elastic IP addresses.
         * </p>
         * 
         * @param addresses
         *        Information about one or more Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Address... addresses);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<Address> addresses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesResponse model) {
            addresses(model.addresses);
        }

        public final Collection<Address.Builder> getAddresses() {
            return addresses != null ? addresses.stream().map(Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        public final void setAddresses(Collection<Address.BuilderImpl> addresses) {
            this.addresses = AddressListCopier.copyFromBuilder(addresses);
        }

        @Override
        public DescribeAddressesResponse build() {
            return new DescribeAddressesResponse(this);
        }
    }
}
