/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteVpcEndpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteVpcEndpointsRequest extends EC2Request implements
        ToCopyableBuilder<DeleteVpcEndpointsRequest.Builder, DeleteVpcEndpointsRequest> {
    private final List<String> vpcEndpointIds;

    private DeleteVpcEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointIds = builder.vpcEndpointIds;
    }

    /**
     * <p>
     * One or more endpoint IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more endpoint IDs.
     */
    public List<String> vpcEndpointIds() {
        return vpcEndpointIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointsRequest)) {
            return false;
        }
        DeleteVpcEndpointsRequest other = (DeleteVpcEndpointsRequest) obj;
        return Objects.equals(vpcEndpointIds(), other.vpcEndpointIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteVpcEndpointsRequest").add("VpcEndpointIds", vpcEndpointIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointIds":
            return Optional.of(clazz.cast(vpcEndpointIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DeleteVpcEndpointsRequest> {
        /**
         * <p>
         * One or more endpoint IDs.
         * </p>
         * 
         * @param vpcEndpointIds
         *        One or more endpoint IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(Collection<String> vpcEndpointIds);

        /**
         * <p>
         * One or more endpoint IDs.
         * </p>
         * 
         * @param vpcEndpointIds
         *        One or more endpoint IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(String... vpcEndpointIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> vpcEndpointIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointsRequest model) {
            vpcEndpointIds(model.vpcEndpointIds);
        }

        public final Collection<String> getVpcEndpointIds() {
            return vpcEndpointIds;
        }

        @Override
        public final Builder vpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointIds(String... vpcEndpointIds) {
            vpcEndpointIds(Arrays.asList(vpcEndpointIds));
            return this;
        }

        public final void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcEndpointsRequest build() {
            return new DeleteVpcEndpointsRequest(this);
        }
    }
}
