/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteEgressOnlyInternetGatewayResponse extends EC2Response implements
        ToCopyableBuilder<DeleteEgressOnlyInternetGatewayResponse.Builder, DeleteEgressOnlyInternetGatewayResponse> {
    private final Boolean returnCode;

    private DeleteEgressOnlyInternetGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.returnCode = builder.returnCode;
    }

    /**
     * <p>
     * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     * </p>
     * 
     * @return Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     */
    public Boolean returnCode() {
        return returnCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(returnCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEgressOnlyInternetGatewayResponse)) {
            return false;
        }
        DeleteEgressOnlyInternetGatewayResponse other = (DeleteEgressOnlyInternetGatewayResponse) obj;
        return Objects.equals(returnCode(), other.returnCode());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteEgressOnlyInternetGatewayResponse").add("ReturnCode", returnCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReturnCode":
            return Optional.of(clazz.cast(returnCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DeleteEgressOnlyInternetGatewayResponse> {
        /**
         * <p>
         * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * </p>
         * 
         * @param returnCode
         *        Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnCode(Boolean returnCode);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private Boolean returnCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEgressOnlyInternetGatewayResponse model) {
            returnCode(model.returnCode);
        }

        public final Boolean getReturnCode() {
            return returnCode;
        }

        @Override
        public final Builder returnCode(Boolean returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        public final void setReturnCode(Boolean returnCode) {
            this.returnCode = returnCode;
        }

        @Override
        public DeleteEgressOnlyInternetGatewayResponse build() {
            return new DeleteEgressOnlyInternetGatewayResponse(this);
        }
    }
}
