/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateVpcEndpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpcEndpointResponse extends EC2Response implements
        ToCopyableBuilder<CreateVpcEndpointResponse.Builder, CreateVpcEndpointResponse> {
    private final VpcEndpoint vpcEndpoint;

    private final String clientToken;

    private CreateVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpoint = builder.vpcEndpoint;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the endpoint.
     * </p>
     * 
     * @return Information about the endpoint.
     */
    public VpcEndpoint vpcEndpoint() {
        return vpcEndpoint;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointResponse)) {
            return false;
        }
        CreateVpcEndpointResponse other = (CreateVpcEndpointResponse) obj;
        return Objects.equals(vpcEndpoint(), other.vpcEndpoint()) && Objects.equals(clientToken(), other.clientToken());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVpcEndpointResponse").add("VpcEndpoint", vpcEndpoint()).add("ClientToken", clientToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpoint":
            return Optional.of(clazz.cast(vpcEndpoint()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateVpcEndpointResponse> {
        /**
         * <p>
         * Information about the endpoint.
         * </p>
         * 
         * @param vpcEndpoint
         *        Information about the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoint(VpcEndpoint vpcEndpoint);

        /**
         * <p>
         * Information about the endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcEndpoint.Builder} avoiding the need to create
         * one manually via {@link VpcEndpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcEndpoint.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcEndpoint(VpcEndpoint)}.
         * 
         * @param vpcEndpoint
         *        a consumer that will call methods on {@link VpcEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpoint(VpcEndpoint)
         */
        default Builder vpcEndpoint(Consumer<VpcEndpoint.Builder> vpcEndpoint) {
            return vpcEndpoint(VpcEndpoint.builder().apply(vpcEndpoint).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private VpcEndpoint vpcEndpoint;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointResponse model) {
            vpcEndpoint(model.vpcEndpoint);
            clientToken(model.clientToken);
        }

        public final VpcEndpoint.Builder getVpcEndpoint() {
            return vpcEndpoint != null ? vpcEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder vpcEndpoint(VpcEndpoint vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final void setVpcEndpoint(VpcEndpoint.BuilderImpl vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint != null ? vpcEndpoint.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateVpcEndpointResponse build() {
            return new CreateVpcEndpointResponse(this);
        }
    }
}
