/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateNatGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateNatGatewayResponse extends EC2Response implements
        ToCopyableBuilder<CreateNatGatewayResponse.Builder, CreateNatGatewayResponse> {
    private final String clientToken;

    private final NatGateway natGateway;

    private CreateNatGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.natGateway = builder.natGateway;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was
     * provided in the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client
     *         token was provided in the request.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Information about the NAT gateway.
     * </p>
     * 
     * @return Information about the NAT gateway.
     */
    public NatGateway natGateway() {
        return natGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(natGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNatGatewayResponse)) {
            return false;
        }
        CreateNatGatewayResponse other = (CreateNatGatewayResponse) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(natGateway(), other.natGateway());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateNatGatewayResponse").add("ClientToken", clientToken()).add("NatGateway", natGateway())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "NatGateway":
            return Optional.of(clazz.cast(natGateway()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateNatGatewayResponse> {
        /**
         * <p>
         * Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token
         * was provided in the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client
         *        token was provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Information about the NAT gateway.
         * </p>
         * 
         * @param natGateway
         *        Information about the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGateway(NatGateway natGateway);

        /**
         * <p>
         * Information about the NAT gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link NatGateway.Builder} avoiding the need to create
         * one manually via {@link NatGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link NatGateway.Builder#build()} is called immediately and its result
         * is passed to {@link #natGateway(NatGateway)}.
         * 
         * @param natGateway
         *        a consumer that will call methods on {@link NatGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #natGateway(NatGateway)
         */
        default Builder natGateway(Consumer<NatGateway.Builder> natGateway) {
            return natGateway(NatGateway.builder().apply(natGateway).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String clientToken;

        private NatGateway natGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNatGatewayResponse model) {
            clientToken(model.clientToken);
            natGateway(model.natGateway);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final NatGateway.Builder getNatGateway() {
            return natGateway != null ? natGateway.toBuilder() : null;
        }

        @Override
        public final Builder natGateway(NatGateway natGateway) {
            this.natGateway = natGateway;
            return this;
        }

        public final void setNatGateway(NatGateway.BuilderImpl natGateway) {
            this.natGateway = natGateway != null ? natGateway.build() : null;
        }

        @Override
        public CreateNatGatewayResponse build() {
            return new CreateNatGatewayResponse(this);
        }
    }
}
