/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateInstanceExportTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInstanceExportTaskRequest extends EC2Request implements
        ToCopyableBuilder<CreateInstanceExportTaskRequest.Builder, CreateInstanceExportTaskRequest> {
    private final String description;

    private final ExportToS3TaskSpecification exportToS3Task;

    private final String instanceId;

    private final String targetEnvironment;

    private CreateInstanceExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.exportToS3Task = builder.exportToS3Task;
        this.instanceId = builder.instanceId;
        this.targetEnvironment = builder.targetEnvironment;
    }

    /**
     * <p>
     * A description for the conversion task or the resource being exported. The maximum length is 255 bytes.
     * </p>
     * 
     * @return A description for the conversion task or the resource being exported. The maximum length is 255 bytes.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The format and location for an instance export task.
     * </p>
     * 
     * @return The format and location for an instance export task.
     */
    public ExportToS3TaskSpecification exportToS3Task() {
        return exportToS3Task;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The target virtualization environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetEnvironment}
     * will return {@link ExportEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetEnvironmentString}.
     * </p>
     * 
     * @return The target virtualization environment.
     * @see ExportEnvironment
     */
    public ExportEnvironment targetEnvironment() {
        return ExportEnvironment.fromValue(targetEnvironment);
    }

    /**
     * <p>
     * The target virtualization environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetEnvironment}
     * will return {@link ExportEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetEnvironmentString}.
     * </p>
     * 
     * @return The target virtualization environment.
     * @see ExportEnvironment
     */
    public String targetEnvironmentString() {
        return targetEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(exportToS3Task());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(targetEnvironmentString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceExportTaskRequest)) {
            return false;
        }
        CreateInstanceExportTaskRequest other = (CreateInstanceExportTaskRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(exportToS3Task(), other.exportToS3Task())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(targetEnvironmentString(), other.targetEnvironmentString());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateInstanceExportTaskRequest").add("Description", description())
                .add("ExportToS3Task", exportToS3Task()).add("InstanceId", instanceId())
                .add("TargetEnvironment", targetEnvironmentString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ExportToS3Task":
            return Optional.of(clazz.cast(exportToS3Task()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "TargetEnvironment":
            return Optional.of(clazz.cast(targetEnvironmentString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateInstanceExportTaskRequest> {
        /**
         * <p>
         * A description for the conversion task or the resource being exported. The maximum length is 255 bytes.
         * </p>
         * 
         * @param description
         *        A description for the conversion task or the resource being exported. The maximum length is 255 bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The format and location for an instance export task.
         * </p>
         * 
         * @param exportToS3Task
         *        The format and location for an instance export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportToS3Task(ExportToS3TaskSpecification exportToS3Task);

        /**
         * <p>
         * The format and location for an instance export task.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportToS3TaskSpecification.Builder} avoiding
         * the need to create one manually via {@link ExportToS3TaskSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportToS3TaskSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #exportToS3Task(ExportToS3TaskSpecification)}.
         * 
         * @param exportToS3Task
         *        a consumer that will call methods on {@link ExportToS3TaskSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportToS3Task(ExportToS3TaskSpecification)
         */
        default Builder exportToS3Task(Consumer<ExportToS3TaskSpecification.Builder> exportToS3Task) {
            return exportToS3Task(ExportToS3TaskSpecification.builder().apply(exportToS3Task).build());
        }

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The target virtualization environment.
         * </p>
         * 
         * @param targetEnvironment
         *        The target virtualization environment.
         * @see ExportEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportEnvironment
         */
        Builder targetEnvironment(String targetEnvironment);

        /**
         * <p>
         * The target virtualization environment.
         * </p>
         * 
         * @param targetEnvironment
         *        The target virtualization environment.
         * @see ExportEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportEnvironment
         */
        Builder targetEnvironment(ExportEnvironment targetEnvironment);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String description;

        private ExportToS3TaskSpecification exportToS3Task;

        private String instanceId;

        private String targetEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceExportTaskRequest model) {
            description(model.description);
            exportToS3Task(model.exportToS3Task);
            instanceId(model.instanceId);
            targetEnvironment(model.targetEnvironment);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ExportToS3TaskSpecification.Builder getExportToS3Task() {
            return exportToS3Task != null ? exportToS3Task.toBuilder() : null;
        }

        @Override
        public final Builder exportToS3Task(ExportToS3TaskSpecification exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
            return this;
        }

        public final void setExportToS3Task(ExportToS3TaskSpecification.BuilderImpl exportToS3Task) {
            this.exportToS3Task = exportToS3Task != null ? exportToS3Task.build() : null;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTargetEnvironment() {
            return targetEnvironment;
        }

        @Override
        public final Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        @Override
        public final Builder targetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment.toString());
            return this;
        }

        public final void setTargetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceExportTaskRequest build() {
            return new CreateInstanceExportTaskRequest(this);
        }
    }
}
