/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the client-specific data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ClientData implements ToCopyableBuilder<ClientData.Builder, ClientData> {
    private final String comment;

    private final Instant uploadEnd;

    private final Double uploadSize;

    private final Instant uploadStart;

    private ClientData(BuilderImpl builder) {
        this.comment = builder.comment;
        this.uploadEnd = builder.uploadEnd;
        this.uploadSize = builder.uploadSize;
        this.uploadStart = builder.uploadStart;
    }

    /**
     * <p>
     * A user-defined comment about the disk upload.
     * </p>
     * 
     * @return A user-defined comment about the disk upload.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * The time that the disk upload ends.
     * </p>
     * 
     * @return The time that the disk upload ends.
     */
    public Instant uploadEnd() {
        return uploadEnd;
    }

    /**
     * <p>
     * The size of the uploaded disk image, in GiB.
     * </p>
     * 
     * @return The size of the uploaded disk image, in GiB.
     */
    public Double uploadSize() {
        return uploadSize;
    }

    /**
     * <p>
     * The time that the disk upload starts.
     * </p>
     * 
     * @return The time that the disk upload starts.
     */
    public Instant uploadStart() {
        return uploadStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(uploadEnd());
        hashCode = 31 * hashCode + Objects.hashCode(uploadSize());
        hashCode = 31 * hashCode + Objects.hashCode(uploadStart());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientData)) {
            return false;
        }
        ClientData other = (ClientData) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(uploadEnd(), other.uploadEnd())
                && Objects.equals(uploadSize(), other.uploadSize()) && Objects.equals(uploadStart(), other.uploadStart());
    }

    @Override
    public String toString() {
        return ToString.builder("ClientData").add("Comment", comment()).add("UploadEnd", uploadEnd())
                .add("UploadSize", uploadSize()).add("UploadStart", uploadStart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        case "UploadEnd":
            return Optional.of(clazz.cast(uploadEnd()));
        case "UploadSize":
            return Optional.of(clazz.cast(uploadSize()));
        case "UploadStart":
            return Optional.of(clazz.cast(uploadStart()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ClientData> {
        /**
         * <p>
         * A user-defined comment about the disk upload.
         * </p>
         * 
         * @param comment
         *        A user-defined comment about the disk upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The time that the disk upload ends.
         * </p>
         * 
         * @param uploadEnd
         *        The time that the disk upload ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadEnd(Instant uploadEnd);

        /**
         * <p>
         * The size of the uploaded disk image, in GiB.
         * </p>
         * 
         * @param uploadSize
         *        The size of the uploaded disk image, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadSize(Double uploadSize);

        /**
         * <p>
         * The time that the disk upload starts.
         * </p>
         * 
         * @param uploadStart
         *        The time that the disk upload starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadStart(Instant uploadStart);
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private Instant uploadEnd;

        private Double uploadSize;

        private Instant uploadStart;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientData model) {
            comment(model.comment);
            uploadEnd(model.uploadEnd);
            uploadSize(model.uploadSize);
            uploadStart(model.uploadStart);
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Instant getUploadEnd() {
            return uploadEnd;
        }

        @Override
        public final Builder uploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
            return this;
        }

        public final void setUploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
        }

        public final Double getUploadSize() {
            return uploadSize;
        }

        @Override
        public final Builder uploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
            return this;
        }

        public final void setUploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
        }

        public final Instant getUploadStart() {
            return uploadStart;
        }

        @Override
        public final Builder uploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
            return this;
        }

        public final void setUploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
        }

        @Override
        public ClientData build() {
            return new ClientData(this);
        }
    }
}
