/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for BundleInstance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BundleInstanceRequest extends EC2Request implements
        ToCopyableBuilder<BundleInstanceRequest.Builder, BundleInstanceRequest> {
    private final String instanceId;

    private final Storage storage;

    private BundleInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.storage = builder.storage;
    }

    /**
     * <p>
     * The ID of the instance to bundle.
     * </p>
     * <p>
     * Type: String
     * </p>
     * <p>
     * Default: None
     * </p>
     * <p>
     * Required: Yes
     * </p>
     * 
     * @return The ID of the instance to bundle.</p>
     *         <p>
     *         Type: String
     *         </p>
     *         <p>
     *         Default: None
     *         </p>
     *         <p>
     *         Required: Yes
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon
     * EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
     * </p>
     * 
     * @return The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
     *         Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2
     *         returns an error.
     */
    public Storage storage() {
        return storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInstanceRequest)) {
            return false;
        }
        BundleInstanceRequest other = (BundleInstanceRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(storage(), other.storage());
    }

    @Override
    public String toString() {
        return ToString.builder("BundleInstanceRequest").add("InstanceId", instanceId()).add("Storage", storage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "Storage":
            return Optional.of(clazz.cast(storage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, BundleInstanceRequest> {
        /**
         * <p>
         * The ID of the instance to bundle.
         * </p>
         * <p>
         * Type: String
         * </p>
         * <p>
         * Default: None
         * </p>
         * <p>
         * Required: Yes
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance to bundle.</p>
         *        <p>
         *        Type: String
         *        </p>
         *        <p>
         *        Default: None
         *        </p>
         *        <p>
         *        Required: Yes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
         * Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns
         * an error.
         * </p>
         * 
         * @param storage
         *        The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket
         *        that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon
         *        EC2 returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(Storage storage);

        /**
         * <p>
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
         * Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns
         * an error.
         * </p>
         * This is a convenience that creates an instance of the {@link Storage.Builder} avoiding the need to create one
         * manually via {@link Storage#builder()}.
         *
         * When the {@link Consumer} completes, {@link Storage.Builder#build()} is called immediately and its result is
         * passed to {@link #storage(Storage)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(Storage)
         */
        default Builder storage(Consumer<Storage.Builder> storage) {
            return storage(Storage.builder().apply(storage).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String instanceId;

        private Storage storage;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleInstanceRequest model) {
            instanceId(model.instanceId);
            storage(model.storage);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Storage.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        @Override
        public final Builder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(Storage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BundleInstanceRequest build() {
            return new BundleInstanceRequest(this);
        }
    }
}
