/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermission;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest;

public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        List<String> modifySnapshotAttributeRequestUserIdsList;
        List<String> modifySnapshotAttributeRequestGroupNamesList;
        CreateVolumePermissionModifications createVolumePermission;
        if (modifySnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifySnapshotAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySnapshotAttributeRequest.attributeString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifySnapshotAttributeRequest.attributeString()));
        }
        if ((createVolumePermission = modifySnapshotAttributeRequest.createVolumePermission()) != null) {
            List<CreateVolumePermission> createVolumePermissionModificationsRemoveList;
            List<CreateVolumePermission> createVolumePermissionModificationsAddList = createVolumePermission.add();
            if (createVolumePermissionModificationsAddList != null) {
                int addListIndex = 1;
                for (CreateVolumePermission createVolumePermission2 : createVolumePermissionModificationsAddList) {
                    if (createVolumePermission2.groupString() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)createVolumePermission2.groupString()));
                    }
                    if (createVolumePermission2.userId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)createVolumePermission2.userId()));
                    }
                    ++addListIndex;
                }
            }
            if ((createVolumePermissionModificationsRemoveList = createVolumePermission.remove()) != null) {
                int removeListIndex = 1;
                for (CreateVolumePermission createVolumePermissionModificationsRemoveListValue : createVolumePermissionModificationsRemoveList) {
                    if (createVolumePermissionModificationsRemoveListValue.groupString() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)createVolumePermissionModificationsRemoveListValue.groupString()));
                    }
                    if (createVolumePermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)createVolumePermissionModificationsRemoveListValue.userId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if ((modifySnapshotAttributeRequestGroupNamesList = modifySnapshotAttributeRequest.groupNames()) != null) {
            int groupNamesListIndex = 1;
            for (String string : modifySnapshotAttributeRequestGroupNamesList) {
                if (string != null) {
                    request.addParameter("UserGroup." + groupNamesListIndex, StringUtils.fromString((String)string));
                }
                ++groupNamesListIndex;
            }
        }
        if (modifySnapshotAttributeRequest.operationTypeString() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifySnapshotAttributeRequest.operationTypeString()));
        }
        if (modifySnapshotAttributeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)modifySnapshotAttributeRequest.snapshotId()));
        }
        if ((modifySnapshotAttributeRequestUserIdsList = modifySnapshotAttributeRequest.userIds()) != null) {
            int userIdsListIndex = 1;
            for (String modifySnapshotAttributeRequestUserIdsListValue : modifySnapshotAttributeRequestUserIdsList) {
                if (modifySnapshotAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)modifySnapshotAttributeRequestUserIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        return request;
    }
}

