/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.SpotPrice;

public final class DescribeSpotPriceHistoryPaginator
implements SdkIterable<DescribeSpotPriceHistoryResponse> {
    private final EC2Client client;
    private final DescribeSpotPriceHistoryRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeSpotPriceHistoryPaginator(EC2Client client, DescribeSpotPriceHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSpotPriceHistoryResponseFetcher();
    }

    public Iterator<DescribeSpotPriceHistoryResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<SpotPrice> spotPriceHistory() {
        Function<DescribeSpotPriceHistoryResponse, Iterator> getIterator = response -> response != null ? response.spotPriceHistory().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeSpotPriceHistoryResponseFetcher
    implements NextPageFetcher<DescribeSpotPriceHistoryResponse> {
        private DescribeSpotPriceHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotPriceHistoryResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeSpotPriceHistoryResponse nextPage(DescribeSpotPriceHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotPriceHistoryPaginator.this.client.describeSpotPriceHistory(DescribeSpotPriceHistoryPaginator.this.firstRequest);
            }
            return DescribeSpotPriceHistoryPaginator.this.client.describeSpotPriceHistory((DescribeSpotPriceHistoryRequest)((Object)DescribeSpotPriceHistoryPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

