/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.ActivityStatus;
import software.amazon.awssdk.services.ec2.model.BatchState;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotFleetRequestConfig
implements ToCopyableBuilder<Builder, SpotFleetRequestConfig> {
    private final String activityStatus;
    private final Instant createTime;
    private final SpotFleetRequestConfigData spotFleetRequestConfig;
    private final String spotFleetRequestId;
    private final String spotFleetRequestState;

    private SpotFleetRequestConfig(BuilderImpl builder) {
        this.activityStatus = builder.activityStatus;
        this.createTime = builder.createTime;
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.spotFleetRequestState = builder.spotFleetRequestState;
    }

    public ActivityStatus activityStatus() {
        return ActivityStatus.fromValue(this.activityStatus);
    }

    public String activityStatusString() {
        return this.activityStatus;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public SpotFleetRequestConfigData spotFleetRequestConfig() {
        return this.spotFleetRequestConfig;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public BatchState spotFleetRequestState() {
        return BatchState.fromValue(this.spotFleetRequestState);
    }

    public String spotFleetRequestStateString() {
        return this.spotFleetRequestState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestStateString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfig)) {
            return false;
        }
        SpotFleetRequestConfig other = (SpotFleetRequestConfig)obj;
        return Objects.equals(this.activityStatusString(), other.activityStatusString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.spotFleetRequestConfig(), other.spotFleetRequestConfig()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId()) && Objects.equals(this.spotFleetRequestStateString(), other.spotFleetRequestStateString());
    }

    public String toString() {
        return ToString.builder((String)"SpotFleetRequestConfig").add("ActivityStatus", (Object)this.activityStatusString()).add("CreateTime", (Object)this.createTime()).add("SpotFleetRequestConfig", (Object)this.spotFleetRequestConfig()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).add("SpotFleetRequestState", (Object)this.spotFleetRequestStateString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityStatus": {
                return Optional.of(clazz.cast(this.activityStatusString()));
            }
            case "CreateTime": {
                return Optional.of(clazz.cast(this.createTime()));
            }
            case "SpotFleetRequestConfig": {
                return Optional.of(clazz.cast(this.spotFleetRequestConfig()));
            }
            case "SpotFleetRequestId": {
                return Optional.of(clazz.cast(this.spotFleetRequestId()));
            }
            case "SpotFleetRequestState": {
                return Optional.of(clazz.cast(this.spotFleetRequestStateString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String activityStatus;
        private Instant createTime;
        private SpotFleetRequestConfigData spotFleetRequestConfig;
        private String spotFleetRequestId;
        private String spotFleetRequestState;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfig model) {
            this.activityStatus(model.activityStatus);
            this.createTime(model.createTime);
            this.spotFleetRequestConfig(model.spotFleetRequestConfig);
            this.spotFleetRequestId(model.spotFleetRequestId);
            this.spotFleetRequestState(model.spotFleetRequestState);
        }

        public final String getActivityStatus() {
            return this.activityStatus;
        }

        @Override
        public final Builder activityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
            return this;
        }

        @Override
        public final Builder activityStatus(ActivityStatus activityStatus) {
            this.activityStatus(activityStatus.toString());
            return this;
        }

        public final void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final SpotFleetRequestConfigData.Builder getSpotFleetRequestConfig() {
            return this.spotFleetRequestConfig != null ? this.spotFleetRequestConfig.toBuilder() : null;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData.BuilderImpl spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig != null ? spotFleetRequestConfig.build() : null;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final String getSpotFleetRequestState() {
            return this.spotFleetRequestState;
        }

        @Override
        public final Builder spotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
            return this;
        }

        @Override
        public final Builder spotFleetRequestState(BatchState spotFleetRequestState) {
            this.spotFleetRequestState(spotFleetRequestState.toString());
            return this;
        }

        public final void setSpotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
        }

        public SpotFleetRequestConfig build() {
            return new SpotFleetRequestConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotFleetRequestConfig> {
        public Builder activityStatus(String var1);

        public Builder activityStatus(ActivityStatus var1);

        public Builder createTime(Instant var1);

        public Builder spotFleetRequestConfig(SpotFleetRequestConfigData var1);

        default public Builder spotFleetRequestConfig(Consumer<SpotFleetRequestConfigData.Builder> spotFleetRequestConfig) {
            return this.spotFleetRequestConfig((SpotFleetRequestConfigData)((SpotFleetRequestConfigData.Builder)SpotFleetRequestConfigData.builder().apply(spotFleetRequestConfig)).build());
        }

        public Builder spotFleetRequestId(String var1);

        public Builder spotFleetRequestState(String var1);

        public Builder spotFleetRequestState(BatchState var1);
    }
}

