/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest;
import software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledInstanceAvailabilityRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityRequest> {
    private final List<Filter> filters;
    private final SlotDateTimeRangeRequest firstSlotStartTimeRange;
    private final Integer maxResults;
    private final Integer maxSlotDurationInHours;
    private final Integer minSlotDurationInHours;
    private final String nextToken;
    private final ScheduledInstanceRecurrenceRequest recurrence;

    private DescribeScheduledInstanceAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.firstSlotStartTimeRange = builder.firstSlotStartTimeRange;
        this.maxResults = builder.maxResults;
        this.maxSlotDurationInHours = builder.maxSlotDurationInHours;
        this.minSlotDurationInHours = builder.minSlotDurationInHours;
        this.nextToken = builder.nextToken;
        this.recurrence = builder.recurrence;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public SlotDateTimeRangeRequest firstSlotStartTimeRange() {
        return this.firstSlotStartTimeRange;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Integer maxSlotDurationInHours() {
        return this.maxSlotDurationInHours;
    }

    public Integer minSlotDurationInHours() {
        return this.minSlotDurationInHours;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public ScheduledInstanceRecurrenceRequest recurrence() {
        return this.recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSlotStartTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSlotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSlotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityRequest)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityRequest other = (DescribeScheduledInstanceAvailabilityRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.firstSlotStartTimeRange(), other.firstSlotStartTimeRange()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.maxSlotDurationInHours(), other.maxSlotDurationInHours()) && Objects.equals(this.minSlotDurationInHours(), other.minSlotDurationInHours()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.recurrence(), other.recurrence());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScheduledInstanceAvailabilityRequest").add("Filters", this.filters()).add("FirstSlotStartTimeRange", (Object)this.firstSlotStartTimeRange()).add("MaxResults", (Object)this.maxResults()).add("MaxSlotDurationInHours", (Object)this.maxSlotDurationInHours()).add("MinSlotDurationInHours", (Object)this.minSlotDurationInHours()).add("NextToken", (Object)this.nextToken()).add("Recurrence", (Object)this.recurrence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "FirstSlotStartTimeRange": {
                return Optional.of(clazz.cast(this.firstSlotStartTimeRange()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "MaxSlotDurationInHours": {
                return Optional.of(clazz.cast(this.maxSlotDurationInHours()));
            }
            case "MinSlotDurationInHours": {
                return Optional.of(clazz.cast(this.minSlotDurationInHours()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "Recurrence": {
                return Optional.of(clazz.cast(this.recurrence()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private SlotDateTimeRangeRequest firstSlotStartTimeRange;
        private Integer maxResults;
        private Integer maxSlotDurationInHours;
        private Integer minSlotDurationInHours;
        private String nextToken;
        private ScheduledInstanceRecurrenceRequest recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityRequest model) {
            this.filters(model.filters);
            this.firstSlotStartTimeRange(model.firstSlotStartTimeRange);
            this.maxResults(model.maxResults);
            this.maxSlotDurationInHours(model.maxSlotDurationInHours);
            this.minSlotDurationInHours(model.minSlotDurationInHours);
            this.nextToken(model.nextToken);
            this.recurrence(model.recurrence);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final SlotDateTimeRangeRequest.Builder getFirstSlotStartTimeRange() {
            return this.firstSlotStartTimeRange != null ? this.firstSlotStartTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange;
            return this;
        }

        public final void setFirstSlotStartTimeRange(SlotDateTimeRangeRequest.BuilderImpl firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange != null ? firstSlotStartTimeRange.build() : null;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMaxSlotDurationInHours() {
            return this.maxSlotDurationInHours;
        }

        @Override
        public final Builder maxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
            return this;
        }

        public final void setMaxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
        }

        public final Integer getMinSlotDurationInHours() {
            return this.minSlotDurationInHours;
        }

        @Override
        public final Builder minSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
            return this;
        }

        public final void setMinSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final ScheduledInstanceRecurrenceRequest.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrenceRequest recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrenceRequest.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledInstanceAvailabilityRequest build() {
            return new DescribeScheduledInstanceAvailabilityRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest var1);

        default public Builder firstSlotStartTimeRange(Consumer<SlotDateTimeRangeRequest.Builder> firstSlotStartTimeRange) {
            return this.firstSlotStartTimeRange((SlotDateTimeRangeRequest)((SlotDateTimeRangeRequest.Builder)SlotDateTimeRangeRequest.builder().apply(firstSlotStartTimeRange)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder maxSlotDurationInHours(Integer var1);

        public Builder minSlotDurationInHours(Integer var1);

        public Builder nextToken(String var1);

        public Builder recurrence(ScheduledInstanceRecurrenceRequest var1);

        default public Builder recurrence(Consumer<ScheduledInstanceRecurrenceRequest.Builder> recurrence) {
            return this.recurrence((ScheduledInstanceRecurrenceRequest)((ScheduledInstanceRecurrenceRequest.Builder)ScheduledInstanceRecurrenceRequest.builder().apply(recurrence)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

