/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.HostOffering;
import software.amazon.awssdk.services.ec2.model.HostOfferingSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostReservationOfferingsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeHostReservationOfferingsResponse> {
    private final String nextToken;
    private final List<HostOffering> offeringSet;

    private DescribeHostReservationOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.offeringSet = builder.offeringSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<HostOffering> offeringSet() {
        return this.offeringSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsResponse)) {
            return false;
        }
        DescribeHostReservationOfferingsResponse other = (DescribeHostReservationOfferingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.offeringSet(), other.offeringSet());
    }

    public String toString() {
        return ToString.builder((String)"DescribeHostReservationOfferingsResponse").add("NextToken", (Object)this.nextToken()).add("OfferingSet", this.offeringSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "OfferingSet": {
                return Optional.of(clazz.cast(this.offeringSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<HostOffering> offeringSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsResponse model) {
            this.nextToken(model.nextToken);
            this.offeringSet(model.offeringSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<HostOffering.Builder> getOfferingSet() {
            return this.offeringSet != null ? (Collection)this.offeringSet.stream().map(HostOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offeringSet(Collection<HostOffering> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copy(offeringSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringSet(HostOffering ... offeringSet) {
            this.offeringSet(Arrays.asList(offeringSet));
            return this;
        }

        public final void setOfferingSet(Collection<HostOffering.BuilderImpl> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copyFromBuilder(offeringSet);
        }

        @Override
        public DescribeHostReservationOfferingsResponse build() {
            return new DescribeHostReservationOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeHostReservationOfferingsResponse> {
        public Builder nextToken(String var1);

        public Builder offeringSet(Collection<HostOffering> var1);

        public Builder offeringSet(HostOffering ... var1);
    }
}

