/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CustomerGateway
implements ToCopyableBuilder<Builder, CustomerGateway> {
    private final String bgpAsn;
    private final String customerGatewayId;
    private final String ipAddress;
    private final String state;
    private final String type;
    private final List<Tag> tags;

    private CustomerGateway(BuilderImpl builder) {
        this.bgpAsn = builder.bgpAsn;
        this.customerGatewayId = builder.customerGatewayId;
        this.ipAddress = builder.ipAddress;
        this.state = builder.state;
        this.type = builder.type;
        this.tags = builder.tags;
    }

    public String bgpAsn() {
        return this.bgpAsn;
    }

    public String customerGatewayId() {
        return this.customerGatewayId;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String state() {
        return this.state;
    }

    public String type() {
        return this.type;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerGateway)) {
            return false;
        }
        CustomerGateway other = (CustomerGateway)obj;
        return Objects.equals(this.bgpAsn(), other.bgpAsn()) && Objects.equals(this.customerGatewayId(), other.customerGatewayId()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CustomerGateway").add("BgpAsn", (Object)this.bgpAsn()).add("CustomerGatewayId", (Object)this.customerGatewayId()).add("IpAddress", (Object)this.ipAddress()).add("State", (Object)this.state()).add("Type", (Object)this.type()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BgpAsn": {
                return Optional.of(clazz.cast(this.bgpAsn()));
            }
            case "CustomerGatewayId": {
                return Optional.of(clazz.cast(this.customerGatewayId()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.state()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bgpAsn;
        private String customerGatewayId;
        private String ipAddress;
        private String state;
        private String type;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerGateway model) {
            this.bgpAsn(model.bgpAsn);
            this.customerGatewayId(model.customerGatewayId);
            this.ipAddress(model.ipAddress);
            this.state(model.state);
            this.type(model.type);
            this.tags(model.tags);
        }

        public final String getBgpAsn() {
            return this.bgpAsn;
        }

        @Override
        public final Builder bgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final void setBgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public CustomerGateway build() {
            return new CustomerGateway(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomerGateway> {
        public Builder bgpAsn(String var1);

        public Builder customerGatewayId(String var1);

        public Builder ipAddress(String var1);

        public Builder state(String var1);

        public Builder type(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

