/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * Vpc StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VpcUnmarshaller implements Unmarshaller<Vpc, StaxUnmarshallerContext> {

    public Vpc unmarshall(StaxUnmarshallerContext context) throws Exception {
        Vpc.Builder vpc = Vpc.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = null;
        java.util.List<VpcCidrBlockAssociation> cidrBlockAssociationSet = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                vpc.ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet);
                vpc.cidrBlockAssociationSet(cidrBlockAssociationSet);
                vpc.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("cidrBlock", targetDepth)) {
                    vpc.cidrBlock(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("dhcpOptionsId", targetDepth)) {
                    vpc.dhcpOptionsId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    vpc.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    vpc.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceTenancy", targetDepth)) {
                    vpc.instanceTenancy(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6CidrBlockAssociationSet", targetDepth)) {
                    ipv6CidrBlockAssociationSet = new ArrayList<VpcIpv6CidrBlockAssociation>();
                    continue;
                }

                if (context.testExpression("ipv6CidrBlockAssociationSet/item", targetDepth)) {
                    ipv6CidrBlockAssociationSet.add(VpcIpv6CidrBlockAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("cidrBlockAssociationSet", targetDepth)) {
                    cidrBlockAssociationSet = new ArrayList<VpcCidrBlockAssociation>();
                    continue;
                }

                if (context.testExpression("cidrBlockAssociationSet/item", targetDepth)) {
                    cidrBlockAssociationSet.add(VpcCidrBlockAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("isDefault", targetDepth)) {
                    vpc.isDefault(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    vpc.ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet);
                    vpc.cidrBlockAssociationSet(cidrBlockAssociationSet);
                    vpc.tags(tags);
                    break;
                }
            }
        }
        return vpc.build();
    }

    private static final VpcUnmarshaller INSTANCE = new VpcUnmarshaller();

    public static VpcUnmarshaller getInstance() {
        return INSTANCE;
    }
}
