/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * PurchaseHostReservationResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PurchaseHostReservationResponseUnmarshaller implements
        Unmarshaller<PurchaseHostReservationResponse, StaxUnmarshallerContext> {

    public PurchaseHostReservationResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        PurchaseHostReservationResponse.Builder purchaseHostReservationResponse = PurchaseHostReservationResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Purchase> purchase = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                purchaseHostReservationResponse.purchase(purchase);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("clientToken", targetDepth)) {
                    purchaseHostReservationResponse.clientToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("currencyCode", targetDepth)) {
                    purchaseHostReservationResponse.currencyCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("purchase", targetDepth)) {
                    purchase = new ArrayList<Purchase>();
                    continue;
                }

                if (context.testExpression("purchase/item", targetDepth)) {
                    purchase.add(PurchaseUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("totalHourlyPrice", targetDepth)) {
                    purchaseHostReservationResponse.totalHourlyPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("totalUpfrontPrice", targetDepth)) {
                    purchaseHostReservationResponse.totalUpfrontPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    purchaseHostReservationResponse.purchase(purchase);
                    break;
                }
            }
        }
        return purchaseHostReservationResponse.build();
    }

    private static final PurchaseHostReservationResponseUnmarshaller INSTANCE = new PurchaseHostReservationResponseUnmarshaller();

    public static PurchaseHostReservationResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
