/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ModifyVpcPeeringConnectionOptionsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ModifyVpcPeeringConnectionOptionsRequestMarshaller implements
        Marshaller<Request<ModifyVpcPeeringConnectionOptionsRequest>, ModifyVpcPeeringConnectionOptionsRequest> {

    public Request<ModifyVpcPeeringConnectionOptionsRequest> marshall(
            ModifyVpcPeeringConnectionOptionsRequest modifyVpcPeeringConnectionOptionsRequest) {

        if (modifyVpcPeeringConnectionOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyVpcPeeringConnectionOptionsRequest> request = new DefaultRequest<ModifyVpcPeeringConnectionOptionsRequest>(
                modifyVpcPeeringConnectionOptionsRequest, "EC2Client");
        request.addParameter("Action", "ModifyVpcPeeringConnectionOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        PeeringConnectionOptionsRequest accepterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest
                .accepterPeeringConnectionOptions();
        if (accepterPeeringConnectionOptions != null) {

            if (accepterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc",
                        StringUtils.fromBoolean(accepterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc()));
            }

            if (accepterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc",
                        StringUtils.fromBoolean(accepterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc()));
            }

            if (accepterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink",
                        StringUtils.fromBoolean(accepterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }

        PeeringConnectionOptionsRequest requesterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest
                .requesterPeeringConnectionOptions();
        if (requesterPeeringConnectionOptions != null) {

            if (requesterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc",
                        StringUtils.fromBoolean(requesterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc()));
            }

            if (requesterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc",
                        StringUtils.fromBoolean(requesterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc()));
            }

            if (requesterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink",
                        StringUtils.fromBoolean(requesterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }

        if (modifyVpcPeeringConnectionOptionsRequest.vpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId",
                    StringUtils.fromString(modifyVpcPeeringConnectionOptionsRequest.vpcPeeringConnectionId()));
        }

        return request;
    }

}
