/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeVolumesModificationsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeVolumesModificationsResponseUnmarshaller implements
        Unmarshaller<DescribeVolumesModificationsResponse, StaxUnmarshallerContext> {

    public DescribeVolumesModificationsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeVolumesModificationsResponse.Builder describeVolumesModificationsResponse = DescribeVolumesModificationsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<VolumeModification> volumesModifications = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeVolumesModificationsResponse.volumesModifications(volumesModifications);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("volumeModificationSet", targetDepth)) {
                    volumesModifications = new ArrayList<VolumeModification>();
                    continue;
                }

                if (context.testExpression("volumeModificationSet/item", targetDepth)) {
                    volumesModifications.add(VolumeModificationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeVolumesModificationsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeVolumesModificationsResponse.volumesModifications(volumesModifications);
                    break;
                }
            }
        }
        return describeVolumesModificationsResponse.build();
    }

    private static final DescribeVolumesModificationsResponseUnmarshaller INSTANCE = new DescribeVolumesModificationsResponseUnmarshaller();

    public static DescribeVolumesModificationsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
