/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeSpotPriceHistoryRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeSpotPriceHistoryRequestMarshaller implements
        Marshaller<Request<DescribeSpotPriceHistoryRequest>, DescribeSpotPriceHistoryRequest> {

    public Request<DescribeSpotPriceHistoryRequest> marshall(DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest) {

        if (describeSpotPriceHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeSpotPriceHistoryRequest> request = new DefaultRequest<DescribeSpotPriceHistoryRequest>(
                describeSpotPriceHistoryRequest, "EC2Client");
        request.addParameter("Action", "DescribeSpotPriceHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeSpotPriceHistoryRequestFiltersList = describeSpotPriceHistoryRequest.filters();
        if (describeSpotPriceHistoryRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeSpotPriceHistoryRequestFiltersListValue : describeSpotPriceHistoryRequestFiltersList) {

                if (describeSpotPriceHistoryRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeSpotPriceHistoryRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeSpotPriceHistoryRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeSpotPriceHistoryRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(describeSpotPriceHistoryRequest.availabilityZone()));
        }

        if (describeSpotPriceHistoryRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant(describeSpotPriceHistoryRequest.endTime()));
        }

        java.util.List<String> describeSpotPriceHistoryRequestInstanceTypesList = describeSpotPriceHistoryRequest
                .instanceTypesStrings();
        if (describeSpotPriceHistoryRequestInstanceTypesList != null) {
            int instanceTypesListIndex = 1;

            for (String describeSpotPriceHistoryRequestInstanceTypesListValue : describeSpotPriceHistoryRequestInstanceTypesList) {
                if (describeSpotPriceHistoryRequestInstanceTypesListValue != null) {
                    request.addParameter("InstanceType." + instanceTypesListIndex,
                            StringUtils.fromString(describeSpotPriceHistoryRequestInstanceTypesListValue));
                }
                instanceTypesListIndex++;
            }
        }

        if (describeSpotPriceHistoryRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeSpotPriceHistoryRequest.maxResults()));
        }

        if (describeSpotPriceHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeSpotPriceHistoryRequest.nextToken()));
        }

        java.util.List<String> describeSpotPriceHistoryRequestProductDescriptionsList = describeSpotPriceHistoryRequest
                .productDescriptions();
        if (describeSpotPriceHistoryRequestProductDescriptionsList != null) {
            int productDescriptionsListIndex = 1;

            for (String describeSpotPriceHistoryRequestProductDescriptionsListValue : describeSpotPriceHistoryRequestProductDescriptionsList) {
                if (describeSpotPriceHistoryRequestProductDescriptionsListValue != null) {
                    request.addParameter("ProductDescription." + productDescriptionsListIndex,
                            StringUtils.fromString(describeSpotPriceHistoryRequestProductDescriptionsListValue));
                }
                productDescriptionsListIndex++;
            }
        }

        if (describeSpotPriceHistoryRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant(describeSpotPriceHistoryRequest.startTime()));
        }

        return request;
    }

}
