/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeElasticGpusRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeElasticGpusRequestMarshaller implements
        Marshaller<Request<DescribeElasticGpusRequest>, DescribeElasticGpusRequest> {

    public Request<DescribeElasticGpusRequest> marshall(DescribeElasticGpusRequest describeElasticGpusRequest) {

        if (describeElasticGpusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeElasticGpusRequest> request = new DefaultRequest<DescribeElasticGpusRequest>(describeElasticGpusRequest,
                "EC2Client");
        request.addParameter("Action", "DescribeElasticGpus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> describeElasticGpusRequestElasticGpuIdsList = describeElasticGpusRequest.elasticGpuIds();
        if (describeElasticGpusRequestElasticGpuIdsList != null) {
            int elasticGpuIdsListIndex = 1;

            for (String describeElasticGpusRequestElasticGpuIdsListValue : describeElasticGpusRequestElasticGpuIdsList) {
                if (describeElasticGpusRequestElasticGpuIdsListValue != null) {
                    request.addParameter("ElasticGpuId." + elasticGpuIdsListIndex,
                            StringUtils.fromString(describeElasticGpusRequestElasticGpuIdsListValue));
                }
                elasticGpuIdsListIndex++;
            }
        }

        java.util.List<Filter> describeElasticGpusRequestFiltersList = describeElasticGpusRequest.filters();
        if (describeElasticGpusRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeElasticGpusRequestFiltersListValue : describeElasticGpusRequestFiltersList) {

                if (describeElasticGpusRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeElasticGpusRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeElasticGpusRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeElasticGpusRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeElasticGpusRequest.maxResults()));
        }

        if (describeElasticGpusRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeElasticGpusRequest.nextToken()));
        }

        return request;
    }

}
