/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateReservedInstancesListingRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateReservedInstancesListingRequestMarshaller implements
        Marshaller<Request<CreateReservedInstancesListingRequest>, CreateReservedInstancesListingRequest> {

    public Request<CreateReservedInstancesListingRequest> marshall(
            CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {

        if (createReservedInstancesListingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateReservedInstancesListingRequest> request = new DefaultRequest<CreateReservedInstancesListingRequest>(
                createReservedInstancesListingRequest, "EC2Client");
        request.addParameter("Action", "CreateReservedInstancesListing");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createReservedInstancesListingRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createReservedInstancesListingRequest.clientToken()));
        }

        if (createReservedInstancesListingRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger(createReservedInstancesListingRequest.instanceCount()));
        }

        java.util.List<PriceScheduleSpecification> createReservedInstancesListingRequestPriceSchedulesList = createReservedInstancesListingRequest
                .priceSchedules();
        if (createReservedInstancesListingRequestPriceSchedulesList != null) {
            int priceSchedulesListIndex = 1;

            for (PriceScheduleSpecification createReservedInstancesListingRequestPriceSchedulesListValue : createReservedInstancesListingRequestPriceSchedulesList) {

                if (createReservedInstancesListingRequestPriceSchedulesListValue.currencyCodeString() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".CurrencyCode", StringUtils
                            .fromString(createReservedInstancesListingRequestPriceSchedulesListValue.currencyCodeString()));
                }

                if (createReservedInstancesListingRequestPriceSchedulesListValue.price() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Price",
                            StringUtils.fromDouble(createReservedInstancesListingRequestPriceSchedulesListValue.price()));
                }

                if (createReservedInstancesListingRequestPriceSchedulesListValue.term() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Term",
                            StringUtils.fromLong(createReservedInstancesListingRequestPriceSchedulesListValue.term()));
                }
                priceSchedulesListIndex++;
            }
        }

        if (createReservedInstancesListingRequest.reservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId",
                    StringUtils.fromString(createReservedInstancesListingRequest.reservedInstancesId()));
        }

        return request;
    }

}
