/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * BundleInstanceRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BundleInstanceRequestMarshaller implements Marshaller<Request<BundleInstanceRequest>, BundleInstanceRequest> {

    public Request<BundleInstanceRequest> marshall(BundleInstanceRequest bundleInstanceRequest) {

        if (bundleInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<BundleInstanceRequest> request = new DefaultRequest<BundleInstanceRequest>(bundleInstanceRequest, "EC2Client");
        request.addParameter("Action", "BundleInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (bundleInstanceRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(bundleInstanceRequest.instanceId()));
        }

        Storage storage = bundleInstanceRequest.storage();
        if (storage != null) {

            S3Storage s3 = storage.s3();
            if (s3 != null) {

                if (s3.awsAccessKeyId() != null) {
                    request.addParameter("Storage.S3.AWSAccessKeyId", StringUtils.fromString(s3.awsAccessKeyId()));
                }

                if (s3.bucket() != null) {
                    request.addParameter("Storage.S3.Bucket", StringUtils.fromString(s3.bucket()));
                }

                if (s3.prefix() != null) {
                    request.addParameter("Storage.S3.Prefix", StringUtils.fromString(s3.prefix()));
                }

                if (s3.uploadPolicy() != null) {
                    request.addParameter("Storage.S3.UploadPolicy", StringUtils.fromString(s3.uploadPolicy()));
                }

                if (s3.uploadPolicySignature() != null) {
                    request.addParameter("Storage.S3.UploadPolicySignature", StringUtils.fromString(s3.uploadPolicySignature()));
                }
            }
        }

        return request;
    }

}
