/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC in a VPC peering connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcPeeringConnectionVpcInfo implements
        ToCopyableBuilder<VpcPeeringConnectionVpcInfo.Builder, VpcPeeringConnectionVpcInfo> {
    private final String cidrBlock;

    private final List<Ipv6CidrBlock> ipv6CidrBlockSet;

    private final List<CidrBlock> cidrBlockSet;

    private final String ownerId;

    private final VpcPeeringConnectionOptionsDescription peeringOptions;

    private final String vpcId;

    private VpcPeeringConnectionVpcInfo(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlockSet = builder.ipv6CidrBlockSet;
        this.cidrBlockSet = builder.cidrBlockSet;
        this.ownerId = builder.ownerId;
        this.peeringOptions = builder.peeringOptions;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The IPv4 CIDR block for the VPC.
     * </p>
     * 
     * @return The IPv4 CIDR block for the VPC.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR block for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IPv6 CIDR block for the VPC.
     */
    public List<Ipv6CidrBlock> ipv6CidrBlockSet() {
        return ipv6CidrBlockSet;
    }

    /**
     * <p>
     * Information about the IPv4 CIDR blocks for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the IPv4 CIDR blocks for the VPC.
     */
    public List<CidrBlock> cidrBlockSet() {
        return cidrBlockSet;
    }

    /**
     * <p>
     * The AWS account ID of the VPC owner.
     * </p>
     * 
     * @return The AWS account ID of the VPC owner.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Information about the VPC peering connection options for the accepter or requester VPC.
     * </p>
     * 
     * @return Information about the VPC peering connection options for the accepter or requester VPC.
     */
    public VpcPeeringConnectionOptionsDescription peeringOptions() {
        return peeringOptions;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockSet());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlockSet());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(peeringOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnectionVpcInfo)) {
            return false;
        }
        VpcPeeringConnectionVpcInfo other = (VpcPeeringConnectionVpcInfo) obj;
        return Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(ipv6CidrBlockSet(), other.ipv6CidrBlockSet())
                && Objects.equals(cidrBlockSet(), other.cidrBlockSet()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(peeringOptions(), other.peeringOptions()) && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        return ToString.builder("VpcPeeringConnectionVpcInfo").add("CidrBlock", cidrBlock())
                .add("Ipv6CidrBlockSet", ipv6CidrBlockSet()).add("CidrBlockSet", cidrBlockSet()).add("OwnerId", ownerId())
                .add("PeeringOptions", peeringOptions()).add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.of(clazz.cast(cidrBlock()));
        case "Ipv6CidrBlockSet":
            return Optional.of(clazz.cast(ipv6CidrBlockSet()));
        case "CidrBlockSet":
            return Optional.of(clazz.cast(cidrBlockSet()));
        case "OwnerId":
            return Optional.of(clazz.cast(ownerId()));
        case "PeeringOptions":
            return Optional.of(clazz.cast(peeringOptions()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpcPeeringConnectionVpcInfo> {
        /**
         * <p>
         * The IPv4 CIDR block for the VPC.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockSet
         *        The IPv6 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockSet
         *        The IPv6 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockSet(Ipv6CidrBlock... ipv6CidrBlockSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks for the VPC.
         * </p>
         * 
         * @param cidrBlockSet
         *        Information about the IPv4 CIDR blocks for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockSet(Collection<CidrBlock> cidrBlockSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks for the VPC.
         * </p>
         * 
         * @param cidrBlockSet
         *        Information about the IPv4 CIDR blocks for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockSet(CidrBlock... cidrBlockSet);

        /**
         * <p>
         * The AWS account ID of the VPC owner.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the VPC owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Information about the VPC peering connection options for the accepter or requester VPC.
         * </p>
         * 
         * @param peeringOptions
         *        Information about the VPC peering connection options for the accepter or requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions);

        /**
         * <p>
         * Information about the VPC peering connection options for the accepter or requester VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringConnectionOptionsDescription.Builder}
         * avoiding the need to create one manually via {@link VpcPeeringConnectionOptionsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnectionOptionsDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #peeringOptions(VpcPeeringConnectionOptionsDescription)}.
         * 
         * @param peeringOptions
         *        a consumer that will call methods on {@link VpcPeeringConnectionOptionsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #peeringOptions(VpcPeeringConnectionOptionsDescription)
         */
        default Builder peeringOptions(Consumer<VpcPeeringConnectionOptionsDescription.Builder> peeringOptions) {
            return peeringOptions(VpcPeeringConnectionOptionsDescription.builder().apply(peeringOptions).build());
        }

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private List<Ipv6CidrBlock> ipv6CidrBlockSet;

        private List<CidrBlock> cidrBlockSet;

        private String ownerId;

        private VpcPeeringConnectionOptionsDescription peeringOptions;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnectionVpcInfo model) {
            cidrBlock(model.cidrBlock);
            ipv6CidrBlockSet(model.ipv6CidrBlockSet);
            cidrBlockSet(model.cidrBlockSet);
            ownerId(model.ownerId);
            peeringOptions(model.peeringOptions);
            vpcId(model.vpcId);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Collection<Ipv6CidrBlock.Builder> getIpv6CidrBlockSet() {
            return ipv6CidrBlockSet != null ? ipv6CidrBlockSet.stream().map(Ipv6CidrBlock::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copy(ipv6CidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Ipv6CidrBlock... ipv6CidrBlockSet) {
            ipv6CidrBlockSet(Arrays.asList(ipv6CidrBlockSet));
            return this;
        }

        public final void setIpv6CidrBlockSet(Collection<Ipv6CidrBlock.BuilderImpl> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copyFromBuilder(ipv6CidrBlockSet);
        }

        public final Collection<CidrBlock.Builder> getCidrBlockSet() {
            return cidrBlockSet != null ? cidrBlockSet.stream().map(CidrBlock::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cidrBlockSet(Collection<CidrBlock> cidrBlockSet) {
            this.cidrBlockSet = CidrBlockSetCopier.copy(cidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockSet(CidrBlock... cidrBlockSet) {
            cidrBlockSet(Arrays.asList(cidrBlockSet));
            return this;
        }

        public final void setCidrBlockSet(Collection<CidrBlock.BuilderImpl> cidrBlockSet) {
            this.cidrBlockSet = CidrBlockSetCopier.copyFromBuilder(cidrBlockSet);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final VpcPeeringConnectionOptionsDescription.Builder getPeeringOptions() {
            return peeringOptions != null ? peeringOptions.toBuilder() : null;
        }

        @Override
        public final Builder peeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions) {
            this.peeringOptions = peeringOptions;
            return this;
        }

        public final void setPeeringOptions(VpcPeeringConnectionOptionsDescription.BuilderImpl peeringOptions) {
            this.peeringOptions = peeringOptions != null ? peeringOptions.build() : null;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public VpcPeeringConnectionVpcInfo build() {
            return new VpcPeeringConnectionVpcInfo(this);
        }
    }
}
