/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcEndpoint implements ToCopyableBuilder<VpcEndpoint.Builder, VpcEndpoint> {
    private final String vpcEndpointId;

    private final String vpcEndpointType;

    private final String vpcId;

    private final String serviceName;

    private final String state;

    private final String policyDocument;

    private final List<String> routeTableIds;

    private final List<String> subnetIds;

    private final List<SecurityGroupIdentifier> groups;

    private final Boolean privateDnsEnabled;

    private final List<String> networkInterfaceIds;

    private final List<DnsEntry> dnsEntries;

    private final Instant creationTimestamp;

    private VpcEndpoint(BuilderImpl builder) {
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointType = builder.vpcEndpointType;
        this.vpcId = builder.vpcId;
        this.serviceName = builder.serviceName;
        this.state = builder.state;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.subnetIds = builder.subnetIds;
        this.groups = builder.groups;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.dnsEntries = builder.dnsEntries;
        this.creationTimestamp = builder.creationTimestamp;
    }

    /**
     * <p>
     * The ID of the VPC endpoint.
     * </p>
     * 
     * @return The ID of the VPC endpoint.
     */
    public String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The type of endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcEndpointType}
     * will return {@link VpcEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vpcEndpointTypeString}.
     * </p>
     * 
     * @return The type of endpoint.
     * @see VpcEndpointType
     */
    public VpcEndpointType vpcEndpointType() {
        return VpcEndpointType.fromValue(vpcEndpointType);
    }

    /**
     * <p>
     * The type of endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcEndpointType}
     * will return {@link VpcEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vpcEndpointTypeString}.
     * </p>
     * 
     * @return The type of endpoint.
     * @see VpcEndpointType
     */
    public String vpcEndpointTypeString() {
        return vpcEndpointType;
    }

    /**
     * <p>
     * The ID of the VPC to which the endpoint is associated.
     * </p>
     * 
     * @return The ID of the VPC to which the endpoint is associated.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The name of the AWS service to which the endpoint is associated.
     * </p>
     * 
     * @return The name of the AWS service to which the endpoint is associated.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The state of the VPC endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the VPC endpoint.
     * @see State
     */
    public State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The state of the VPC endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the VPC endpoint.
     * @see State
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The policy document associated with the endpoint, if applicable.
     * </p>
     * 
     * @return The policy document associated with the endpoint, if applicable.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * (Gateway endpoint) One or more route tables associated with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Gateway endpoint) One or more route tables associated with the endpoint.
     */
    public List<String> routeTableIds() {
        return routeTableIds;
    }

    /**
     * <p>
     * (Interface endpoint) One or more subnets in which the endpoint is located.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Interface endpoint) One or more subnets in which the endpoint is located.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * (Interface endpoint) Information about the security groups associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Interface endpoint) Information about the security groups associated with the network interface.
     */
    public List<SecurityGroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * (Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.
     * </p>
     * 
     * @return (Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.
     */
    public Boolean privateDnsEnabled() {
        return privateDnsEnabled;
    }

    /**
     * <p>
     * (Interface endpoint) One or more network interfaces for the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Interface endpoint) One or more network interfaces for the endpoint.
     */
    public List<String> networkInterfaceIds() {
        return networkInterfaceIds;
    }

    /**
     * <p>
     * (Interface endpoint) The DNS entries for the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Interface endpoint) The DNS entries for the endpoint.
     */
    public List<DnsEntry> dnsEntries() {
        return dnsEntries;
    }

    /**
     * <p>
     * The date and time the VPC endpoint was created.
     * </p>
     * 
     * @return The date and time the VPC endpoint was created.
     */
    public Instant creationTimestamp() {
        return creationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(dnsEntries());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpoint)) {
            return false;
        }
        VpcEndpoint other = (VpcEndpoint) obj;
        return Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(vpcEndpointTypeString(), other.vpcEndpointTypeString())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(stateString(), other.stateString()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(routeTableIds(), other.routeTableIds()) && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(groups(), other.groups()) && Objects.equals(privateDnsEnabled(), other.privateDnsEnabled())
                && Objects.equals(networkInterfaceIds(), other.networkInterfaceIds())
                && Objects.equals(dnsEntries(), other.dnsEntries())
                && Objects.equals(creationTimestamp(), other.creationTimestamp());
    }

    @Override
    public String toString() {
        return ToString.builder("VpcEndpoint").add("VpcEndpointId", vpcEndpointId())
                .add("VpcEndpointType", vpcEndpointTypeString()).add("VpcId", vpcId()).add("ServiceName", serviceName())
                .add("State", stateString()).add("PolicyDocument", policyDocument()).add("RouteTableIds", routeTableIds())
                .add("SubnetIds", subnetIds()).add("Groups", groups()).add("PrivateDnsEnabled", privateDnsEnabled())
                .add("NetworkInterfaceIds", networkInterfaceIds()).add("DnsEntries", dnsEntries())
                .add("CreationTimestamp", creationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointId":
            return Optional.of(clazz.cast(vpcEndpointId()));
        case "VpcEndpointType":
            return Optional.of(clazz.cast(vpcEndpointTypeString()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        case "ServiceName":
            return Optional.of(clazz.cast(serviceName()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "PolicyDocument":
            return Optional.of(clazz.cast(policyDocument()));
        case "RouteTableIds":
            return Optional.of(clazz.cast(routeTableIds()));
        case "SubnetIds":
            return Optional.of(clazz.cast(subnetIds()));
        case "Groups":
            return Optional.of(clazz.cast(groups()));
        case "PrivateDnsEnabled":
            return Optional.of(clazz.cast(privateDnsEnabled()));
        case "NetworkInterfaceIds":
            return Optional.of(clazz.cast(networkInterfaceIds()));
        case "DnsEntries":
            return Optional.of(clazz.cast(dnsEntries()));
        case "CreationTimestamp":
            return Optional.of(clazz.cast(creationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpcEndpoint> {
        /**
         * <p>
         * The ID of the VPC endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The type of endpoint.
         * </p>
         * 
         * @param vpcEndpointType
         *        The type of endpoint.
         * @see VpcEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointType
         */
        Builder vpcEndpointType(String vpcEndpointType);

        /**
         * <p>
         * The type of endpoint.
         * </p>
         * 
         * @param vpcEndpointType
         *        The type of endpoint.
         * @see VpcEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointType
         */
        Builder vpcEndpointType(VpcEndpointType vpcEndpointType);

        /**
         * <p>
         * The ID of the VPC to which the endpoint is associated.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC to which the endpoint is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The name of the AWS service to which the endpoint is associated.
         * </p>
         * 
         * @param serviceName
         *        The name of the AWS service to which the endpoint is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The state of the VPC endpoint.
         * </p>
         * 
         * @param state
         *        The state of the VPC endpoint.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the VPC endpoint.
         * </p>
         * 
         * @param state
         *        The state of the VPC endpoint.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * The policy document associated with the endpoint, if applicable.
         * </p>
         * 
         * @param policyDocument
         *        The policy document associated with the endpoint, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * (Gateway endpoint) One or more route tables associated with the endpoint.
         * </p>
         * 
         * @param routeTableIds
         *        (Gateway endpoint) One or more route tables associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(Collection<String> routeTableIds);

        /**
         * <p>
         * (Gateway endpoint) One or more route tables associated with the endpoint.
         * </p>
         * 
         * @param routeTableIds
         *        (Gateway endpoint) One or more route tables associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(String... routeTableIds);

        /**
         * <p>
         * (Interface endpoint) One or more subnets in which the endpoint is located.
         * </p>
         * 
         * @param subnetIds
         *        (Interface endpoint) One or more subnets in which the endpoint is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * (Interface endpoint) One or more subnets in which the endpoint is located.
         * </p>
         * 
         * @param subnetIds
         *        (Interface endpoint) One or more subnets in which the endpoint is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * (Interface endpoint) Information about the security groups associated with the network interface.
         * </p>
         * 
         * @param groups
         *        (Interface endpoint) Information about the security groups associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<SecurityGroupIdentifier> groups);

        /**
         * <p>
         * (Interface endpoint) Information about the security groups associated with the network interface.
         * </p>
         * 
         * @param groups
         *        (Interface endpoint) Information about the security groups associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(SecurityGroupIdentifier... groups);

        /**
         * <p>
         * (Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.
         * </p>
         * 
         * @param privateDnsEnabled
         *        (Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsEnabled(Boolean privateDnsEnabled);

        /**
         * <p>
         * (Interface endpoint) One or more network interfaces for the endpoint.
         * </p>
         * 
         * @param networkInterfaceIds
         *        (Interface endpoint) One or more network interfaces for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(Collection<String> networkInterfaceIds);

        /**
         * <p>
         * (Interface endpoint) One or more network interfaces for the endpoint.
         * </p>
         * 
         * @param networkInterfaceIds
         *        (Interface endpoint) One or more network interfaces for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(String... networkInterfaceIds);

        /**
         * <p>
         * (Interface endpoint) The DNS entries for the endpoint.
         * </p>
         * 
         * @param dnsEntries
         *        (Interface endpoint) The DNS entries for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsEntries(Collection<DnsEntry> dnsEntries);

        /**
         * <p>
         * (Interface endpoint) The DNS entries for the endpoint.
         * </p>
         * 
         * @param dnsEntries
         *        (Interface endpoint) The DNS entries for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsEntries(DnsEntry... dnsEntries);

        /**
         * <p>
         * The date and time the VPC endpoint was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The date and time the VPC endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String vpcEndpointId;

        private String vpcEndpointType;

        private String vpcId;

        private String serviceName;

        private String state;

        private String policyDocument;

        private List<String> routeTableIds;

        private List<String> subnetIds;

        private List<SecurityGroupIdentifier> groups;

        private Boolean privateDnsEnabled;

        private List<String> networkInterfaceIds;

        private List<DnsEntry> dnsEntries;

        private Instant creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpoint model) {
            vpcEndpointId(model.vpcEndpointId);
            vpcEndpointType(model.vpcEndpointType);
            vpcId(model.vpcId);
            serviceName(model.serviceName);
            state(model.state);
            policyDocument(model.policyDocument);
            routeTableIds(model.routeTableIds);
            subnetIds(model.subnetIds);
            groups(model.groups);
            privateDnsEnabled(model.privateDnsEnabled);
            networkInterfaceIds(model.networkInterfaceIds);
            dnsEntries(model.dnsEntries);
            creationTimestamp(model.creationTimestamp);
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getVpcEndpointType() {
            return vpcEndpointType;
        }

        @Override
        public final Builder vpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        @Override
        public final Builder vpcEndpointType(VpcEndpointType vpcEndpointType) {
            this.vpcEndpointType(vpcEndpointType.toString());
            return this;
        }

        public final void setVpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRouteTableIds() {
            return routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String... routeTableIds) {
            routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ValueStringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ValueStringListCopier.copy(subnetIds);
        }

        public final Collection<SecurityGroupIdentifier.Builder> getGroups() {
            return groups != null ? groups.stream().map(SecurityGroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<SecurityGroupIdentifier> groups) {
            this.groups = GroupIdentifierSetCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(SecurityGroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<SecurityGroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierSetCopier.copyFromBuilder(groups);
        }

        public final Boolean getPrivateDnsEnabled() {
            return privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            return networkInterfaceIds;
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ValueStringListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String... networkInterfaceIds) {
            networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ValueStringListCopier.copy(networkInterfaceIds);
        }

        public final Collection<DnsEntry.Builder> getDnsEntries() {
            return dnsEntries != null ? dnsEntries.stream().map(DnsEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dnsEntries(Collection<DnsEntry> dnsEntries) {
            this.dnsEntries = DnsEntrySetCopier.copy(dnsEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsEntries(DnsEntry... dnsEntries) {
            dnsEntries(Arrays.asList(dnsEntries));
            return this;
        }

        public final void setDnsEntries(Collection<DnsEntry.BuilderImpl> dnsEntries) {
            this.dnsEntries = DnsEntrySetCopier.copyFromBuilder(dnsEntries);
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public VpcEndpoint build() {
            return new VpcEndpoint(this);
        }
    }
}
