/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the snapshot created from the imported disk.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SnapshotDetail implements ToCopyableBuilder<SnapshotDetail.Builder, SnapshotDetail> {
    private final String description;

    private final String deviceName;

    private final Double diskImageSize;

    private final String format;

    private final String progress;

    private final String snapshotId;

    private final String status;

    private final String statusMessage;

    private final String url;

    private final UserBucketDetails userBucket;

    private SnapshotDetail(BuilderImpl builder) {
        this.description = builder.description;
        this.deviceName = builder.deviceName;
        this.diskImageSize = builder.diskImageSize;
        this.format = builder.format;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @return A description for the snapshot.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The block device mapping for the snapshot.
     * </p>
     * 
     * @return The block device mapping for the snapshot.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The size of the disk in the snapshot, in GiB.
     * </p>
     * 
     * @return The size of the disk in the snapshot, in GiB.
     */
    public Double diskImageSize() {
        return diskImageSize;
    }

    /**
     * <p>
     * The format of the disk image from which the snapshot is created.
     * </p>
     * 
     * @return The format of the disk image from which the snapshot is created.
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * The percentage of progress for the task.
     * </p>
     * 
     * @return The percentage of progress for the task.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * The snapshot ID of the disk being imported.
     * </p>
     * 
     * @return The snapshot ID of the disk being imported.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * A brief status of the snapshot creation.
     * </p>
     * 
     * @return A brief status of the snapshot creation.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A detailed status message for the snapshot creation.
     * </p>
     * 
     * @return A detailed status message for the snapshot creation.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The URL used to access the disk image.
     * </p>
     * 
     * @return The URL used to access the disk image.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The S3 bucket for the disk image.
     * </p>
     * 
     * @return The S3 bucket for the disk image.
     */
    public UserBucketDetails userBucket() {
        return userBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(diskImageSize());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(userBucket());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDetail)) {
            return false;
        }
        SnapshotDetail other = (SnapshotDetail) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(diskImageSize(), other.diskImageSize()) && Objects.equals(format(), other.format())
                && Objects.equals(progress(), other.progress()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(status(), other.status()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(url(), other.url()) && Objects.equals(userBucket(), other.userBucket());
    }

    @Override
    public String toString() {
        return ToString.builder("SnapshotDetail").add("Description", description()).add("DeviceName", deviceName())
                .add("DiskImageSize", diskImageSize()).add("Format", format()).add("Progress", progress())
                .add("SnapshotId", snapshotId()).add("Status", status()).add("StatusMessage", statusMessage()).add("Url", url())
                .add("UserBucket", userBucket()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DeviceName":
            return Optional.of(clazz.cast(deviceName()));
        case "DiskImageSize":
            return Optional.of(clazz.cast(diskImageSize()));
        case "Format":
            return Optional.of(clazz.cast(format()));
        case "Progress":
            return Optional.of(clazz.cast(progress()));
        case "SnapshotId":
            return Optional.of(clazz.cast(snapshotId()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        case "Url":
            return Optional.of(clazz.cast(url()));
        case "UserBucket":
            return Optional.of(clazz.cast(userBucket()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SnapshotDetail> {
        /**
         * <p>
         * A description for the snapshot.
         * </p>
         * 
         * @param description
         *        A description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The block device mapping for the snapshot.
         * </p>
         * 
         * @param deviceName
         *        The block device mapping for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The size of the disk in the snapshot, in GiB.
         * </p>
         * 
         * @param diskImageSize
         *        The size of the disk in the snapshot, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskImageSize(Double diskImageSize);

        /**
         * <p>
         * The format of the disk image from which the snapshot is created.
         * </p>
         * 
         * @param format
         *        The format of the disk image from which the snapshot is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The percentage of progress for the task.
         * </p>
         * 
         * @param progress
         *        The percentage of progress for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The snapshot ID of the disk being imported.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID of the disk being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * A brief status of the snapshot creation.
         * </p>
         * 
         * @param status
         *        A brief status of the snapshot creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A detailed status message for the snapshot creation.
         * </p>
         * 
         * @param statusMessage
         *        A detailed status message for the snapshot creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The URL used to access the disk image.
         * </p>
         * 
         * @param url
         *        The URL used to access the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The S3 bucket for the disk image.
         * </p>
         * 
         * @param userBucket
         *        The S3 bucket for the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBucket(UserBucketDetails userBucket);

        /**
         * <p>
         * The S3 bucket for the disk image.
         * </p>
         * This is a convenience that creates an instance of the {@link UserBucketDetails.Builder} avoiding the need to
         * create one manually via {@link UserBucketDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserBucketDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #userBucket(UserBucketDetails)}.
         * 
         * @param userBucket
         *        a consumer that will call methods on {@link UserBucketDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userBucket(UserBucketDetails)
         */
        default Builder userBucket(Consumer<UserBucketDetails.Builder> userBucket) {
            return userBucket(UserBucketDetails.builder().apply(userBucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String deviceName;

        private Double diskImageSize;

        private String format;

        private String progress;

        private String snapshotId;

        private String status;

        private String statusMessage;

        private String url;

        private UserBucketDetails userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDetail model) {
            description(model.description);
            deviceName(model.deviceName);
            diskImageSize(model.diskImageSize);
            format(model.format);
            progress(model.progress);
            snapshotId(model.snapshotId);
            status(model.status);
            statusMessage(model.statusMessage);
            url(model.url);
            userBucket(model.userBucket);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final Double getDiskImageSize() {
            return diskImageSize;
        }

        @Override
        public final Builder diskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
            return this;
        }

        public final void setDiskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucketDetails.Builder getUserBucket() {
            return userBucket != null ? userBucket.toBuilder() : null;
        }

        @Override
        public final Builder userBucket(UserBucketDetails userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucketDetails.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        @Override
        public SnapshotDetail build() {
            return new SnapshotDetail(this);
        }
    }
}
