/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstancesOffering implements ToCopyableBuilder<ReservedInstancesOffering.Builder, ReservedInstancesOffering> {
    private final String availabilityZone;

    private final Long duration;

    private final Float fixedPrice;

    private final String instanceType;

    private final String productDescription;

    private final String reservedInstancesOfferingId;

    private final Float usagePrice;

    private final String currencyCode;

    private final String instanceTenancy;

    private final Boolean marketplace;

    private final String offeringClass;

    private final String offeringType;

    private final List<PricingDetail> pricingDetails;

    private final List<RecurringCharge> recurringCharges;

    private final String scope;

    private ReservedInstancesOffering(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.marketplace = builder.marketplace;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.pricingDetails = builder.pricingDetails;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * The Availability Zone in which the Reserved Instance can be used.
     * </p>
     * 
     * @return The Availability Zone in which the Reserved Instance can be used.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The duration of the Reserved Instance, in seconds.
     * </p>
     * 
     * @return The duration of the Reserved Instance, in seconds.
     */
    public Long duration() {
        return duration;
    }

    /**
     * <p>
     * The purchase price of the Reserved Instance.
     * </p>
     * 
     * @return The purchase price of the Reserved Instance.
     */
    public Float fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public String instanceTypeString() {
        return instanceType;
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(productDescription);
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public String productDescriptionString() {
        return productDescription;
    }

    /**
     * <p>
     * The ID of the Reserved Instance offering. This is the offering ID used in
     * <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
     * </p>
     * 
     * @return The ID of the Reserved Instance offering. This is the offering ID used in
     *         <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
     */
    public String reservedInstancesOfferingId() {
        return reservedInstancesOfferingId;
    }

    /**
     * <p>
     * The usage price of the Reserved Instance, per hour.
     * </p>
     * 
     * @return The usage price of the Reserved Instance, per hour.
     */
    public Float usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     * currency codes. At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     *         currency codes. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     * currency codes. At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     *         currency codes. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeString() {
        return currencyCode;
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public String instanceTenancyString() {
        return instanceTenancy;
    }

    /**
     * <p>
     * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If it's a
     * Reserved Instance Marketplace offering, this is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If
     *         it's a Reserved Instance Marketplace offering, this is <code>true</code>.
     */
    public Boolean marketplace() {
        return marketplace;
    }

    /**
     * <p>
     * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value, with
     * different configurations. If <code>standard</code>, it is not possible to perform an exchange.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassString}.
     * </p>
     * 
     * @return If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
     *         value, with different configurations. If <code>standard</code>, it is not possible to perform an
     *         exchange.
     * @see OfferingClassType
     */
    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(offeringClass);
    }

    /**
     * <p>
     * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value, with
     * different configurations. If <code>standard</code>, it is not possible to perform an exchange.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassString}.
     * </p>
     * 
     * @return If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
     *         value, with different configurations. If <code>standard</code>, it is not possible to perform an
     *         exchange.
     * @see OfferingClassType
     */
    public String offeringClassString() {
        return offeringClass;
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(offeringType);
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public String offeringTypeString() {
        return offeringType;
    }

    /**
     * <p>
     * The pricing details of the Reserved Instance offering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The pricing details of the Reserved Instance offering.
     */
    public List<PricingDetail> pricingDetails() {
        return pricingDetails;
    }

    /**
     * <p>
     * The recurring charge tag assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The recurring charge tag assigned to the resource.
     */
    public List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeString}.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
     * @see Scope
     */
    public Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeString}.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
     * @see Scope
     */
    public String scopeString() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(productDescriptionString());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyString());
        hashCode = 31 * hashCode + Objects.hashCode(marketplace());
        hashCode = 31 * hashCode + Objects.hashCode(offeringClassString());
        hashCode = 31 * hashCode + Objects.hashCode(offeringTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(recurringCharges());
        hashCode = 31 * hashCode + Objects.hashCode(scopeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesOffering)) {
            return false;
        }
        ReservedInstancesOffering other = (ReservedInstancesOffering) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(duration(), other.duration())
                && Objects.equals(fixedPrice(), other.fixedPrice())
                && Objects.equals(instanceTypeString(), other.instanceTypeString())
                && Objects.equals(productDescriptionString(), other.productDescriptionString())
                && Objects.equals(reservedInstancesOfferingId(), other.reservedInstancesOfferingId())
                && Objects.equals(usagePrice(), other.usagePrice())
                && Objects.equals(currencyCodeString(), other.currencyCodeString())
                && Objects.equals(instanceTenancyString(), other.instanceTenancyString())
                && Objects.equals(marketplace(), other.marketplace())
                && Objects.equals(offeringClassString(), other.offeringClassString())
                && Objects.equals(offeringTypeString(), other.offeringTypeString())
                && Objects.equals(pricingDetails(), other.pricingDetails())
                && Objects.equals(recurringCharges(), other.recurringCharges())
                && Objects.equals(scopeString(), other.scopeString());
    }

    @Override
    public String toString() {
        return ToString.builder("ReservedInstancesOffering").add("AvailabilityZone", availabilityZone())
                .add("Duration", duration()).add("FixedPrice", fixedPrice()).add("InstanceType", instanceTypeString())
                .add("ProductDescription", productDescriptionString())
                .add("ReservedInstancesOfferingId", reservedInstancesOfferingId()).add("UsagePrice", usagePrice())
                .add("CurrencyCode", currencyCodeString()).add("InstanceTenancy", instanceTenancyString())
                .add("Marketplace", marketplace()).add("OfferingClass", offeringClassString())
                .add("OfferingType", offeringTypeString()).add("PricingDetails", pricingDetails())
                .add("RecurringCharges", recurringCharges()).add("Scope", scopeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "Duration":
            return Optional.of(clazz.cast(duration()));
        case "FixedPrice":
            return Optional.of(clazz.cast(fixedPrice()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceTypeString()));
        case "ProductDescription":
            return Optional.of(clazz.cast(productDescriptionString()));
        case "ReservedInstancesOfferingId":
            return Optional.of(clazz.cast(reservedInstancesOfferingId()));
        case "UsagePrice":
            return Optional.of(clazz.cast(usagePrice()));
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCodeString()));
        case "InstanceTenancy":
            return Optional.of(clazz.cast(instanceTenancyString()));
        case "Marketplace":
            return Optional.of(clazz.cast(marketplace()));
        case "OfferingClass":
            return Optional.of(clazz.cast(offeringClassString()));
        case "OfferingType":
            return Optional.of(clazz.cast(offeringTypeString()));
        case "PricingDetails":
            return Optional.of(clazz.cast(pricingDetails()));
        case "RecurringCharges":
            return Optional.of(clazz.cast(recurringCharges()));
        case "Scope":
            return Optional.of(clazz.cast(scopeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstancesOffering> {
        /**
         * <p>
         * The Availability Zone in which the Reserved Instance can be used.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Reserved Instance can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The duration of the Reserved Instance, in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the Reserved Instance, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The purchase price of the Reserved Instance.
         * </p>
         * 
         * @param fixedPrice
         *        The purchase price of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Float fixedPrice);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);

        /**
         * <p>
         * The ID of the Reserved Instance offering. This is the offering ID used in
         * <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
         * </p>
         * 
         * @param reservedInstancesOfferingId
         *        The ID of the Reserved Instance offering. This is the offering ID used in
         *        <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingId(String reservedInstancesOfferingId);

        /**
         * <p>
         * The usage price of the Reserved Instance, per hour.
         * </p>
         * 
         * @param usagePrice
         *        The usage price of the Reserved Instance, per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Float usagePrice);

        /**
         * <p>
         * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
         * currency codes. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217
         *        standard currency codes. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
         * currency codes. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217
         *        standard currency codes. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If
         * it's a Reserved Instance Marketplace offering, this is <code>true</code>.
         * </p>
         * 
         * @param marketplace
         *        Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS.
         *        If it's a Reserved Instance Marketplace offering, this is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplace(Boolean marketplace);

        /**
         * <p>
         * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value,
         * with different configurations. If <code>standard</code>, it is not possible to perform an exchange.
         * </p>
         * 
         * @param offeringClass
         *        If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
         *        value, with different configurations. If <code>standard</code>, it is not possible to perform an
         *        exchange.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value,
         * with different configurations. If <code>standard</code>, it is not possible to perform an exchange.
         * </p>
         * 
         * @param offeringClass
         *        If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
         *        value, with different configurations. If <code>standard</code>, it is not possible to perform an
         *        exchange.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * 
         * @param pricingDetails
         *        The pricing details of the Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingDetails(Collection<PricingDetail> pricingDetails);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * 
         * @param pricingDetails
         *        The pricing details of the Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingDetails(PricingDetail... pricingDetails);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Long duration;

        private Float fixedPrice;

        private String instanceType;

        private String productDescription;

        private String reservedInstancesOfferingId;

        private Float usagePrice;

        private String currencyCode;

        private String instanceTenancy;

        private Boolean marketplace;

        private String offeringClass;

        private String offeringType;

        private List<PricingDetail> pricingDetails;

        private List<RecurringCharge> recurringCharges;

        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesOffering model) {
            availabilityZone(model.availabilityZone);
            duration(model.duration);
            fixedPrice(model.fixedPrice);
            instanceType(model.instanceType);
            productDescription(model.productDescription);
            reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            usagePrice(model.usagePrice);
            currencyCode(model.currencyCode);
            instanceTenancy(model.instanceTenancy);
            marketplace(model.marketplace);
            offeringClass(model.offeringClass);
            offeringType(model.offeringType);
            pricingDetails(model.pricingDetails);
            recurringCharges(model.recurringCharges);
            scope(model.scope);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Float getFixedPrice() {
            return fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getReservedInstancesOfferingId() {
            return reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final Float getUsagePrice() {
            return usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Boolean getMarketplace() {
            return marketplace;
        }

        @Override
        public final Builder marketplace(Boolean marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public final void setMarketplace(Boolean marketplace) {
            this.marketplace = marketplace;
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<PricingDetail.Builder> getPricingDetails() {
            return pricingDetails != null ? pricingDetails.stream().map(PricingDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder pricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(PricingDetail... pricingDetails) {
            pricingDetails(Arrays.asList(pricingDetails));
            return this;
        }

        public final void setPricingDetails(Collection<PricingDetail.BuilderImpl> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copyFromBuilder(pricingDetails);
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return recurringCharges != null ? recurringCharges.stream().map(RecurringCharge::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public ReservedInstancesOffering build() {
            return new ReservedInstancesOffering(this);
        }
    }
}
