/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ReportInstanceStatus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReportInstanceStatusRequest extends EC2Request implements
        ToCopyableBuilder<ReportInstanceStatusRequest.Builder, ReportInstanceStatusRequest> {
    private final String description;

    private final Instant endTime;

    private final List<String> instances;

    private final List<String> reasonCodes;

    private final Instant startTime;

    private final String status;

    private ReportInstanceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.endTime = builder.endTime;
        this.instances = builder.instances;
        this.reasonCodes = builder.reasonCodes;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * Descriptive text about the health state of your instance.
     * </p>
     * 
     * @return Descriptive text about the health state of your instance.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The time at which the reported instance health state ended.
     * </p>
     * 
     * @return The time at which the reported instance health state ended.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * One or more instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instances.
     */
    public List<String> instances() {
        return instances;
    }

    /**
     * <p>
     * One or more reason codes that describe the health state of your instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unresponsive</code>: My instance is unresponsive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>password-not-available</code>: A password is not available for my instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
     * related.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
     * related to the instance stores.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are related
     * to an EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-other</code>: My instance is experiencing performance problems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>other</code>: [explain using the description parameter]
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more reason codes that describe the health state of your instance.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unresponsive</code>: My instance is unresponsive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>password-not-available</code>: A password is not available for my instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-network</code>: My instance is experiencing performance problems that I believe are
     *         network related.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe
     *         are related to the instance stores.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
     *         related to an EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-other</code>: My instance is experiencing performance problems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>other</code>: [explain using the description parameter]
     *         </p>
     *         </li>
     */
    public List<ReportInstanceReasonCodes> reasonCodes() {
        return TypeConverter.convert(reasonCodes, ReportInstanceReasonCodes::fromValue);
    }

    /**
     * <p>
     * One or more reason codes that describe the health state of your instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unresponsive</code>: My instance is unresponsive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>password-not-available</code>: A password is not available for my instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
     * related.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
     * related to the instance stores.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are related
     * to an EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-other</code>: My instance is experiencing performance problems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>other</code>: [explain using the description parameter]
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more reason codes that describe the health state of your instance.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unresponsive</code>: My instance is unresponsive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>password-not-available</code>: A password is not available for my instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-network</code>: My instance is experiencing performance problems that I believe are
     *         network related.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe
     *         are related to the instance stores.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
     *         related to an EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-other</code>: My instance is experiencing performance problems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>other</code>: [explain using the description parameter]
     *         </p>
     *         </li>
     */
    public List<String> reasonCodesStrings() {
        return reasonCodes;
    }

    /**
     * <p>
     * The time at which the reported instance health state began.
     * </p>
     * 
     * @return The time at which the reported instance health state began.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of all instances listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of all instances listed.
     * @see ReportStatusType
     */
    public ReportStatusType status() {
        return ReportStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of all instances listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of all instances listed.
     * @see ReportStatusType
     */
    public String statusString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(reasonCodesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportInstanceStatusRequest)) {
            return false;
        }
        ReportInstanceStatusRequest other = (ReportInstanceStatusRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(instances(), other.instances())
                && Objects.equals(reasonCodesStrings(), other.reasonCodesStrings())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusString(), other.statusString());
    }

    @Override
    public String toString() {
        return ToString.builder("ReportInstanceStatusRequest").add("Description", description()).add("EndTime", endTime())
                .add("Instances", instances()).add("ReasonCodes", reasonCodesStrings()).add("StartTime", startTime())
                .add("Status", statusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "EndTime":
            return Optional.of(clazz.cast(endTime()));
        case "Instances":
            return Optional.of(clazz.cast(instances()));
        case "ReasonCodes":
            return Optional.of(clazz.cast(reasonCodesStrings()));
        case "StartTime":
            return Optional.of(clazz.cast(startTime()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ReportInstanceStatusRequest> {
        /**
         * <p>
         * Descriptive text about the health state of your instance.
         * </p>
         * 
         * @param description
         *        Descriptive text about the health state of your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time at which the reported instance health state ended.
         * </p>
         * 
         * @param endTime
         *        The time at which the reported instance health state ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<String> instances);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(String... instances);

        /**
         * <p>
         * One or more reason codes that describe the health state of your instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unresponsive</code>: My instance is unresponsive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>password-not-available</code>: A password is not available for my instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
         * related.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
         * related to the instance stores.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
         * related to an EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-other</code>: My instance is experiencing performance problems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>other</code>: [explain using the description parameter]
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCodes
         *        One or more reason codes that describe the health state of your instance.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unresponsive</code>: My instance is unresponsive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>password-not-available</code>: A password is not available for my instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-network</code>: My instance is experiencing performance problems that I believe are
         *        network related.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-instance-store</code>: My instance is experiencing performance problems that I
         *        believe are related to the instance stores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe
         *        are related to an EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-other</code>: My instance is experiencing performance problems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>other</code>: [explain using the description parameter]
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCodes(Collection<String> reasonCodes);

        /**
         * <p>
         * One or more reason codes that describe the health state of your instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unresponsive</code>: My instance is unresponsive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>password-not-available</code>: A password is not available for my instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
         * related.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
         * related to the instance stores.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
         * related to an EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-other</code>: My instance is experiencing performance problems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>other</code>: [explain using the description parameter]
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCodes
         *        One or more reason codes that describe the health state of your instance.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unresponsive</code>: My instance is unresponsive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>password-not-available</code>: A password is not available for my instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-network</code>: My instance is experiencing performance problems that I believe are
         *        network related.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-instance-store</code>: My instance is experiencing performance problems that I
         *        believe are related to the instance stores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe
         *        are related to an EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-other</code>: My instance is experiencing performance problems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>other</code>: [explain using the description parameter]
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCodes(String... reasonCodes);

        /**
         * <p>
         * The time at which the reported instance health state began.
         * </p>
         * 
         * @param startTime
         *        The time at which the reported instance health state began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of all instances listed.
         * </p>
         * 
         * @param status
         *        The status of all instances listed.
         * @see ReportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of all instances listed.
         * </p>
         * 
         * @param status
         *        The status of all instances listed.
         * @see ReportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStatusType
         */
        Builder status(ReportStatusType status);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String description;

        private Instant endTime;

        private List<String> instances;

        private List<String> reasonCodes;

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportInstanceStatusRequest model) {
            description(model.description);
            endTime(model.endTime);
            instances(model.instances);
            reasonCodes(model.reasonCodes);
            startTime(model.startTime);
            status(model.status);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<String> getInstances() {
            return instances;
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
        }

        public final Collection<String> getReasonCodes() {
            return reasonCodes;
        }

        @Override
        public final Builder reasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodes(String... reasonCodes) {
            reasonCodes(Arrays.asList(reasonCodes));
            return this;
        }

        public final void setReasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ReportInstanceStatusRequest build() {
            return new ReportInstanceStatusRequest(this);
        }
    }
}
