/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data that identifies an Amazon FPGA image (AFI) on the PCI bus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PciId implements ToCopyableBuilder<PciId.Builder, PciId> {
    private final String deviceId;

    private final String vendorId;

    private final String subsystemId;

    private final String subsystemVendorId;

    private PciId(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.vendorId = builder.vendorId;
        this.subsystemId = builder.subsystemId;
        this.subsystemVendorId = builder.subsystemVendorId;
    }

    /**
     * <p>
     * The ID of the device.
     * </p>
     * 
     * @return The ID of the device.
     */
    public String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The ID of the vendor.
     * </p>
     * 
     * @return The ID of the vendor.
     */
    public String vendorId() {
        return vendorId;
    }

    /**
     * <p>
     * The ID of the subsystem.
     * </p>
     * 
     * @return The ID of the subsystem.
     */
    public String subsystemId() {
        return subsystemId;
    }

    /**
     * <p>
     * The ID of the vendor for the subsystem.
     * </p>
     * 
     * @return The ID of the vendor for the subsystem.
     */
    public String subsystemVendorId() {
        return subsystemVendorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(vendorId());
        hashCode = 31 * hashCode + Objects.hashCode(subsystemId());
        hashCode = 31 * hashCode + Objects.hashCode(subsystemVendorId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PciId)) {
            return false;
        }
        PciId other = (PciId) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(vendorId(), other.vendorId())
                && Objects.equals(subsystemId(), other.subsystemId())
                && Objects.equals(subsystemVendorId(), other.subsystemVendorId());
    }

    @Override
    public String toString() {
        return ToString.builder("PciId").add("DeviceId", deviceId()).add("VendorId", vendorId())
                .add("SubsystemId", subsystemId()).add("SubsystemVendorId", subsystemVendorId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.of(clazz.cast(deviceId()));
        case "VendorId":
            return Optional.of(clazz.cast(vendorId()));
        case "SubsystemId":
            return Optional.of(clazz.cast(subsystemId()));
        case "SubsystemVendorId":
            return Optional.of(clazz.cast(subsystemVendorId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PciId> {
        /**
         * <p>
         * The ID of the device.
         * </p>
         * 
         * @param deviceId
         *        The ID of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The ID of the vendor.
         * </p>
         * 
         * @param vendorId
         *        The ID of the vendor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorId(String vendorId);

        /**
         * <p>
         * The ID of the subsystem.
         * </p>
         * 
         * @param subsystemId
         *        The ID of the subsystem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subsystemId(String subsystemId);

        /**
         * <p>
         * The ID of the vendor for the subsystem.
         * </p>
         * 
         * @param subsystemVendorId
         *        The ID of the vendor for the subsystem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subsystemVendorId(String subsystemVendorId);
    }

    static final class BuilderImpl implements Builder {
        private String deviceId;

        private String vendorId;

        private String subsystemId;

        private String subsystemVendorId;

        private BuilderImpl() {
        }

        private BuilderImpl(PciId model) {
            deviceId(model.deviceId);
            vendorId(model.vendorId);
            subsystemId(model.subsystemId);
            subsystemVendorId(model.subsystemVendorId);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getVendorId() {
            return vendorId;
        }

        @Override
        public final Builder vendorId(String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        public final void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public final String getSubsystemId() {
            return subsystemId;
        }

        @Override
        public final Builder subsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
            return this;
        }

        public final void setSubsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
        }

        public final String getSubsystemVendorId() {
            return subsystemVendorId;
        }

        @Override
        public final Builder subsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
            return this;
        }

        public final void setSubsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
        }

        @Override
        public PciId build() {
            return new PciId(this);
        }
    }
}
