/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instance type that the Dedicated Host supports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceCapacity implements ToCopyableBuilder<InstanceCapacity.Builder, InstanceCapacity> {
    private final Integer availableCapacity;

    private final String instanceType;

    private final Integer totalCapacity;

    private InstanceCapacity(BuilderImpl builder) {
        this.availableCapacity = builder.availableCapacity;
        this.instanceType = builder.instanceType;
        this.totalCapacity = builder.totalCapacity;
    }

    /**
     * <p>
     * The number of instances that can still be launched onto the Dedicated Host.
     * </p>
     * 
     * @return The number of instances that can still be launched onto the Dedicated Host.
     */
    public Integer availableCapacity() {
        return availableCapacity;
    }

    /**
     * <p>
     * The instance type size supported by the Dedicated Host.
     * </p>
     * 
     * @return The instance type size supported by the Dedicated Host.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The total number of instances that can be launched onto the Dedicated Host.
     * </p>
     * 
     * @return The total number of instances that can be launched onto the Dedicated Host.
     */
    public Integer totalCapacity() {
        return totalCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(totalCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCapacity)) {
            return false;
        }
        InstanceCapacity other = (InstanceCapacity) obj;
        return Objects.equals(availableCapacity(), other.availableCapacity())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(totalCapacity(), other.totalCapacity());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceCapacity").add("AvailableCapacity", availableCapacity())
                .add("InstanceType", instanceType()).add("TotalCapacity", totalCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailableCapacity":
            return Optional.of(clazz.cast(availableCapacity()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "TotalCapacity":
            return Optional.of(clazz.cast(totalCapacity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceCapacity> {
        /**
         * <p>
         * The number of instances that can still be launched onto the Dedicated Host.
         * </p>
         * 
         * @param availableCapacity
         *        The number of instances that can still be launched onto the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableCapacity(Integer availableCapacity);

        /**
         * <p>
         * The instance type size supported by the Dedicated Host.
         * </p>
         * 
         * @param instanceType
         *        The instance type size supported by the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The total number of instances that can be launched onto the Dedicated Host.
         * </p>
         * 
         * @param totalCapacity
         *        The total number of instances that can be launched onto the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCapacity(Integer totalCapacity);
    }

    static final class BuilderImpl implements Builder {
        private Integer availableCapacity;

        private String instanceType;

        private Integer totalCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCapacity model) {
            availableCapacity(model.availableCapacity);
            instanceType(model.instanceType);
            totalCapacity(model.totalCapacity);
        }

        public final Integer getAvailableCapacity() {
            return availableCapacity;
        }

        @Override
        public final Builder availableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final void setAvailableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getTotalCapacity() {
            return totalCapacity;
        }

        @Override
        public final Builder totalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
            return this;
        }

        public final void setTotalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        @Override
        public InstanceCapacity build() {
            return new InstanceCapacity(this);
        }
    }
}
