/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for ImportImage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportImageResponse extends EC2Response implements
        ToCopyableBuilder<ImportImageResponse.Builder, ImportImageResponse> {
    private final String architecture;

    private final String description;

    private final String hypervisor;

    private final String imageId;

    private final String importTaskId;

    private final String licenseType;

    private final String platform;

    private final String progress;

    private final List<SnapshotDetail> snapshotDetails;

    private final String status;

    private final String statusMessage;

    private ImportImageResponse(BuilderImpl builder) {
        super(builder);
        this.architecture = builder.architecture;
        this.description = builder.description;
        this.hypervisor = builder.hypervisor;
        this.imageId = builder.imageId;
        this.importTaskId = builder.importTaskId;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.progress = builder.progress;
        this.snapshotDetails = builder.snapshotDetails;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The architecture of the virtual machine.
     * </p>
     * 
     * @return The architecture of the virtual machine.
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * A description of the import task.
     * </p>
     * 
     * @return A description of the import task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The target hypervisor of the import task.
     * </p>
     * 
     * @return The target hypervisor of the import task.
     */
    public String hypervisor() {
        return hypervisor;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) created by the import task.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) created by the import task.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The task ID of the import image task.
     * </p>
     * 
     * @return The task ID of the import image task.
     */
    public String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * The license type of the virtual machine.
     * </p>
     * 
     * @return The license type of the virtual machine.
     */
    public String licenseType() {
        return licenseType;
    }

    /**
     * <p>
     * The operating system of the virtual machine.
     * </p>
     * 
     * @return The operating system of the virtual machine.
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The progress of the task.
     * </p>
     * 
     * @return The progress of the task.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * Information about the snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the snapshots.
     */
    public List<SnapshotDetail> snapshotDetails() {
        return snapshotDetails;
    }

    /**
     * <p>
     * A brief status of the task.
     * </p>
     * 
     * @return A brief status of the task.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A detailed status message of the import task.
     * </p>
     * 
     * @return A detailed status message of the import task.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisor());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(licenseType());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotDetails());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageResponse)) {
            return false;
        }
        ImportImageResponse other = (ImportImageResponse) obj;
        return Objects.equals(architecture(), other.architecture()) && Objects.equals(description(), other.description())
                && Objects.equals(hypervisor(), other.hypervisor()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(importTaskId(), other.importTaskId()) && Objects.equals(licenseType(), other.licenseType())
                && Objects.equals(platform(), other.platform()) && Objects.equals(progress(), other.progress())
                && Objects.equals(snapshotDetails(), other.snapshotDetails()) && Objects.equals(status(), other.status())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("ImportImageResponse").add("Architecture", architecture()).add("Description", description())
                .add("Hypervisor", hypervisor()).add("ImageId", imageId()).add("ImportTaskId", importTaskId())
                .add("LicenseType", licenseType()).add("Platform", platform()).add("Progress", progress())
                .add("SnapshotDetails", snapshotDetails()).add("Status", status()).add("StatusMessage", statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Architecture":
            return Optional.of(clazz.cast(architecture()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Hypervisor":
            return Optional.of(clazz.cast(hypervisor()));
        case "ImageId":
            return Optional.of(clazz.cast(imageId()));
        case "ImportTaskId":
            return Optional.of(clazz.cast(importTaskId()));
        case "LicenseType":
            return Optional.of(clazz.cast(licenseType()));
        case "Platform":
            return Optional.of(clazz.cast(platform()));
        case "Progress":
            return Optional.of(clazz.cast(progress()));
        case "SnapshotDetails":
            return Optional.of(clazz.cast(snapshotDetails()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, ImportImageResponse> {
        /**
         * <p>
         * The architecture of the virtual machine.
         * </p>
         * 
         * @param architecture
         *        The architecture of the virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * A description of the import task.
         * </p>
         * 
         * @param description
         *        A description of the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The target hypervisor of the import task.
         * </p>
         * 
         * @param hypervisor
         *        The target hypervisor of the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) created by the import task.
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI) created by the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The task ID of the import image task.
         * </p>
         * 
         * @param importTaskId
         *        The task ID of the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * The license type of the virtual machine.
         * </p>
         * 
         * @param licenseType
         *        The license type of the virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The operating system of the virtual machine.
         * </p>
         * 
         * @param platform
         *        The operating system of the virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The progress of the task.
         * </p>
         * 
         * @param progress
         *        The progress of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshotDetails
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDetails(Collection<SnapshotDetail> snapshotDetails);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshotDetails
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDetails(SnapshotDetail... snapshotDetails);

        /**
         * <p>
         * A brief status of the task.
         * </p>
         * 
         * @param status
         *        A brief status of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A detailed status message of the import task.
         * </p>
         * 
         * @param statusMessage
         *        A detailed status message of the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String architecture;

        private String description;

        private String hypervisor;

        private String imageId;

        private String importTaskId;

        private String licenseType;

        private String platform;

        private String progress;

        private List<SnapshotDetail> snapshotDetails;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageResponse model) {
            architecture(model.architecture);
            description(model.description);
            hypervisor(model.hypervisor);
            imageId(model.imageId);
            importTaskId(model.importTaskId);
            licenseType(model.licenseType);
            platform(model.platform);
            progress(model.progress);
            snapshotDetails(model.snapshotDetails);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final Collection<SnapshotDetail.Builder> getSnapshotDetails() {
            return snapshotDetails != null ? snapshotDetails.stream().map(SnapshotDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder snapshotDetails(Collection<SnapshotDetail> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copy(snapshotDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotDetails(SnapshotDetail... snapshotDetails) {
            snapshotDetails(Arrays.asList(snapshotDetails));
            return this;
        }

        public final void setSnapshotDetails(Collection<SnapshotDetail.BuilderImpl> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copyFromBuilder(snapshotDetails);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public ImportImageResponse build() {
            return new ImportImageResponse(this);
        }
    }
}
