/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of the bitstream generation process for an Amazon FPGA image (AFI).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FpgaImageState implements ToCopyableBuilder<FpgaImageState.Builder, FpgaImageState> {
    private final String code;

    private final String message;

    private FpgaImageState(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The state. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>pending</code> - AFI bitstream generation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code> - The AFI is available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - AFI bitstream generation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unavailable</code> - The AFI is no longer available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link FpgaImageStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeString}.
     * </p>
     * 
     * @return The state. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>pending</code> - AFI bitstream generation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code> - The AFI is available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - AFI bitstream generation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unavailable</code> - The AFI is no longer available for use.
     *         </p>
     *         </li>
     * @see FpgaImageStateCode
     */
    public FpgaImageStateCode code() {
        return FpgaImageStateCode.fromValue(code);
    }

    /**
     * <p>
     * The state. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>pending</code> - AFI bitstream generation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code> - The AFI is available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - AFI bitstream generation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unavailable</code> - The AFI is no longer available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link FpgaImageStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeString}.
     * </p>
     * 
     * @return The state. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>pending</code> - AFI bitstream generation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code> - The AFI is available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - AFI bitstream generation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unavailable</code> - The AFI is no longer available for use.
     *         </p>
     *         </li>
     * @see FpgaImageStateCode
     */
    public String codeString() {
        return code;
    }

    /**
     * <p>
     * If the state is <code>failed</code>, this is the error message.
     * </p>
     * 
     * @return If the state is <code>failed</code>, this is the error message.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImageState)) {
            return false;
        }
        FpgaImageState other = (FpgaImageState) obj;
        return Objects.equals(codeString(), other.codeString()) && Objects.equals(message(), other.message());
    }

    @Override
    public String toString() {
        return ToString.builder("FpgaImageState").add("Code", codeString()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.of(clazz.cast(codeString()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, FpgaImageState> {
        /**
         * <p>
         * The state. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>pending</code> - AFI bitstream generation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code> - The AFI is available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - AFI bitstream generation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unavailable</code> - The AFI is no longer available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The state. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>pending</code> - AFI bitstream generation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code> - The AFI is available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - AFI bitstream generation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unavailable</code> - The AFI is no longer available for use.
         *        </p>
         *        </li>
         * @see FpgaImageStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageStateCode
         */
        Builder code(String code);

        /**
         * <p>
         * The state. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>pending</code> - AFI bitstream generation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code> - The AFI is available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - AFI bitstream generation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unavailable</code> - The AFI is no longer available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The state. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>pending</code> - AFI bitstream generation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code> - The AFI is available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - AFI bitstream generation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unavailable</code> - The AFI is no longer available for use.
         *        </p>
         *        </li>
         * @see FpgaImageStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageStateCode
         */
        Builder code(FpgaImageStateCode code);

        /**
         * <p>
         * If the state is <code>failed</code>, this is the error message.
         * </p>
         * 
         * @param message
         *        If the state is <code>failed</code>, this is the error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImageState model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(FpgaImageStateCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public FpgaImageState build() {
            return new FpgaImageState(this);
        }
    }
}
