/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpnConnections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpnConnectionsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeVpnConnectionsResponse.Builder, DescribeVpnConnectionsResponse> {
    private final List<VpnConnection> vpnConnections;

    private DescribeVpnConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpnConnections = builder.vpnConnections;
    }

    /**
     * <p>
     * Information about one or more VPN connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more VPN connections.
     */
    public List<VpnConnection> vpnConnections() {
        return vpnConnections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnections());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsResponse)) {
            return false;
        }
        DescribeVpnConnectionsResponse other = (DescribeVpnConnectionsResponse) obj;
        return Objects.equals(vpnConnections(), other.vpnConnections());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVpnConnectionsResponse").add("VpnConnections", vpnConnections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnections":
            return Optional.of(clazz.cast(vpnConnections()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeVpnConnectionsResponse> {
        /**
         * <p>
         * Information about one or more VPN connections.
         * </p>
         * 
         * @param vpnConnections
         *        Information about one or more VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnections(Collection<VpnConnection> vpnConnections);

        /**
         * <p>
         * Information about one or more VPN connections.
         * </p>
         * 
         * @param vpnConnections
         *        Information about one or more VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnections(VpnConnection... vpnConnections);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<VpnConnection> vpnConnections;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsResponse model) {
            vpnConnections(model.vpnConnections);
        }

        public final Collection<VpnConnection.Builder> getVpnConnections() {
            return vpnConnections != null ? vpnConnections.stream().map(VpnConnection::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder vpnConnections(Collection<VpnConnection> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copy(vpnConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnections(VpnConnection... vpnConnections) {
            vpnConnections(Arrays.asList(vpnConnections));
            return this;
        }

        public final void setVpnConnections(Collection<VpnConnection.BuilderImpl> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copyFromBuilder(vpnConnections);
        }

        @Override
        public DescribeVpnConnectionsResponse build() {
            return new DescribeVpnConnectionsResponse(this);
        }
    }
}
