/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpcEndpointServices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcEndpointServicesResponse extends EC2Response implements
        ToCopyableBuilder<DescribeVpcEndpointServicesResponse.Builder, DescribeVpcEndpointServicesResponse> {
    private final List<String> serviceNames;

    private final List<ServiceDetail> serviceDetails;

    private final String nextToken;

    private DescribeVpcEndpointServicesResponse(BuilderImpl builder) {
        super(builder);
        this.serviceNames = builder.serviceNames;
        this.serviceDetails = builder.serviceDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of supported AWS services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of supported AWS services.
     */
    public List<String> serviceNames() {
        return serviceNames;
    }

    /**
     * <p>
     * Information about the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the service.
     */
    public List<ServiceDetail> serviceDetails() {
        return serviceDetails;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceNames());
        hashCode = 31 * hashCode + Objects.hashCode(serviceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServicesResponse)) {
            return false;
        }
        DescribeVpcEndpointServicesResponse other = (DescribeVpcEndpointServicesResponse) obj;
        return Objects.equals(serviceNames(), other.serviceNames()) && Objects.equals(serviceDetails(), other.serviceDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVpcEndpointServicesResponse").add("ServiceNames", serviceNames())
                .add("ServiceDetails", serviceDetails()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceNames":
            return Optional.of(clazz.cast(serviceNames()));
        case "ServiceDetails":
            return Optional.of(clazz.cast(serviceDetails()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
        /**
         * <p>
         * A list of supported AWS services.
         * </p>
         * 
         * @param serviceNames
         *        A list of supported AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNames(Collection<String> serviceNames);

        /**
         * <p>
         * A list of supported AWS services.
         * </p>
         * 
         * @param serviceNames
         *        A list of supported AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNames(String... serviceNames);

        /**
         * <p>
         * Information about the service.
         * </p>
         * 
         * @param serviceDetails
         *        Information about the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDetails(Collection<ServiceDetail> serviceDetails);

        /**
         * <p>
         * Information about the service.
         * </p>
         * 
         * @param serviceDetails
         *        Information about the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDetails(ServiceDetail... serviceDetails);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<String> serviceNames;

        private List<ServiceDetail> serviceDetails;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServicesResponse model) {
            serviceNames(model.serviceNames);
            serviceDetails(model.serviceDetails);
            nextToken(model.nextToken);
        }

        public final Collection<String> getServiceNames() {
            return serviceNames;
        }

        @Override
        public final Builder serviceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(String... serviceNames) {
            serviceNames(Arrays.asList(serviceNames));
            return this;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
        }

        public final Collection<ServiceDetail.Builder> getServiceDetails() {
            return serviceDetails != null ? serviceDetails.stream().map(ServiceDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder serviceDetails(Collection<ServiceDetail> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copy(serviceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDetails(ServiceDetail... serviceDetails) {
            serviceDetails(Arrays.asList(serviceDetails));
            return this;
        }

        public final void setServiceDetails(Collection<ServiceDetail.BuilderImpl> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copyFromBuilder(serviceDetails);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointServicesResponse build() {
            return new DescribeVpcEndpointServicesResponse(this);
        }
    }
}
