/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribePlacementGroups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePlacementGroupsResponse extends EC2Response implements
        ToCopyableBuilder<DescribePlacementGroupsResponse.Builder, DescribePlacementGroupsResponse> {
    private final List<PlacementGroup> placementGroups;

    private DescribePlacementGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.placementGroups = builder.placementGroups;
    }

    /**
     * <p>
     * One or more placement groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more placement groups.
     */
    public List<PlacementGroup> placementGroups() {
        return placementGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(placementGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlacementGroupsResponse)) {
            return false;
        }
        DescribePlacementGroupsResponse other = (DescribePlacementGroupsResponse) obj;
        return Objects.equals(placementGroups(), other.placementGroups());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePlacementGroupsResponse").add("PlacementGroups", placementGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlacementGroups":
            return Optional.of(clazz.cast(placementGroups()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribePlacementGroupsResponse> {
        /**
         * <p>
         * One or more placement groups.
         * </p>
         * 
         * @param placementGroups
         *        One or more placement groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroups(Collection<PlacementGroup> placementGroups);

        /**
         * <p>
         * One or more placement groups.
         * </p>
         * 
         * @param placementGroups
         *        One or more placement groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroups(PlacementGroup... placementGroups);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<PlacementGroup> placementGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlacementGroupsResponse model) {
            placementGroups(model.placementGroups);
        }

        public final Collection<PlacementGroup.Builder> getPlacementGroups() {
            return placementGroups != null ? placementGroups.stream().map(PlacementGroup::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder placementGroups(Collection<PlacementGroup> placementGroups) {
            this.placementGroups = PlacementGroupListCopier.copy(placementGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroups(PlacementGroup... placementGroups) {
            placementGroups(Arrays.asList(placementGroups));
            return this;
        }

        public final void setPlacementGroups(Collection<PlacementGroup.BuilderImpl> placementGroups) {
            this.placementGroups = PlacementGroupListCopier.copyFromBuilder(placementGroups);
        }

        @Override
        public DescribePlacementGroupsResponse build() {
            return new DescribePlacementGroupsResponse(this);
        }
    }
}
