/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeBundleTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeBundleTasksResponse extends EC2Response implements
        ToCopyableBuilder<DescribeBundleTasksResponse.Builder, DescribeBundleTasksResponse> {
    private final List<BundleTask> bundleTasks;

    private DescribeBundleTasksResponse(BuilderImpl builder) {
        super(builder);
        this.bundleTasks = builder.bundleTasks;
    }

    /**
     * <p>
     * Information about one or more bundle tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more bundle tasks.
     */
    public List<BundleTask> bundleTasks() {
        return bundleTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleTasks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBundleTasksResponse)) {
            return false;
        }
        DescribeBundleTasksResponse other = (DescribeBundleTasksResponse) obj;
        return Objects.equals(bundleTasks(), other.bundleTasks());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeBundleTasksResponse").add("BundleTasks", bundleTasks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleTasks":
            return Optional.of(clazz.cast(bundleTasks()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeBundleTasksResponse> {
        /**
         * <p>
         * Information about one or more bundle tasks.
         * </p>
         * 
         * @param bundleTasks
         *        Information about one or more bundle tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleTasks(Collection<BundleTask> bundleTasks);

        /**
         * <p>
         * Information about one or more bundle tasks.
         * </p>
         * 
         * @param bundleTasks
         *        Information about one or more bundle tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleTasks(BundleTask... bundleTasks);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<BundleTask> bundleTasks;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBundleTasksResponse model) {
            bundleTasks(model.bundleTasks);
        }

        public final Collection<BundleTask.Builder> getBundleTasks() {
            return bundleTasks != null ? bundleTasks.stream().map(BundleTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bundleTasks(Collection<BundleTask> bundleTasks) {
            this.bundleTasks = BundleTaskListCopier.copy(bundleTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleTasks(BundleTask... bundleTasks) {
            bundleTasks(Arrays.asList(bundleTasks));
            return this;
        }

        public final void setBundleTasks(Collection<BundleTask.BuilderImpl> bundleTasks) {
            this.bundleTasks = BundleTaskListCopier.copyFromBuilder(bundleTasks);
        }

        @Override
        public DescribeBundleTasksResponse build() {
            return new DescribeBundleTasksResponse(this);
        }
    }
}
