/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelConversionTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelConversionTaskRequest extends EC2Request implements
        ToCopyableBuilder<CancelConversionTaskRequest.Builder, CancelConversionTaskRequest> {
    private final String conversionTaskId;

    private final String reasonMessage;

    private CancelConversionTaskRequest(BuilderImpl builder) {
        super(builder);
        this.conversionTaskId = builder.conversionTaskId;
        this.reasonMessage = builder.reasonMessage;
    }

    /**
     * <p>
     * The ID of the conversion task.
     * </p>
     * 
     * @return The ID of the conversion task.
     */
    public String conversionTaskId() {
        return conversionTaskId;
    }

    /**
     * <p>
     * The reason for canceling the conversion task.
     * </p>
     * 
     * @return The reason for canceling the conversion task.
     */
    public String reasonMessage() {
        return reasonMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversionTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(reasonMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelConversionTaskRequest)) {
            return false;
        }
        CancelConversionTaskRequest other = (CancelConversionTaskRequest) obj;
        return Objects.equals(conversionTaskId(), other.conversionTaskId())
                && Objects.equals(reasonMessage(), other.reasonMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("CancelConversionTaskRequest").add("ConversionTaskId", conversionTaskId())
                .add("ReasonMessage", reasonMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConversionTaskId":
            return Optional.of(clazz.cast(conversionTaskId()));
        case "ReasonMessage":
            return Optional.of(clazz.cast(reasonMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CancelConversionTaskRequest> {
        /**
         * <p>
         * The ID of the conversion task.
         * </p>
         * 
         * @param conversionTaskId
         *        The ID of the conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTaskId(String conversionTaskId);

        /**
         * <p>
         * The reason for canceling the conversion task.
         * </p>
         * 
         * @param reasonMessage
         *        The reason for canceling the conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonMessage(String reasonMessage);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String conversionTaskId;

        private String reasonMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelConversionTaskRequest model) {
            conversionTaskId(model.conversionTaskId);
            reasonMessage(model.reasonMessage);
        }

        public final String getConversionTaskId() {
            return conversionTaskId;
        }

        @Override
        public final Builder conversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
            return this;
        }

        public final void setConversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
        }

        public final String getReasonMessage() {
            return reasonMessage;
        }

        @Override
        public final Builder reasonMessage(String reasonMessage) {
            this.reasonMessage = reasonMessage;
            return this;
        }

        public final void setReasonMessage(String reasonMessage) {
            this.reasonMessage = reasonMessage;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CancelConversionTaskRequest build() {
            return new CancelConversionTaskRequest(this);
        }
    }
}
