/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of AttachNetworkInterface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachNetworkInterfaceResponse extends EC2Response implements
        ToCopyableBuilder<AttachNetworkInterfaceResponse.Builder, AttachNetworkInterfaceResponse> {
    private final String attachmentId;

    private AttachNetworkInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
    }

    /**
     * <p>
     * The ID of the network interface attachment.
     * </p>
     * 
     * @return The ID of the network interface attachment.
     */
    public String attachmentId() {
        return attachmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachNetworkInterfaceResponse)) {
            return false;
        }
        AttachNetworkInterfaceResponse other = (AttachNetworkInterfaceResponse) obj;
        return Objects.equals(attachmentId(), other.attachmentId());
    }

    @Override
    public String toString() {
        return ToString.builder("AttachNetworkInterfaceResponse").add("AttachmentId", attachmentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.of(clazz.cast(attachmentId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, AttachNetworkInterfaceResponse> {
        /**
         * <p>
         * The ID of the network interface attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String attachmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachNetworkInterfaceResponse model) {
            attachmentId(model.attachmentId);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public AttachNetworkInterfaceResponse build() {
            return new AttachNetworkInterfaceResponse(this);
        }
    }
}
