/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SdkAsyncClientHandler;
import software.amazon.awssdk.core.config.AsyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.core.http.StaxResponseHandler;
import software.amazon.awssdk.core.runtime.transform.LegacyErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.AllocateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AllocateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AllocateHostsRequest;
import software.amazon.awssdk.services.ec2.model.AllocateHostsResponse;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.AttachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.BundleInstanceRequest;
import software.amazon.awssdk.services.ec2.model.BundleInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CopyImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyImageResponse;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CopySnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.CreateTagsResponse;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.CreateVolumeResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTagsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterImageRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterImageResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DetachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DetachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.EC2Exception;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIORequest;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIOResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.ImportImageRequest;
import software.amazon.awssdk.services.ec2.model.ImportImageResponse;
import software.amazon.awssdk.services.ec2.model.ImportInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ImportInstanceResponse;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.ImportVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ImportVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyHostsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyHostsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementResponse;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestResponse;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyResponse;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcRequest;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RebootInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterImageRequest;
import software.amazon.awssdk.services.ec2.model.RegisterImageResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StartInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StopInstancesResponse;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse;
import software.amazon.awssdk.services.ec2.transform.AcceptReservedInstancesExchangeQuoteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptReservedInstancesExchangeQuoteResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptVpcPeeringConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateAddressResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateHostsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignIpv6AddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignIpv6AddressesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignPrivateIpAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignPrivateIpAddressesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateAddressResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateDhcpOptionsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateIamInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateIamInstanceProfileResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateRouteTableResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateSubnetCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateSubnetCidrBlockResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateVpcCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateVpcCidrBlockResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachClassicLinkVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachClassicLinkVpcResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachInternetGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachNetworkInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVpnGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupEgressResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupIngressResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.BundleInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.BundleInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelBundleTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelBundleTaskResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelConversionTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelConversionTaskResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelExportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelExportTaskResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelImportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelImportTaskResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelReservedInstancesListingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelReservedInstancesListingResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotFleetRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotFleetRequestsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotInstanceRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotInstanceRequestsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ConfirmProductInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ConfirmProductInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyFpgaImageResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyImageResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCustomerGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultSubnetResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultVpcResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDhcpOptionsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateEgressOnlyInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateEgressOnlyInternetGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFlowLogsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFpgaImageResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateImageResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInstanceExportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInstanceExportTaskResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInternetGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNatGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNatGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclEntryResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfacePermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfacePermissionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreatePlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreatePlacementGroupResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateReservedInstancesListingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateReservedInstancesListingResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteTableResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSecurityGroupResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSpotDatafeedSubscriptionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSubnetResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTagsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcPeeringConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionRouteResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCustomerGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteDhcpOptionsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteEgressOnlyInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteEgressOnlyInternetGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFlowLogsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFpgaImageResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteInternetGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNatGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNatGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclEntryResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfacePermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfacePermissionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeletePlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeletePlacementGroupResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteTableResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSecurityGroupResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSpotDatafeedSubscriptionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSubnetResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTagsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcPeeringConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionRouteResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterImageResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAccountAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAddressesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAvailabilityZonesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAvailabilityZonesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeBundleTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeBundleTasksResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClassicLinkInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClassicLinkInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeConversionTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeConversionTasksResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCustomerGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCustomerGatewaysResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeDhcpOptionsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeEgressOnlyInternetGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeEgressOnlyInternetGatewaysResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeElasticGpusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeElasticGpusResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeExportTasksResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFlowLogsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImageAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImagesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationOfferingsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIamInstanceProfileAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIamInstanceProfileAssociationsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdFormatResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdentityIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdentityIdFormatResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImageAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImagesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportImageTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportImageTasksResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportSnapshotTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportSnapshotTasksResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceStatusResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInternetGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInternetGatewaysResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeKeyPairsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeMovingAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeMovingAddressesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNatGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNatGatewaysResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkAclsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkAclsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfaceAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacePermissionsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePlacementGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePlacementGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePrefixListsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePrefixListsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRegionsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesListingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesListingsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesModificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesModificationsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesOfferingsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRouteTablesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstanceAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstanceAvailabilityResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupReferencesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupReferencesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotDatafeedSubscriptionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestHistoryResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotInstanceRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotInstanceRequestsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotPriceHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotPriceHistoryResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeStaleSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeStaleSecurityGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSubnetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSubnetsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTagsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeStatusResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesModificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesModificationsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkDnsSupportResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServicesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServicesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcPeeringConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcPeeringConnectionsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnConnectionsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnGatewaysResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachClassicLinkVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachClassicLinkVpcResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachInternetGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachNetworkInterfaceResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVpnGatewayResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVgwRoutePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVgwRoutePropagationResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkDnsSupportResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateAddressResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateIamInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateIamInstanceProfileResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateRouteTableResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateSubnetCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateSubnetCidrBlockResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateVpcCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateVpcCidrBlockResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVgwRoutePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVgwRoutePropagationResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVolumeIORequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVolumeIOResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkDnsSupportResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleOutputRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleOutputResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleScreenshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleScreenshotResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.GetHostReservationPurchasePreviewRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetHostReservationPurchasePreviewResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.GetPasswordDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetPasswordDataResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.GetReservedInstancesExchangeQuoteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetReservedInstancesExchangeQuoteResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportImageResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportKeyPairResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyFpgaImageAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyHostsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdFormatResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdentityIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdentityIdFormatResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyImageAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstancePlacementRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstancePlacementResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyNetworkInterfaceAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyReservedInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySnapshotAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySpotFleetRequestRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySpotFleetRequestResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySubnetAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySubnetAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcPeeringConnectionOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcPeeringConnectionOptionsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcTenancyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcTenancyResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.MonitorInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MonitorInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.MoveAddressToVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MoveAddressToVpcResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseHostReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseHostReservationResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseReservedInstancesOfferingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseReservedInstancesOfferingResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseScheduledInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RebootInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RebootInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterImageResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectVpcPeeringConnectionResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseAddressResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseHostsResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceIamInstanceProfileAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceIamInstanceProfileAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclEntryResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteTableAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteTableAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ReportInstanceStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReportInstanceStatusResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotFleetResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetFpgaImageAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetImageAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetInstanceAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetNetworkInterfaceAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetSnapshotAttributeResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreAddressToClassicRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreAddressToClassicResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupEgressResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupIngressResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RunInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RunInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RunScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RunScheduledInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.StartInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.StopInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StopInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TerminateInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.TerminateInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignIpv6AddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignIpv6AddressesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignPrivateIpAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignPrivateIpAddressesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.UnmonitorInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnmonitorInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsEgressResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsIngressResponseUnmarshaller;

/**
 * Internal implementation of {@link EC2AsyncClient}.
 *
 * @see EC2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultEC2AsyncClient implements EC2AsyncClient {
    private final AsyncClientHandler clientHandler;

    private final List<Unmarshaller<SdkServiceException, Node>> exceptionUnmarshallers;

    protected DefaultEC2AsyncClient(AsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkAsyncClientHandler(clientConfiguration, null);
        this.exceptionUnmarshallers = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     *
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        Contains the parameters for accepting the quote.
     * @return A Java Future containing the result of the AcceptReservedInstancesExchangeQuote operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AcceptReservedInstancesExchangeQuote
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptReservedInstancesExchangeQuoteResponse> acceptReservedInstancesExchangeQuote(
            AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest) {

        StaxResponseHandler<AcceptReservedInstancesExchangeQuoteResponse> responseHandler = new StaxResponseHandler<AcceptReservedInstancesExchangeQuoteResponse>(
                new AcceptReservedInstancesExchangeQuoteResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<AcceptReservedInstancesExchangeQuoteRequest, AcceptReservedInstancesExchangeQuoteResponse>()
                        .withMarshaller(new AcceptReservedInstancesExchangeQuoteRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(acceptReservedInstancesExchangeQuoteRequest));
    }

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     *
     * @param acceptVpcPeeringConnectionRequest
     *        Contains the parameters for AcceptVpcPeeringConnection.
     * @return A Java Future containing the result of the AcceptVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AcceptVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptVpcPeeringConnectionResponse> acceptVpcPeeringConnection(
            AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest) {

        StaxResponseHandler<AcceptVpcPeeringConnectionResponse> responseHandler = new StaxResponseHandler<AcceptVpcPeeringConnectionResponse>(
                new AcceptVpcPeeringConnectionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<AcceptVpcPeeringConnectionRequest, AcceptVpcPeeringConnectionResponse>()
                        .withMarshaller(new AcceptVpcPeeringConnectionRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(acceptVpcPeeringConnectionRequest));
    }

    /**
     * <p>
     * Allocates an Elastic IP address.
     * </p>
     * <p>
     * An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5
     * Elastic IP addresses for EC2-Classic per region and 5 Elastic IP addresses for EC2-VPC per region.
     * </p>
     * <p>
     * If you release an Elastic IP address for use in a VPC, you might be able to recover it. To recover an Elastic IP
     * address that you released, specify it in the <code>Address</code> parameter. Note that you cannot recover an
     * Elastic IP address that you released after it is allocated to another AWS account.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param allocateAddressRequest
     *        Contains the parameters for AllocateAddress.
     * @return A Java Future containing the result of the AllocateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AllocateAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateAddressResponse> allocateAddress(AllocateAddressRequest allocateAddressRequest) {

        StaxResponseHandler<AllocateAddressResponse> responseHandler = new StaxResponseHandler<AllocateAddressResponse>(
                new AllocateAddressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AllocateAddressRequest, AllocateAddressResponse>()
                .withMarshaller(new AllocateAddressRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(allocateAddressRequest));
    }

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At minimum you need to specify the instance size type, Availability
     * Zone, and quantity of hosts you want to allocate.
     * </p>
     *
     * @param allocateHostsRequest
     *        Contains the parameters for AllocateHosts.
     * @return A Java Future containing the result of the AllocateHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AllocateHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateHostsResponse> allocateHosts(AllocateHostsRequest allocateHostsRequest) {

        StaxResponseHandler<AllocateHostsResponse> responseHandler = new StaxResponseHandler<AllocateHostsResponse>(
                new AllocateHostsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AllocateHostsRequest, AllocateHostsResponse>()
                .withMarshaller(new AllocateHostsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(allocateHostsRequest));
    }

    /**
     * <p>
     * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6
     * addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's
     * IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per
     * Network Interface Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param assignIpv6AddressesRequest
     * @return A Java Future containing the result of the AssignIpv6Addresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AssignIpv6Addresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssignIpv6AddressesResponse> assignIpv6Addresses(
            AssignIpv6AddressesRequest assignIpv6AddressesRequest) {

        StaxResponseHandler<AssignIpv6AddressesResponse> responseHandler = new StaxResponseHandler<AssignIpv6AddressesResponse>(
                new AssignIpv6AddressesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AssignIpv6AddressesRequest, AssignIpv6AddressesResponse>()
                .withMarshaller(new AssignIpv6AddressesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(assignIpv6AddressesRequest));
    }

    /**
     * <p>
     * Assigns one or more secondary private IP addresses to the specified network interface. You can specify one or
     * more specific secondary IP addresses, or you can specify the number of secondary IP addresses to be automatically
     * assigned within the subnet's CIDR block range. The number of secondary IP addresses that you can assign to an
     * instance varies by instance type. For information about instance types, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * AssignPrivateIpAddresses is available only in EC2-VPC.
     * </p>
     *
     * @param assignPrivateIpAddressesRequest
     *        Contains the parameters for AssignPrivateIpAddresses.
     * @return A Java Future containing the result of the AssignPrivateIpAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AssignPrivateIpAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssignPrivateIpAddressesResponse> assignPrivateIpAddresses(
            AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) {

        StaxResponseHandler<AssignPrivateIpAddressesResponse> responseHandler = new StaxResponseHandler<AssignPrivateIpAddressesResponse>(
                new AssignPrivateIpAddressesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<AssignPrivateIpAddressesRequest, AssignPrivateIpAddressesResponse>()
                        .withMarshaller(new AssignPrivateIpAddressesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(assignPrivateIpAddressesRequest));
    }

    /**
     * <p>
     * Associates an Elastic IP address with an instance or a network interface.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different
     * instance, it is disassociated from that instance and associated with the specified instance. If you associate an
     * Elastic IP address with an instance that has an existing Elastic IP address, the existing address is
     * disassociated from the instance, but remains allocated to your account.
     * </p>
     * <p>
     * [VPC in an EC2-Classic account] If you don't specify a private IP address, the Elastic IP address is associated
     * with the primary IP address. If the Elastic IP address is already associated with a different instance or a
     * network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address
     * with an instance or network interface that has an existing Elastic IP address.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     *
     * @param associateAddressRequest
     *        Contains the parameters for AssociateAddress.
     * @return A Java Future containing the result of the AssociateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AssociateAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAddressResponse> associateAddress(AssociateAddressRequest associateAddressRequest) {

        StaxResponseHandler<AssociateAddressResponse> responseHandler = new StaxResponseHandler<AssociateAddressResponse>(
                new AssociateAddressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AssociateAddressRequest, AssociateAddressResponse>()
                .withMarshaller(new AssociateAddressRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(associateAddressRequest));
    }

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param associateDhcpOptionsRequest
     *        Contains the parameters for AssociateDhcpOptions.
     * @return A Java Future containing the result of the AssociateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AssociateDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateDhcpOptionsResponse> associateDhcpOptions(
            AssociateDhcpOptionsRequest associateDhcpOptionsRequest) {

        StaxResponseHandler<AssociateDhcpOptionsResponse> responseHandler = new StaxResponseHandler<AssociateDhcpOptionsResponse>(
                new AssociateDhcpOptionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AssociateDhcpOptionsRequest, AssociateDhcpOptionsResponse>()
                .withMarshaller(new AssociateDhcpOptionsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(associateDhcpOptionsRequest));
    }

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     *
     * @param associateIamInstanceProfileRequest
     * @return A Java Future containing the result of the AssociateIamInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AssociateIamInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateIamInstanceProfileResponse> associateIamInstanceProfile(
            AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest) {

        StaxResponseHandler<AssociateIamInstanceProfileResponse> responseHandler = new StaxResponseHandler<AssociateIamInstanceProfileResponse>(
                new AssociateIamInstanceProfileResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateIamInstanceProfileRequest, AssociateIamInstanceProfileResponse>()
                        .withMarshaller(new AssociateIamInstanceProfileRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(associateIamInstanceProfileRequest));
    }

    /**
     * <p>
     * Associates a subnet with a route table. The subnet and route table must be in the same VPC. This association
     * causes traffic originating from the subnet to be routed according to the routes in the route table. The action
     * returns an association ID, which you need in order to disassociate the route table from the subnet later. A route
     * table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param associateRouteTableRequest
     *        Contains the parameters for AssociateRouteTable.
     * @return A Java Future containing the result of the AssociateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AssociateRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateRouteTableResponse> associateRouteTable(
            AssociateRouteTableRequest associateRouteTableRequest) {

        StaxResponseHandler<AssociateRouteTableResponse> responseHandler = new StaxResponseHandler<AssociateRouteTableResponse>(
                new AssociateRouteTableResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AssociateRouteTableRequest, AssociateRouteTableResponse>()
                .withMarshaller(new AssociateRouteTableRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(associateRouteTableRequest));
    }

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet. An
     * IPv6 CIDR block must have a prefix length of /64.
     * </p>
     *
     * @param associateSubnetCidrBlockRequest
     * @return A Java Future containing the result of the AssociateSubnetCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AssociateSubnetCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateSubnetCidrBlockResponse> associateSubnetCidrBlock(
            AssociateSubnetCidrBlockRequest associateSubnetCidrBlockRequest) {

        StaxResponseHandler<AssociateSubnetCidrBlockResponse> responseHandler = new StaxResponseHandler<AssociateSubnetCidrBlockResponse>(
                new AssociateSubnetCidrBlockResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateSubnetCidrBlockRequest, AssociateSubnetCidrBlockResponse>()
                        .withMarshaller(new AssociateSubnetCidrBlockRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(associateSubnetCidrBlockRequest));
    }

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, or you can associate an
     * Amazon-provided IPv6 CIDR block. The IPv6 CIDR block size is fixed at /56.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html#VPC_Sizing">VPC and Subnet
     * Sizing</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param associateVpcCidrBlockRequest
     * @return A Java Future containing the result of the AssociateVpcCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AssociateVpcCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateVpcCidrBlockResponse> associateVpcCidrBlock(
            AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest) {

        StaxResponseHandler<AssociateVpcCidrBlockResponse> responseHandler = new StaxResponseHandler<AssociateVpcCidrBlockResponse>(
                new AssociateVpcCidrBlockResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AssociateVpcCidrBlockRequest, AssociateVpcCidrBlockResponse>()
                .withMarshaller(new AssociateVpcCidrBlockRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(associateVpcCidrBlockRequest));
    }

    /**
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     *
     * @param attachClassicLinkVpcRequest
     *        Contains the parameters for AttachClassicLinkVpc.
     * @return A Java Future containing the result of the AttachClassicLinkVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AttachClassicLinkVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachClassicLinkVpcResponse> attachClassicLinkVpc(
            AttachClassicLinkVpcRequest attachClassicLinkVpcRequest) {

        StaxResponseHandler<AttachClassicLinkVpcResponse> responseHandler = new StaxResponseHandler<AttachClassicLinkVpcResponse>(
                new AttachClassicLinkVpcResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AttachClassicLinkVpcRequest, AttachClassicLinkVpcResponse>()
                .withMarshaller(new AttachClassicLinkVpcRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(attachClassicLinkVpcRequest));
    }

    /**
     * <p>
     * Attaches an Internet gateway to a VPC, enabling connectivity between the Internet and the VPC. For more
     * information about your VPC and Internet gateway, see the <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/">Amazon Virtual Private Cloud User Guide</a>.
     * </p>
     *
     * @param attachInternetGatewayRequest
     *        Contains the parameters for AttachInternetGateway.
     * @return A Java Future containing the result of the AttachInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AttachInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachInternetGatewayResponse> attachInternetGateway(
            AttachInternetGatewayRequest attachInternetGatewayRequest) {

        StaxResponseHandler<AttachInternetGatewayResponse> responseHandler = new StaxResponseHandler<AttachInternetGatewayResponse>(
                new AttachInternetGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AttachInternetGatewayRequest, AttachInternetGatewayResponse>()
                .withMarshaller(new AttachInternetGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(attachInternetGatewayRequest));
    }

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     *
     * @param attachNetworkInterfaceRequest
     *        Contains the parameters for AttachNetworkInterface.
     * @return A Java Future containing the result of the AttachNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AttachNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachNetworkInterfaceResponse> attachNetworkInterface(
            AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) {

        StaxResponseHandler<AttachNetworkInterfaceResponse> responseHandler = new StaxResponseHandler<AttachNetworkInterfaceResponse>(
                new AttachNetworkInterfaceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AttachNetworkInterfaceRequest, AttachNetworkInterfaceResponse>()
                .withMarshaller(new AttachNetworkInterfaceRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(attachNetworkInterfaceRequest));
    }

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes may only be attached to instances that support Amazon EBS encryption. For more information,
     * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For a list of supported device names, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attaching an EBS Volume to an
     * Instance</a>. Any device names that aren't reserved for instance store volumes can be used for EBS volumes. For
     * more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon
     * EC2 Instance Store</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If a volume has an AWS Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For an overview of the AWS Marketplace, see <a
     * href="https://aws.amazon.com/marketplace/help/200900000">Introducing AWS Marketplace</a>.
     * </p>
     * <p>
     * For more information about EBS volumes, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attaching Amazon EBS
     * Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param attachVolumeRequest
     *        Contains the parameters for AttachVolume.
     * @return A Java Future containing the result of the AttachVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AttachVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachVolumeResponse> attachVolume(AttachVolumeRequest attachVolumeRequest) {

        StaxResponseHandler<AttachVolumeResponse> responseHandler = new StaxResponseHandler<AttachVolumeResponse>(
                new AttachVolumeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AttachVolumeRequest, AttachVolumeResponse>()
                .withMarshaller(new AttachVolumeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(attachVolumeRequest));
    }

    /**
     * <p>
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">AWS
     * Managed VPN Connections</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param attachVpnGatewayRequest
     *        Contains the parameters for AttachVpnGateway.
     * @return A Java Future containing the result of the AttachVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AttachVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachVpnGatewayResponse> attachVpnGateway(AttachVpnGatewayRequest attachVpnGatewayRequest) {

        StaxResponseHandler<AttachVpnGatewayResponse> responseHandler = new StaxResponseHandler<AttachVpnGatewayResponse>(
                new AttachVpnGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<AttachVpnGatewayRequest, AttachVpnGatewayResponse>()
                .withMarshaller(new AttachVpnGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(attachVpnGatewayRequest));
    }

    /**
     * <p>
     * [EC2-VPC only] Adds one or more egress rules to a security group for use with a VPC. Specifically, this action
     * permits instances to send traffic to one or more destination IPv4 or IPv6 CIDR address ranges, or to one or more
     * destination security groups for the same VPC. This action doesn't apply to security groups for use in
     * EC2-Classic. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>. For more information about security group limits,
     * see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html">Amazon VPC
     * Limits</a>.
     * </p>
     * <p>
     * Each rule consists of the protocol (for example, TCP), plus either a CIDR range or a source group. For the TCP
     * and UDP protocols, you must also specify the destination port or port range. For the ICMP protocol, you must also
     * specify the ICMP type and code. You can use -1 for the type or code to mean all types or all codes. You can
     * optionally specify a description for the rule.
     * </p>
     * <p>
     * Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.
     * </p>
     *
     * @param authorizeSecurityGroupEgressRequest
     *        Contains the parameters for AuthorizeSecurityGroupEgress.
     * @return A Java Future containing the result of the AuthorizeSecurityGroupEgress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AuthorizeSecurityGroupEgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeSecurityGroupEgressResponse> authorizeSecurityGroupEgress(
            AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) {

        StaxResponseHandler<AuthorizeSecurityGroupEgressResponse> responseHandler = new StaxResponseHandler<AuthorizeSecurityGroupEgressResponse>(
                new AuthorizeSecurityGroupEgressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<AuthorizeSecurityGroupEgressRequest, AuthorizeSecurityGroupEgressResponse>()
                        .withMarshaller(new AuthorizeSecurityGroupEgressRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(authorizeSecurityGroupEgressRequest));
    }

    /**
     * <p>
     * Adds one or more ingress rules to a security group.
     * </p>
     * <p>
     * Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay
     * might occur.
     * </p>
     * <p>
     * [EC2-Classic] This action gives one or more IPv4 CIDR address ranges permission to access a security group in
     * your account, or gives one or more security groups (called the <i>source groups</i>) permission to access a
     * security group for your account. A source group can be for your own AWS account, or another. You can have up to
     * 100 rules per group.
     * </p>
     * <p>
     * [EC2-VPC] This action gives one or more IPv4 or IPv6 CIDR address ranges permission to access a security group in
     * your VPC, or gives one or more other security groups (called the <i>source groups</i>) permission to access a
     * security group for your VPC. The security groups must all be for the same VPC or a peer VPC in a VPC peering
     * connection. For more information about VPC security group limits, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html">Amazon VPC Limits</a>.
     * </p>
     * <p>
     * You can optionally specify a description for the security group rule.
     * </p>
     *
     * @param authorizeSecurityGroupIngressRequest
     *        Contains the parameters for AuthorizeSecurityGroupIngress.
     * @return A Java Future containing the result of the AuthorizeSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.AuthorizeSecurityGroupIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeSecurityGroupIngressResponse> authorizeSecurityGroupIngress(
            AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) {

        StaxResponseHandler<AuthorizeSecurityGroupIngressResponse> responseHandler = new StaxResponseHandler<AuthorizeSecurityGroupIngressResponse>(
                new AuthorizeSecurityGroupIngressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<AuthorizeSecurityGroupIngressRequest, AuthorizeSecurityGroupIngressResponse>()
                        .withMarshaller(new AuthorizeSecurityGroupIngressRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(authorizeSecurityGroupIngressRequest));
    }

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/Creating_InstanceStoreBacked_WinAMI.html">Creating an
     * Instance Store-Backed Windows AMI</a>.
     * </p>
     *
     * @param bundleInstanceRequest
     *        Contains the parameters for BundleInstance.
     * @return A Java Future containing the result of the BundleInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.BundleInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BundleInstanceResponse> bundleInstance(BundleInstanceRequest bundleInstanceRequest) {

        StaxResponseHandler<BundleInstanceResponse> responseHandler = new StaxResponseHandler<BundleInstanceResponse>(
                new BundleInstanceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<BundleInstanceRequest, BundleInstanceResponse>()
                .withMarshaller(new BundleInstanceRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(bundleInstanceRequest));
    }

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     *
     * @param cancelBundleTaskRequest
     *        Contains the parameters for CancelBundleTask.
     * @return A Java Future containing the result of the CancelBundleTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CancelBundleTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelBundleTaskResponse> cancelBundleTask(CancelBundleTaskRequest cancelBundleTaskRequest) {

        StaxResponseHandler<CancelBundleTaskResponse> responseHandler = new StaxResponseHandler<CancelBundleTaskResponse>(
                new CancelBundleTaskResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CancelBundleTaskRequest, CancelBundleTaskResponse>()
                .withMarshaller(new CancelBundleTaskRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(cancelBundleTaskRequest));
    }

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a
     * Virtual Machine Using the Amazon EC2 CLI</a>.
     * </p>
     *
     * @param cancelConversionTaskRequest
     *        Contains the parameters for CancelConversionTask.
     * @return A Java Future containing the result of the CancelConversionTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CancelConversionTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelConversionTaskResponse> cancelConversionTask(
            CancelConversionTaskRequest cancelConversionTaskRequest) {

        StaxResponseHandler<CancelConversionTaskResponse> responseHandler = new StaxResponseHandler<CancelConversionTaskResponse>(
                new CancelConversionTaskResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CancelConversionTaskRequest, CancelConversionTaskResponse>()
                .withMarshaller(new CancelConversionTaskRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(cancelConversionTaskRequest));
    }

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     *
     * @param cancelExportTaskRequest
     *        Contains the parameters for CancelExportTask.
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CancelExportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelExportTaskResponse> cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) {

        StaxResponseHandler<CancelExportTaskResponse> responseHandler = new StaxResponseHandler<CancelExportTaskResponse>(
                new CancelExportTaskResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CancelExportTaskRequest, CancelExportTaskResponse>()
                .withMarshaller(new CancelExportTaskRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(cancelExportTaskRequest));
    }

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     *
     * @param cancelImportTaskRequest
     *        Contains the parameters for CancelImportTask.
     * @return A Java Future containing the result of the CancelImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CancelImportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelImportTaskResponse> cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest) {

        StaxResponseHandler<CancelImportTaskResponse> responseHandler = new StaxResponseHandler<CancelImportTaskResponse>(
                new CancelImportTaskResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CancelImportTaskRequest, CancelImportTaskResponse>()
                .withMarshaller(new CancelImportTaskRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(cancelImportTaskRequest));
    }

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param cancelReservedInstancesListingRequest
     *        Contains the parameters for CancelReservedInstancesListing.
     * @return A Java Future containing the result of the CancelReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CancelReservedInstancesListing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelReservedInstancesListingResponse> cancelReservedInstancesListing(
            CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest) {

        StaxResponseHandler<CancelReservedInstancesListingResponse> responseHandler = new StaxResponseHandler<CancelReservedInstancesListingResponse>(
                new CancelReservedInstancesListingResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CancelReservedInstancesListingRequest, CancelReservedInstancesListingResponse>()
                        .withMarshaller(new CancelReservedInstancesListingRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(cancelReservedInstancesListingRequest));
    }

    /**
     * <p>
     * Cancels the specified Spot fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot fleet request, the Spot fleet launches no new Spot instances. You must specify whether
     * the Spot fleet should also terminate its Spot instances. If you terminate the instances, the Spot fleet request
     * enters the <code>cancelled_terminating</code> state. Otherwise, the Spot fleet request enters the
     * <code>cancelled_running</code> state and the instances continue to run until they are interrupted or you
     * terminate them manually.
     * </p>
     *
     * @param cancelSpotFleetRequestsRequest
     *        Contains the parameters for CancelSpotFleetRequests.
     * @return A Java Future containing the result of the CancelSpotFleetRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CancelSpotFleetRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSpotFleetRequestsResponse> cancelSpotFleetRequests(
            CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest) {

        StaxResponseHandler<CancelSpotFleetRequestsResponse> responseHandler = new StaxResponseHandler<CancelSpotFleetRequestsResponse>(
                new CancelSpotFleetRequestsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CancelSpotFleetRequestsRequest, CancelSpotFleetRequestsResponse>()
                .withMarshaller(new CancelSpotFleetRequestsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(cancelSpotFleetRequestsRequest));
    }

    /**
     * <p>
     * Cancels one or more Spot instance requests. Spot instances are instances that Amazon EC2 starts on your behalf
     * when the bid price that you specify exceeds the current Spot price. Amazon EC2 periodically sets the Spot price
     * based on available Spot instance capacity and current Spot instance requests. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance Requests</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot instance request does not terminate running Spot instances associated with the request.
     * </p>
     * </important>
     *
     * @param cancelSpotInstanceRequestsRequest
     *        Contains the parameters for CancelSpotInstanceRequests.
     * @return A Java Future containing the result of the CancelSpotInstanceRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CancelSpotInstanceRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSpotInstanceRequestsResponse> cancelSpotInstanceRequests(
            CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest) {

        StaxResponseHandler<CancelSpotInstanceRequestsResponse> responseHandler = new StaxResponseHandler<CancelSpotInstanceRequestsResponse>(
                new CancelSpotInstanceRequestsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CancelSpotInstanceRequestsRequest, CancelSpotInstanceRequestsResponse>()
                        .withMarshaller(new CancelSpotInstanceRequestsRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(cancelSpotInstanceRequestsRequest));
    }

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     *
     * @param confirmProductInstanceRequest
     *        Contains the parameters for ConfirmProductInstance.
     * @return A Java Future containing the result of the ConfirmProductInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ConfirmProductInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmProductInstanceResponse> confirmProductInstance(
            ConfirmProductInstanceRequest confirmProductInstanceRequest) {

        StaxResponseHandler<ConfirmProductInstanceResponse> responseHandler = new StaxResponseHandler<ConfirmProductInstanceResponse>(
                new ConfirmProductInstanceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ConfirmProductInstanceRequest, ConfirmProductInstanceResponse>()
                .withMarshaller(new ConfirmProductInstanceRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(confirmProductInstanceRequest));
    }

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current region.
     * </p>
     *
     * @param copyFpgaImageRequest
     * @return A Java Future containing the result of the CopyFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CopyFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyFpgaImageResponse> copyFpgaImage(CopyFpgaImageRequest copyFpgaImageRequest) {

        StaxResponseHandler<CopyFpgaImageResponse> responseHandler = new StaxResponseHandler<CopyFpgaImageResponse>(
                new CopyFpgaImageResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CopyFpgaImageRequest, CopyFpgaImageResponse>()
                .withMarshaller(new CopyFpgaImageRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(copyFpgaImageRequest));
    }

    /**
     * <p>
     * Initiates the copy of an AMI from the specified source region to the current region. You specify the destination
     * region by using its endpoint when making the request.
     * </p>
     * <p>
     * For more information about the prerequisites and limits when copying an AMI, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying an AMI</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param copyImageRequest
     *        Contains the parameters for CopyImage.
     * @return A Java Future containing the result of the CopyImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CopyImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyImageResponse> copyImage(CopyImageRequest copyImageRequest) {

        StaxResponseHandler<CopyImageResponse> responseHandler = new StaxResponseHandler<CopyImageResponse>(
                new CopyImageResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CopyImageRequest, CopyImageResponse>()
                .withMarshaller(new CopyImageRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(copyImageRequest));
    }

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy the snapshot within the
     * same region or from one region to another. You can use the snapshot to create EBS volumes or Amazon Machine
     * Images (AMIs). The snapshot is copied to the regional endpoint that you send the HTTP request to.
     * </p>
     * <p>
     * Copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted snapshots remain unencrypted, unless
     * the <code>Encrypted</code> flag is specified during the snapshot copy operation. By default, encrypted snapshot
     * copies use the default AWS Key Management Service (AWS KMS) customer master key (CMK); however, you can specify a
     * non-default CMK with the <code>KmsKeyId</code> parameter.
     * </p>
     * <note>
     * <p>
     * To copy an encrypted snapshot that has been shared from another account, you must have permissions for the CMK
     * used to encrypt the snapshot.
     * </p>
     * </note> <note>
     * <p>
     * Snapshots created by the CopySnapshot action have an arbitrary volume ID that should not be used for any purpose.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copying an Amazon EBS
     * Snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param copySnapshotRequest
     *        Contains the parameters for CopySnapshot.
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CopySnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {

        StaxResponseHandler<CopySnapshotResponse> responseHandler = new StaxResponseHandler<CopySnapshotResponse>(
                new CopySnapshotResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CopySnapshotRequest, CopySnapshotResponse>()
                .withMarshaller(new CopySnapshotRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(copySnapshotRequest));
    }

    /**
     * <p>
     * Provides information to AWS about your VPN customer gateway device. The customer gateway is the appliance at your
     * end of the VPN connection. (The device on the AWS side of the VPN connection is the virtual private gateway.) You
     * must provide the Internet-routable IP address of the customer gateway's external interface. The IP address must
     * be static and may be behind a device performing network address translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN (in the 64512 - 65534 range).
     * </p>
     * <note>
     * <p>
     * Amazon EC2 supports all 2-byte ASN numbers in the range of 1 - 65534, with the exception of 7224, which is
     * reserved in the <code>us-east-1</code> region, and 9059, which is reserved in the <code>eu-west-1</code> region.
     * </p>
     * </note>
     * <p>
     * For more information about VPN customer gateways, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">AWS Managed VPN Connections</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <important>
     * <p>
     * You cannot create more than one customer gateway with the same VPN type, IP address, and BGP ASN parameter
     * values. If you run an identical request more than one time, the first request creates the customer gateway, and
     * subsequent requests return information about the existing customer gateway. The subsequent requests do not create
     * new customer gateway resources.
     * </p>
     * </important>
     *
     * @param createCustomerGatewayRequest
     *        Contains the parameters for CreateCustomerGateway.
     * @return A Java Future containing the result of the CreateCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateCustomerGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomerGatewayResponse> createCustomerGateway(
            CreateCustomerGatewayRequest createCustomerGatewayRequest) {

        StaxResponseHandler<CreateCustomerGatewayResponse> responseHandler = new StaxResponseHandler<CreateCustomerGatewayResponse>(
                new CreateCustomerGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateCustomerGatewayRequest, CreateCustomerGatewayResponse>()
                .withMarshaller(new CreateCustomerGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createCustomerGatewayRequest));
    }

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html#create-default-subnet">Creating a
     * Default Subnet</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createDefaultSubnetRequest
     * @return A Java Future containing the result of the CreateDefaultSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateDefaultSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDefaultSubnetResponse> createDefaultSubnet(
            CreateDefaultSubnetRequest createDefaultSubnetRequest) {

        StaxResponseHandler<CreateDefaultSubnetResponse> responseHandler = new StaxResponseHandler<CreateDefaultSubnetResponse>(
                new CreateDefaultSubnetResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateDefaultSubnetRequest, CreateDefaultSubnetResponse>()
                .withMarshaller(new CreateDefaultSubnetRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDefaultSubnetRequest));
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html">Default VPC and Default Subnets</a>
     * in the <i>Amazon Virtual Private Cloud User Guide</i>. You cannot specify the components of the default VPC
     * yourself.
     * </p>
     * <p>
     * You can create a default VPC if you deleted your previous default VPC. You cannot have more than one default VPC
     * per region.
     * </p>
     * <p>
     * If your account supports EC2-Classic, you cannot use this action to create a default VPC in a region that
     * supports EC2-Classic. If you want a default VPC in a region that supports EC2-Classic, see
     * "I really want a default VPC for my existing EC2 account. Is that possible?" in the <a
     * href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs FAQ</a>.
     * </p>
     *
     * @param createDefaultVpcRequest
     *        Contains the parameters for CreateDefaultVpc.
     * @return A Java Future containing the result of the CreateDefaultVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateDefaultVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDefaultVpcResponse> createDefaultVpc(CreateDefaultVpcRequest createDefaultVpcRequest) {

        StaxResponseHandler<CreateDefaultVpcResponse> responseHandler = new StaxResponseHandler<CreateDefaultVpcResponse>(
                new CreateDefaultVpcResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateDefaultVpcRequest, CreateDefaultVpcResponse>()
                .withMarshaller(new CreateDefaultVpcRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDefaultVpcRequest));
    }

    /**
     * <p>
     * Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing
     * all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the
     * individual DHCP options you can specify. For more information about the options, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The
     * default DHCP option set specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the
     * IP addresses in a single parameter, separated by commas. If you want your instance to receive a custom DNS
     * hostname as specified in <code>domain-name</code>, you must set <code>domain-name-servers</code> to a custom DNS
     * server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in another region, specify
     * <code>region.compute.internal</code> (for example, <code>ap-northeast-1.compute.internal</code>). Otherwise,
     * specify a domain name (for example, <code>MyCompany.com</code>). This value is used to complete unqualified DNS
     * hostnames. <b>Important</b>: Some Linux operating systems accept multiple domain names separated by spaces.
     * However, Windows and other Linux operating systems treat the value as a single domain, which results in
     * unexpected behavior. If your DHCP options set is associated with a VPC that has instances with multiple operating
     * systems, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to four Network Time Protocol (NTP) servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2
     * (broadcast and multicast are not currently supported). For more information about these node types, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Your VPC automatically starts out with a set of DHCP options that includes only a DNS server that we provide
     * (AmazonProvidedDNS). If you create a set of options, and if your VPC has an Internet gateway, make sure to set
     * the <code>domain-name-servers</code> option either to <code>AmazonProvidedDNS</code> or to a domain name server
     * of your choice. For more information about DHCP options, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createDhcpOptionsRequest
     *        Contains the parameters for CreateDhcpOptions.
     * @return A Java Future containing the result of the CreateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDhcpOptionsResponse> createDhcpOptions(CreateDhcpOptionsRequest createDhcpOptionsRequest) {

        StaxResponseHandler<CreateDhcpOptionsResponse> responseHandler = new StaxResponseHandler<CreateDhcpOptionsResponse>(
                new CreateDhcpOptionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse>()
                .withMarshaller(new CreateDhcpOptionsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDhcpOptionsRequest));
    }

    /**
     * <p>
     * [IPv6 only] Creates an egress-only Internet gateway for your VPC. An egress-only Internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the Internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     *
     * @param createEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the CreateEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateEgressOnlyInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEgressOnlyInternetGatewayResponse> createEgressOnlyInternetGateway(
            CreateEgressOnlyInternetGatewayRequest createEgressOnlyInternetGatewayRequest) {

        StaxResponseHandler<CreateEgressOnlyInternetGatewayResponse> responseHandler = new StaxResponseHandler<CreateEgressOnlyInternetGatewayResponse>(
                new CreateEgressOnlyInternetGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateEgressOnlyInternetGatewayRequest, CreateEgressOnlyInternetGatewayResponse>()
                        .withMarshaller(new CreateEgressOnlyInternetGatewayRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createEgressOnlyInternetGatewayRequest));
    }

    /**
     * <p>
     * Creates one or more flow logs to capture IP traffic for a specific network interface, subnet, or VPC. Flow logs
     * are delivered to a specified log group in Amazon CloudWatch Logs. If you specify a VPC or subnet in the request,
     * a log stream is created in CloudWatch Logs for each network interface in the subnet or VPC. Log streams can
     * include information about accepted and rejected traffic to a network interface. You can view the data in your log
     * streams using Amazon CloudWatch Logs.
     * </p>
     * <p>
     * In your request, you must also specify an IAM role that has permission to publish logs to CloudWatch Logs.
     * </p>
     *
     * @param createFlowLogsRequest
     *        Contains the parameters for CreateFlowLogs.
     * @return A Java Future containing the result of the CreateFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFlowLogsResponse> createFlowLogs(CreateFlowLogsRequest createFlowLogsRequest) {

        StaxResponseHandler<CreateFlowLogsResponse> responseHandler = new StaxResponseHandler<CreateFlowLogsResponse>(
                new CreateFlowLogsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateFlowLogsRequest, CreateFlowLogsResponse>()
                .withMarshaller(new CreateFlowLogsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createFlowLogsRequest));
    }

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on one or
     * more FPGA-accelerated instances. For more information, see the <a href="https://github.com/aws/aws-fpga/">AWS
     * FPGA Hardware Development Kit</a>.
     * </p>
     *
     * @param createFpgaImageRequest
     * @return A Java Future containing the result of the CreateFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFpgaImageResponse> createFpgaImage(CreateFpgaImageRequest createFpgaImageRequest) {

        StaxResponseHandler<CreateFpgaImageResponse> responseHandler = new StaxResponseHandler<CreateFpgaImageResponse>(
                new CreateFpgaImageResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateFpgaImageRequest, CreateFpgaImageResponse>()
                .withMarshaller(new CreateFpgaImageRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createFpgaImageRequest));
    }

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * If you customized your instance with instance store volumes or EBS volumes in addition to the root device volume,
     * the new AMI contains block device mapping information for those volumes. When you launch an instance from this
     * new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed
     * Linux AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createImageRequest
     *        Contains the parameters for CreateImage.
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {

        StaxResponseHandler<CreateImageResponse> responseHandler = new StaxResponseHandler<CreateImageResponse>(
                new CreateImageResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                .withMarshaller(new CreateImageRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createImageRequest));
    }

    /**
     * <p>
     * Exports a running or stopped instance to an S3 bucket.
     * </p>
     * <p>
     * For information about the supported operating systems, image formats, and known limitations for the types of
     * instances you can export, see <a
     * href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an Instance as a VM Using VM
     * Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     *
     * @param createInstanceExportTaskRequest
     *        Contains the parameters for CreateInstanceExportTask.
     * @return A Java Future containing the result of the CreateInstanceExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateInstanceExportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceExportTaskResponse> createInstanceExportTask(
            CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {

        StaxResponseHandler<CreateInstanceExportTaskResponse> responseHandler = new StaxResponseHandler<CreateInstanceExportTaskResponse>(
                new CreateInstanceExportTaskResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateInstanceExportTaskRequest, CreateInstanceExportTaskResponse>()
                        .withMarshaller(new CreateInstanceExportTaskRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createInstanceExportTaskRequest));
    }

    /**
     * <p>
     * Creates an Internet gateway for use with a VPC. After creating the Internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information about your VPC and Internet gateway, see the <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/">Amazon Virtual Private Cloud User Guide</a>.
     * </p>
     *
     * @param createInternetGatewayRequest
     *        Contains the parameters for CreateInternetGateway.
     * @return A Java Future containing the result of the CreateInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInternetGatewayResponse> createInternetGateway(
            CreateInternetGatewayRequest createInternetGatewayRequest) {

        StaxResponseHandler<CreateInternetGatewayResponse> responseHandler = new StaxResponseHandler<CreateInternetGatewayResponse>(
                new CreateInternetGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateInternetGatewayRequest, CreateInternetGatewayResponse>()
                .withMarshaller(new CreateInternetGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createInternetGatewayRequest));
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public key and displays the
     * private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#8 private
     * key. If a key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * You can have up to five thousand key pairs per region.
     * </p>
     * <p>
     * The key pair returned to you is available only in the region in which you create it. To create a key pair that is
     * available in all regions, use <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * For more information about key pairs, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createKeyPairRequest
     *        Contains the parameters for CreateKeyPair.
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {

        StaxResponseHandler<CreateKeyPairResponse> responseHandler = new StaxResponseHandler<CreateKeyPairResponse>(
                new CreateKeyPairResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateKeyPairRequest, CreateKeyPairResponse>()
                .withMarshaller(new CreateKeyPairRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createKeyPairRequest));
    }

    /**
     * <p>
     * Creates a NAT gateway in the specified subnet. A NAT gateway can be used to enable instances in a private subnet
     * to connect to the Internet. This action creates a network interface in the specified subnet with a private IP
     * address from the IP address range of the subnet. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">NAT Gateways</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNatGatewayRequest
     *        Contains the parameters for CreateNatGateway.
     * @return A Java Future containing the result of the CreateNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateNatGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNatGatewayResponse> createNatGateway(CreateNatGatewayRequest createNatGatewayRequest) {

        StaxResponseHandler<CreateNatGatewayResponse> responseHandler = new StaxResponseHandler<CreateNatGatewayResponse>(
                new CreateNatGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateNatGatewayRequest, CreateNatGatewayResponse>()
                .withMarshaller(new CreateNatGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createNatGatewayRequest));
    }

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon
     * Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkAclRequest
     *        Contains the parameters for CreateNetworkAcl.
     * @return A Java Future containing the result of the CreateNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateNetworkAcl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkAclResponse> createNetworkAcl(CreateNetworkAclRequest createNetworkAclRequest) {

        StaxResponseHandler<CreateNetworkAclResponse> responseHandler = new StaxResponseHandler<CreateNetworkAclResponse>(
                new CreateNetworkAclResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateNetworkAclRequest, CreateNetworkAclResponse>()
                .withMarshaller(new CreateNetworkAclRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createNetworkAclRequest));
    }

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon
     * Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkAclEntryRequest
     *        Contains the parameters for CreateNetworkAclEntry.
     * @return A Java Future containing the result of the CreateNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateNetworkAclEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkAclEntryResponse> createNetworkAclEntry(
            CreateNetworkAclEntryRequest createNetworkAclEntryRequest) {

        StaxResponseHandler<CreateNetworkAclEntryResponse> responseHandler = new StaxResponseHandler<CreateNetworkAclEntryResponse>(
                new CreateNetworkAclEntryResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateNetworkAclEntryRequest, CreateNetworkAclEntryResponse>()
                .withMarshaller(new CreateNetworkAclEntryRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createNetworkAclEntryRequest));
    }

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkInterfaceRequest
     *        Contains the parameters for CreateNetworkInterface.
     * @return A Java Future containing the result of the CreateNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkInterfaceResponse> createNetworkInterface(
            CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {

        StaxResponseHandler<CreateNetworkInterfaceResponse> responseHandler = new StaxResponseHandler<CreateNetworkInterfaceResponse>(
                new CreateNetworkInterfaceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateNetworkInterfaceRequest, CreateNetworkInterfaceResponse>()
                .withMarshaller(new CreateNetworkInterfaceRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createNetworkInterfaceRequest));
    }

    /**
     * <p>
     * Grants an AWS authorized partner account permission to attach the specified network interface to an instance in
     * their account.
     * </p>
     * <p>
     * You can grant permission to a single AWS account only, and only one account at a time.
     * </p>
     *
     * @param createNetworkInterfacePermissionRequest
     *        Contains the parameters for CreateNetworkInterfacePermission.
     * @return A Java Future containing the result of the CreateNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateNetworkInterfacePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkInterfacePermissionResponse> createNetworkInterfacePermission(
            CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest) {

        StaxResponseHandler<CreateNetworkInterfacePermissionResponse> responseHandler = new StaxResponseHandler<CreateNetworkInterfacePermissionResponse>(
                new CreateNetworkInterfacePermissionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateNetworkInterfacePermissionRequest, CreateNetworkInterfacePermissionResponse>()
                        .withMarshaller(new CreateNetworkInterfacePermissionRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createNetworkInterfacePermissionRequest));
    }

    /**
     * <p>
     * Creates a placement group that you launch cluster instances into. Give the group a name that's unique within the
     * scope of your account.
     * </p>
     * <p>
     * For more information about placement groups and cluster instances, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html">Cluster Instances</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createPlacementGroupRequest
     *        Contains the parameters for CreatePlacementGroup.
     * @return A Java Future containing the result of the CreatePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreatePlacementGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePlacementGroupResponse> createPlacementGroup(
            CreatePlacementGroupRequest createPlacementGroupRequest) {

        StaxResponseHandler<CreatePlacementGroupResponse> responseHandler = new StaxResponseHandler<CreatePlacementGroupResponse>(
                new CreatePlacementGroupResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreatePlacementGroupRequest, CreatePlacementGroupResponse>()
                .withMarshaller(new CreatePlacementGroupRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createPlacementGroupRequest));
    }

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances with a capacity reservation can be sold in the Reserved Instance Marketplace.
     * Convertible Reserved Instances and Standard Reserved Instances with a regional benefit cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createReservedInstancesListingRequest
     *        Contains the parameters for CreateReservedInstancesListing.
     * @return A Java Future containing the result of the CreateReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateReservedInstancesListing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReservedInstancesListingResponse> createReservedInstancesListing(
            CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {

        StaxResponseHandler<CreateReservedInstancesListingResponse> responseHandler = new StaxResponseHandler<CreateReservedInstancesListingResponse>(
                new CreateReservedInstancesListingResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateReservedInstancesListingRequest, CreateReservedInstancesListingResponse>()
                        .withMarshaller(new CreateReservedInstancesListingRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createReservedInstancesListingRequest));
    }

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify one of the following targets: Internet gateway or virtual private gateway, NAT instance, NAT
     * gateway, VPC peering connection, network interface, or egress-only Internet gateway.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createRouteRequest
     *        Contains the parameters for CreateRoute.
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRouteResponse> createRoute(CreateRouteRequest createRouteRequest) {

        StaxResponseHandler<CreateRouteResponse> responseHandler = new StaxResponseHandler<CreateRouteResponse>(
                new CreateRouteResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateRouteRequest, CreateRouteResponse>()
                .withMarshaller(new CreateRouteRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createRouteRequest));
    }

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createRouteTableRequest
     *        Contains the parameters for CreateRouteTable.
     * @return A Java Future containing the result of the CreateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRouteTableResponse> createRouteTable(CreateRouteTableRequest createRouteTableRequest) {

        StaxResponseHandler<CreateRouteTableResponse> responseHandler = new StaxResponseHandler<CreateRouteTableResponse>(
                new CreateRouteTableResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateRouteTableRequest, CreateRouteTableResponse>()
                .withMarshaller(new CreateRouteTableRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createRouteTableRequest));
    }

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group is for use with instances either in the EC2-Classic platform or in a specific VPC. For more
     * information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <important>
     * <p>
     * EC2-Classic: You can have up to 500 security groups.
     * </p>
     * <p>
     * EC2-VPC: You can create up to 500 security groups per VPC.
     * </p>
     * </important>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can have a security group for
     * use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security
     * groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you
     * don't specify a security group when you launch an instance, the instance is launched into the appropriate default
     * security group. A default security group includes a default rule that grants instances unrestricted network
     * access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     *
     * @param createSecurityGroupRequest
     *        Contains the parameters for CreateSecurityGroup.
     * @return A Java Future containing the result of the CreateSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSecurityGroupResponse> createSecurityGroup(
            CreateSecurityGroupRequest createSecurityGroupRequest) {

        StaxResponseHandler<CreateSecurityGroupResponse> responseHandler = new StaxResponseHandler<CreateSecurityGroupResponse>(
                new CreateSecurityGroupResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateSecurityGroupRequest, CreateSecurityGroupResponse>()
                .withMarshaller(new CreateSecurityGroupRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createSecurityGroupRequest));
    }

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * When a snapshot is created, any AWS Marketplace product codes that are associated with the source volume are
     * propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your EBS volume at the time the snapshot command is issued; this may exclude any data that has been
     * cached by any applications or the operating system. If you can pause any file systems on the volume long enough
     * to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the volume,
     * you should unmount the volume from within the instance, issue the snapshot command, and then remount the volume
     * to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot status is
     * <code>pending</code>.
     * </p>
     * <p>
     * To create a snapshot for EBS volumes that serve as root devices, you should stop the instance before taking the
     * snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon
     * Elastic Block Store</a> and <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createSnapshotRequest
     *        Contains the parameters for CreateSnapshot.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {

        StaxResponseHandler<CreateSnapshotResponse> responseHandler = new StaxResponseHandler<CreateSnapshotResponse>(
                new CreateSnapshotResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                .withMarshaller(new CreateSnapshotRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createSnapshotRequest));
    }

    /**
     * <p>
     * Creates a data feed for Spot instances, enabling you to view Spot instance usage logs. You can create one data
     * feed per AWS account. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance Data Feed</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createSpotDatafeedSubscriptionRequest
     *        Contains the parameters for CreateSpotDatafeedSubscription.
     * @return A Java Future containing the result of the CreateSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSpotDatafeedSubscriptionResponse> createSpotDatafeedSubscription(
            CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest) {

        StaxResponseHandler<CreateSpotDatafeedSubscriptionResponse> responseHandler = new StaxResponseHandler<CreateSpotDatafeedSubscriptionResponse>(
                new CreateSpotDatafeedSubscriptionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateSpotDatafeedSubscriptionRequest, CreateSpotDatafeedSubscriptionResponse>()
                        .withMarshaller(new CreateSpotDatafeedSubscriptionRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createSpotDatafeedSubscriptionRequest));
    }

    /**
     * <p>
     * Creates a subnet in an existing VPC.
     * </p>
     * <p>
     * When you create each subnet, you provide the VPC ID and the IPv4 CIDR block you want for the subnet. After you
     * create a subnet, you can't change its CIDR block. The size of the subnet's IPv4 CIDR block can be the same as a
     * VPC's IPv4 CIDR block, or a subset of a VPC's IPv4 CIDR block. If you create more than one subnet in a VPC, the
     * subnets' CIDR blocks must not overlap. The smallest IPv4 subnet (and VPC) you can create uses a /28 netmask (16
     * IPv4 addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses).
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an IPv6 CIDR block that uses
     * a /64 prefix length.
     * </p>
     * <important>
     * <p>
     * AWS reserves both the first four and the last IPv4 address in each subnet's CIDR block. They're not available for
     * use.
     * </p>
     * </important>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * If you launch an instance in a VPC using an Amazon EBS-backed AMI, the IP address doesn't change if you stop and
     * restart the instance (unlike a similar instance launched outside a VPC, which gets a new IP address when
     * restarted). It's therefore possible to have a subnet with no running instances (they're all stopped), but no
     * remaining IP addresses available.
     * </p>
     * <p>
     * For more information about subnets, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">Your VPC and Subnets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createSubnetRequest
     *        Contains the parameters for CreateSubnet.
     * @return A Java Future containing the result of the CreateSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSubnetResponse> createSubnet(CreateSubnetRequest createSubnetRequest) {

        StaxResponseHandler<CreateSubnetResponse> responseHandler = new StaxResponseHandler<CreateSubnetResponse>(
                new CreateSubnetResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateSubnetRequest, CreateSubnetResponse>()
                .withMarshaller(new CreateSubnetRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createSubnetRequest));
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified Amazon EC2 resource or resources. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * Resource-Level Permissions for Amazon EC2 API Actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createTagsRequest
     *        Contains the parameters for CreateTags.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {

        StaxResponseHandler<CreateTagsResponse> responseHandler = new StaxResponseHandler<CreateTagsResponse>(
                new CreateTagsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateTagsRequest, CreateTagsResponse>()
                .withMarshaller(new CreateTagsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createTagsRequest));
    }

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone. The volume is created in
     * the regional endpoint that you send the HTTP request to. For more information see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any AWS Marketplace product codes
     * from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes with the <code>Encrypted</code> parameter. Encrypted volumes may only be
     * attached to instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are
     * also automatically encrypted. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html">Creating an Amazon EBS
     * Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createVolumeRequest
     *        Contains the parameters for CreateVolume.
     * @return A Java Future containing the result of the CreateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVolumeResponse> createVolume(CreateVolumeRequest createVolumeRequest) {

        StaxResponseHandler<CreateVolumeResponse> responseHandler = new StaxResponseHandler<CreateVolumeResponse>(
                new CreateVolumeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateVolumeRequest, CreateVolumeResponse>()
                .withMarshaller(new CreateVolumeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createVolumeRequest));
    }

    /**
     * <p>
     * Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create uses a /28 netmask (16 IPv4
     * addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses). To help you decide how big to make your
     * VPC, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">Your VPC and
     * Subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an Amazon-provided IPv6 CIDR block for the VPC. The IPv6 CIDR block uses a /56 prefix
     * length, and is allocated from Amazon's pool of IPv6 addresses. You cannot choose the IPv6 range for your VPC.
     * </p>
     * <p>
     * By default, each instance you launch in the VPC has the default DHCP options, which includes only a default DNS
     * server that we provide (AmazonProvidedDNS). For more information about DHCP options, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createVpcRequest
     *        Contains the parameters for CreateVpc.
     * @return A Java Future containing the result of the CreateVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcResponse> createVpc(CreateVpcRequest createVpcRequest) {

        StaxResponseHandler<CreateVpcResponse> responseHandler = new StaxResponseHandler<CreateVpcResponse>(
                new CreateVpcResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateVpcRequest, CreateVpcResponse>()
                .withMarshaller(new CreateVpcRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createVpcRequest));
    }

    /**
     * <p>
     * Creates a VPC endpoint for a specified AWS service. An endpoint enables you to create a private connection
     * between your VPC and another AWS service in your account. You can create a gateway endpoint or an interface
     * endpoint.
     * </p>
     * <p>
     * A gateway endpoint serves as a target for a route in your route table for traffic destined for the AWS service.
     * You can specify the VPC route tables that use the endpoint, and you can optionally specify an endpoint policy to
     * attach to the endpoint that will control access to the service from your VPC.
     * </p>
     * <p>
     * An interface endpoint is a network interface in your subnet with a private IP address that serves as an entry
     * point for traffic destined to the AWS service. You can specify the subnets in which to create an endpoint, and
     * the security groups to associate with the network interface.
     * </p>
     *
     * @param createVpcEndpointRequest
     *        Contains the parameters for CreateVpcEndpoint.
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateVpcEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest) {

        StaxResponseHandler<CreateVpcEndpointResponse> responseHandler = new StaxResponseHandler<CreateVpcEndpointResponse>(
                new CreateVpcEndpointResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateVpcEndpointRequest, CreateVpcEndpointResponse>()
                .withMarshaller(new CreateVpcEndpointRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createVpcEndpointRequest));
    }

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and a peer VPC with which to
     * create the connection. The peer VPC can belong to another AWS account. The requester VPC and peer VPC cannot have
     * overlapping CIDR blocks.
     * </p>
     * <p>
     * The owner of the peer VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you try to create a VPC peering connection between VPCs that have overlapping CIDR blocks, the VPC peering
     * connection status goes to <code>failed</code>.
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     *        Contains the parameters for CreateVpcPeeringConnection.
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcPeeringConnectionResponse> createVpcPeeringConnection(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) {

        StaxResponseHandler<CreateVpcPeeringConnectionResponse> responseHandler = new StaxResponseHandler<CreateVpcPeeringConnectionResponse>(
                new CreateVpcPeeringConnectionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResponse>()
                        .withMarshaller(new CreateVpcPeeringConnectionRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createVpcPeeringConnectionRequest));
    }

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway and a VPN customer gateway. The only
     * supported connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">AWS
     * Managed VPN Connections</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRequest
     *        Contains the parameters for CreateVpnConnection.
     * @return A Java Future containing the result of the CreateVpnConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateVpnConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpnConnectionResponse> createVpnConnection(
            CreateVpnConnectionRequest createVpnConnectionRequest) {

        StaxResponseHandler<CreateVpnConnectionResponse> responseHandler = new StaxResponseHandler<CreateVpnConnectionResponse>(
                new CreateVpnConnectionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateVpnConnectionRequest, CreateVpnConnectionResponse>()
                .withMarshaller(new CreateVpnConnectionRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createVpnConnectionRequest));
    }

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information about VPN connections, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">AWS Managed VPN Connections</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRouteRequest
     *        Contains the parameters for CreateVpnConnectionRoute.
     * @return A Java Future containing the result of the CreateVpnConnectionRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateVpnConnectionRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpnConnectionRouteResponse> createVpnConnectionRoute(
            CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) {

        StaxResponseHandler<CreateVpnConnectionRouteResponse> responseHandler = new StaxResponseHandler<CreateVpnConnectionRouteResponse>(
                new CreateVpnConnectionRouteResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateVpnConnectionRouteRequest, CreateVpnConnectionRouteResponse>()
                        .withMarshaller(new CreateVpnConnectionRouteRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createVpnConnectionRouteRequest));
    }

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information about virtual private gateways, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">AWS Managed VPN Connections</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createVpnGatewayRequest
     *        Contains the parameters for CreateVpnGateway.
     * @return A Java Future containing the result of the CreateVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.CreateVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpnGatewayResponse> createVpnGateway(CreateVpnGatewayRequest createVpnGatewayRequest) {

        StaxResponseHandler<CreateVpnGatewayResponse> responseHandler = new StaxResponseHandler<CreateVpnGatewayResponse>(
                new CreateVpnGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateVpnGatewayRequest, CreateVpnGatewayResponse>()
                .withMarshaller(new CreateVpnGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createVpnGatewayRequest));
    }

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     *
     * @param deleteCustomerGatewayRequest
     *        Contains the parameters for DeleteCustomerGateway.
     * @return A Java Future containing the result of the DeleteCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteCustomerGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomerGatewayResponse> deleteCustomerGateway(
            DeleteCustomerGatewayRequest deleteCustomerGatewayRequest) {

        StaxResponseHandler<DeleteCustomerGatewayResponse> responseHandler = new StaxResponseHandler<DeleteCustomerGatewayResponse>(
                new DeleteCustomerGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteCustomerGatewayRequest, DeleteCustomerGatewayResponse>()
                .withMarshaller(new DeleteCustomerGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteCustomerGatewayRequest));
    }

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     *
     * @param deleteDhcpOptionsRequest
     *        Contains the parameters for DeleteDhcpOptions.
     * @return A Java Future containing the result of the DeleteDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDhcpOptionsResponse> deleteDhcpOptions(DeleteDhcpOptionsRequest deleteDhcpOptionsRequest) {

        StaxResponseHandler<DeleteDhcpOptionsResponse> responseHandler = new StaxResponseHandler<DeleteDhcpOptionsResponse>(
                new DeleteDhcpOptionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse>()
                .withMarshaller(new DeleteDhcpOptionsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDhcpOptionsRequest));
    }

    /**
     * <p>
     * Deletes an egress-only Internet gateway.
     * </p>
     *
     * @param deleteEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the DeleteEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteEgressOnlyInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEgressOnlyInternetGatewayResponse> deleteEgressOnlyInternetGateway(
            DeleteEgressOnlyInternetGatewayRequest deleteEgressOnlyInternetGatewayRequest) {

        StaxResponseHandler<DeleteEgressOnlyInternetGatewayResponse> responseHandler = new StaxResponseHandler<DeleteEgressOnlyInternetGatewayResponse>(
                new DeleteEgressOnlyInternetGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteEgressOnlyInternetGatewayRequest, DeleteEgressOnlyInternetGatewayResponse>()
                        .withMarshaller(new DeleteEgressOnlyInternetGatewayRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteEgressOnlyInternetGatewayRequest));
    }

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     *
     * @param deleteFlowLogsRequest
     *        Contains the parameters for DeleteFlowLogs.
     * @return A Java Future containing the result of the DeleteFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFlowLogsResponse> deleteFlowLogs(DeleteFlowLogsRequest deleteFlowLogsRequest) {

        StaxResponseHandler<DeleteFlowLogsResponse> responseHandler = new StaxResponseHandler<DeleteFlowLogsResponse>(
                new DeleteFlowLogsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteFlowLogsRequest, DeleteFlowLogsResponse>()
                .withMarshaller(new DeleteFlowLogsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteFlowLogsRequest));
    }

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     *
     * @param deleteFpgaImageRequest
     * @return A Java Future containing the result of the DeleteFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFpgaImageResponse> deleteFpgaImage(DeleteFpgaImageRequest deleteFpgaImageRequest) {

        StaxResponseHandler<DeleteFpgaImageResponse> responseHandler = new StaxResponseHandler<DeleteFpgaImageResponse>(
                new DeleteFpgaImageResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteFpgaImageRequest, DeleteFpgaImageResponse>()
                .withMarshaller(new DeleteFpgaImageRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteFpgaImageRequest));
    }

    /**
     * <p>
     * Deletes the specified Internet gateway. You must detach the Internet gateway from the VPC before you can delete
     * it.
     * </p>
     *
     * @param deleteInternetGatewayRequest
     *        Contains the parameters for DeleteInternetGateway.
     * @return A Java Future containing the result of the DeleteInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInternetGatewayResponse> deleteInternetGateway(
            DeleteInternetGatewayRequest deleteInternetGatewayRequest) {

        StaxResponseHandler<DeleteInternetGatewayResponse> responseHandler = new StaxResponseHandler<DeleteInternetGatewayResponse>(
                new DeleteInternetGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse>()
                .withMarshaller(new DeleteInternetGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteInternetGatewayRequest));
    }

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     *
     * @param deleteKeyPairRequest
     *        Contains the parameters for DeleteKeyPair.
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {

        StaxResponseHandler<DeleteKeyPairResponse> responseHandler = new StaxResponseHandler<DeleteKeyPairResponse>(
                new DeleteKeyPairResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteKeyPairRequest, DeleteKeyPairResponse>()
                .withMarshaller(new DeleteKeyPairRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteKeyPairRequest));
    }

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a NAT gateway disassociates its Elastic IP address, but does not
     * release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     *
     * @param deleteNatGatewayRequest
     *        Contains the parameters for DeleteNatGateway.
     * @return A Java Future containing the result of the DeleteNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteNatGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNatGatewayResponse> deleteNatGateway(DeleteNatGatewayRequest deleteNatGatewayRequest) {

        StaxResponseHandler<DeleteNatGatewayResponse> responseHandler = new StaxResponseHandler<DeleteNatGatewayResponse>(
                new DeleteNatGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteNatGatewayRequest, DeleteNatGatewayResponse>()
                .withMarshaller(new DeleteNatGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteNatGatewayRequest));
    }

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     *
     * @param deleteNetworkAclRequest
     *        Contains the parameters for DeleteNetworkAcl.
     * @return A Java Future containing the result of the DeleteNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteNetworkAcl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkAclResponse> deleteNetworkAcl(DeleteNetworkAclRequest deleteNetworkAclRequest) {

        StaxResponseHandler<DeleteNetworkAclResponse> responseHandler = new StaxResponseHandler<DeleteNetworkAclResponse>(
                new DeleteNetworkAclResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteNetworkAclRequest, DeleteNetworkAclResponse>()
                .withMarshaller(new DeleteNetworkAclRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteNetworkAclRequest));
    }

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     *
     * @param deleteNetworkAclEntryRequest
     *        Contains the parameters for DeleteNetworkAclEntry.
     * @return A Java Future containing the result of the DeleteNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteNetworkAclEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkAclEntryResponse> deleteNetworkAclEntry(
            DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest) {

        StaxResponseHandler<DeleteNetworkAclEntryResponse> responseHandler = new StaxResponseHandler<DeleteNetworkAclEntryResponse>(
                new DeleteNetworkAclEntryResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteNetworkAclEntryRequest, DeleteNetworkAclEntryResponse>()
                .withMarshaller(new DeleteNetworkAclEntryRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteNetworkAclEntryRequest));
    }

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     *
     * @param deleteNetworkInterfaceRequest
     *        Contains the parameters for DeleteNetworkInterface.
     * @return A Java Future containing the result of the DeleteNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInterfaceResponse> deleteNetworkInterface(
            DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest) {

        StaxResponseHandler<DeleteNetworkInterfaceResponse> responseHandler = new StaxResponseHandler<DeleteNetworkInterfaceResponse>(
                new DeleteNetworkInterfaceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteNetworkInterfaceRequest, DeleteNetworkInterfaceResponse>()
                .withMarshaller(new DeleteNetworkInterfaceRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteNetworkInterfaceRequest));
    }

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     *
     * @param deleteNetworkInterfacePermissionRequest
     *        Contains the parameters for DeleteNetworkInterfacePermission.
     * @return A Java Future containing the result of the DeleteNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteNetworkInterfacePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInterfacePermissionResponse> deleteNetworkInterfacePermission(
            DeleteNetworkInterfacePermissionRequest deleteNetworkInterfacePermissionRequest) {

        StaxResponseHandler<DeleteNetworkInterfacePermissionResponse> responseHandler = new StaxResponseHandler<DeleteNetworkInterfacePermissionResponse>(
                new DeleteNetworkInterfacePermissionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteNetworkInterfacePermissionRequest, DeleteNetworkInterfacePermissionResponse>()
                        .withMarshaller(new DeleteNetworkInterfacePermissionRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteNetworkInterfacePermissionRequest));
    }

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information about placement groups and cluster instances, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html">Cluster Instances</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deletePlacementGroupRequest
     *        Contains the parameters for DeletePlacementGroup.
     * @return A Java Future containing the result of the DeletePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeletePlacementGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePlacementGroupResponse> deletePlacementGroup(
            DeletePlacementGroupRequest deletePlacementGroupRequest) {

        StaxResponseHandler<DeletePlacementGroupResponse> responseHandler = new StaxResponseHandler<DeletePlacementGroupResponse>(
                new DeletePlacementGroupResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeletePlacementGroupRequest, DeletePlacementGroupResponse>()
                .withMarshaller(new DeletePlacementGroupRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deletePlacementGroupRequest));
    }

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     *
     * @param deleteRouteRequest
     *        Contains the parameters for DeleteRoute.
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRouteResponse> deleteRoute(DeleteRouteRequest deleteRouteRequest) {

        StaxResponseHandler<DeleteRouteResponse> responseHandler = new StaxResponseHandler<DeleteRouteResponse>(
                new DeleteRouteResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteRouteRequest, DeleteRouteResponse>()
                .withMarshaller(new DeleteRouteRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteRouteRequest));
    }

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     *
     * @param deleteRouteTableRequest
     *        Contains the parameters for DeleteRouteTable.
     * @return A Java Future containing the result of the DeleteRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRouteTableResponse> deleteRouteTable(DeleteRouteTableRequest deleteRouteTableRequest) {

        StaxResponseHandler<DeleteRouteTableResponse> responseHandler = new StaxResponseHandler<DeleteRouteTableResponse>(
                new DeleteRouteTableResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteRouteTableRequest, DeleteRouteTableResponse>()
                .withMarshaller(new DeleteRouteTableRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteRouteTableRequest));
    }

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance, or is referenced by another
     * security group, the operation fails with <code>InvalidGroup.InUse</code> in EC2-Classic or
     * <code>DependencyViolation</code> in EC2-VPC.
     * </p>
     *
     * @param deleteSecurityGroupRequest
     *        Contains the parameters for DeleteSecurityGroup.
     * @return A Java Future containing the result of the DeleteSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSecurityGroupResponse> deleteSecurityGroup(
            DeleteSecurityGroupRequest deleteSecurityGroupRequest) {

        StaxResponseHandler<DeleteSecurityGroupResponse> responseHandler = new StaxResponseHandler<DeleteSecurityGroupResponse>(
                new DeleteSecurityGroupResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteSecurityGroupRequest, DeleteSecurityGroupResponse>()
                .withMarshaller(new DeleteSecurityGroupRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteSecurityGroupRequest));
    }

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * de-register the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html">Deleting an Amazon EBS
     * Snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteSnapshotRequest
     *        Contains the parameters for DeleteSnapshot.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {

        StaxResponseHandler<DeleteSnapshotResponse> responseHandler = new StaxResponseHandler<DeleteSnapshotResponse>(
                new DeleteSnapshotResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                .withMarshaller(new DeleteSnapshotRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteSnapshotRequest));
    }

    /**
     * <p>
     * Deletes the data feed for Spot instances.
     * </p>
     *
     * @param deleteSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DeleteSpotDatafeedSubscription.
     * @return A Java Future containing the result of the DeleteSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSpotDatafeedSubscriptionResponse> deleteSpotDatafeedSubscription(
            DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest) {

        StaxResponseHandler<DeleteSpotDatafeedSubscriptionResponse> responseHandler = new StaxResponseHandler<DeleteSpotDatafeedSubscriptionResponse>(
                new DeleteSpotDatafeedSubscriptionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteSpotDatafeedSubscriptionRequest, DeleteSpotDatafeedSubscriptionResponse>()
                        .withMarshaller(new DeleteSpotDatafeedSubscriptionRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteSpotDatafeedSubscriptionRequest));
    }

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     *
     * @param deleteSubnetRequest
     *        Contains the parameters for DeleteSubnet.
     * @return A Java Future containing the result of the DeleteSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSubnetResponse> deleteSubnet(DeleteSubnetRequest deleteSubnetRequest) {

        StaxResponseHandler<DeleteSubnetResponse> responseHandler = new StaxResponseHandler<DeleteSubnetResponse>(
                new DeleteSubnetResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteSubnetRequest, DeleteSubnetResponse>()
                .withMarshaller(new DeleteSubnetRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteSubnetRequest));
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteTagsRequest
     *        Contains the parameters for DeleteTags.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {

        StaxResponseHandler<DeleteTagsResponse> responseHandler = new StaxResponseHandler<DeleteTagsResponse>(
                new DeleteTagsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>()
                .withMarshaller(new DeleteTagsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteTagsRequest));
    }

    /**
     * <p>
     * Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an
     * instance).
     * </p>
     * <note>
     * <p>
     * The volume may remain in the <code>deleting</code> state for several minutes.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html">Deleting an Amazon EBS
     * Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteVolumeRequest
     *        Contains the parameters for DeleteVolume.
     * @return A Java Future containing the result of the DeleteVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVolumeResponse> deleteVolume(DeleteVolumeRequest deleteVolumeRequest) {

        StaxResponseHandler<DeleteVolumeResponse> responseHandler = new StaxResponseHandler<DeleteVolumeResponse>(
                new DeleteVolumeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteVolumeRequest, DeleteVolumeResponse>()
                .withMarshaller(new DeleteVolumeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteVolumeRequest));
    }

    /**
     * <p>
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC
     * before you can delete it. For example, you must terminate all instances running in the VPC, delete all security
     * groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except
     * the default one), and so on.
     * </p>
     *
     * @param deleteVpcRequest
     *        Contains the parameters for DeleteVpc.
     * @return A Java Future containing the result of the DeleteVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcResponse> deleteVpc(DeleteVpcRequest deleteVpcRequest) {

        StaxResponseHandler<DeleteVpcResponse> responseHandler = new StaxResponseHandler<DeleteVpcResponse>(
                new DeleteVpcResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteVpcRequest, DeleteVpcResponse>()
                .withMarshaller(new DeleteVpcRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpcRequest));
    }

    /**
     * <p>
     * Deletes one or more specified VPC endpoints. Deleting a gateway endpoint also deletes the endpoint routes in the
     * route tables that were associated with the endpoint. Deleting an interface endpoint deletes the endpoint network
     * interfaces.
     * </p>
     *
     * @param deleteVpcEndpointsRequest
     *        Contains the parameters for DeleteVpcEndpoints.
     * @return A Java Future containing the result of the DeleteVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteVpcEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcEndpointsResponse> deleteVpcEndpoints(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest) {

        StaxResponseHandler<DeleteVpcEndpointsResponse> responseHandler = new StaxResponseHandler<DeleteVpcEndpointsResponse>(
                new DeleteVpcEndpointsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteVpcEndpointsRequest, DeleteVpcEndpointsResponse>()
                .withMarshaller(new DeleteVpcEndpointsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpcEndpointsRequest));
    }

    /**
     * <p>
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the peer VPC can delete
     * the VPC peering connection if it's in the <code>active</code> state. The owner of the requester VPC can delete a
     * VPC peering connection in the <code>pending-acceptance</code> state.
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     *        Contains the parameters for DeleteVpcPeeringConnection.
     * @return A Java Future containing the result of the DeleteVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcPeeringConnectionResponse> deleteVpcPeeringConnection(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) {

        StaxResponseHandler<DeleteVpcPeeringConnectionResponse> responseHandler = new StaxResponseHandler<DeleteVpcPeeringConnectionResponse>(
                new DeleteVpcPeeringConnectionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteVpcPeeringConnectionRequest, DeleteVpcPeeringConnectionResponse>()
                        .withMarshaller(new DeleteVpcPeeringConnectionRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpcPeeringConnectionRequest));
    }

    /**
     * <p>
     * Deletes the specified VPN connection.
     * </p>
     * <p>
     * If you're deleting the VPC and its associated components, we recommend that you detach the virtual private
     * gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel
     * credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one
     * that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway using the new configuration information returned with the
     * new VPN connection ID.
     * </p>
     *
     * @param deleteVpnConnectionRequest
     *        Contains the parameters for DeleteVpnConnection.
     * @return A Java Future containing the result of the DeleteVpnConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteVpnConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpnConnectionResponse> deleteVpnConnection(
            DeleteVpnConnectionRequest deleteVpnConnectionRequest) {

        StaxResponseHandler<DeleteVpnConnectionResponse> responseHandler = new StaxResponseHandler<DeleteVpnConnectionResponse>(
                new DeleteVpnConnectionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteVpnConnectionRequest, DeleteVpnConnectionResponse>()
                .withMarshaller(new DeleteVpnConnectionRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpnConnectionRequest));
    }

    /**
     * <p>
     * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway
     * and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the
     * VPN customer gateway.
     * </p>
     *
     * @param deleteVpnConnectionRouteRequest
     *        Contains the parameters for DeleteVpnConnectionRoute.
     * @return A Java Future containing the result of the DeleteVpnConnectionRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteVpnConnectionRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpnConnectionRouteResponse> deleteVpnConnectionRoute(
            DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest) {

        StaxResponseHandler<DeleteVpnConnectionRouteResponse> responseHandler = new StaxResponseHandler<DeleteVpnConnectionRouteResponse>(
                new DeleteVpnConnectionRouteResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteVpnConnectionRouteRequest, DeleteVpnConnectionRouteResponse>()
                        .withMarshaller(new DeleteVpnConnectionRouteRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpnConnectionRouteRequest));
    }

    /**
     * <p>
     * Deletes the specified virtual private gateway. We recommend that before you delete a virtual private gateway, you
     * detach it from the VPC and delete the VPN connection. Note that you don't need to delete the virtual private
     * gateway if you plan to delete and recreate the VPN connection between your VPC and your network.
     * </p>
     *
     * @param deleteVpnGatewayRequest
     *        Contains the parameters for DeleteVpnGateway.
     * @return A Java Future containing the result of the DeleteVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeleteVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpnGatewayResponse> deleteVpnGateway(DeleteVpnGatewayRequest deleteVpnGatewayRequest) {

        StaxResponseHandler<DeleteVpnGatewayResponse> responseHandler = new StaxResponseHandler<DeleteVpnGatewayResponse>(
                new DeleteVpnGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteVpnGatewayRequest, DeleteVpnGatewayResponse>()
                .withMarshaller(new DeleteVpnGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpnGatewayRequest));
    }

    /**
     * <p>
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances; however, it
     * doesn't affect any instances that you've already launched from the AMI. You'll continue to incur usage costs for
     * those instances until you terminate them.
     * </p>
     * <p>
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume
     * of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't
     * affect the files that you uploaded to Amazon S3 when you created the AMI.
     * </p>
     *
     * @param deregisterImageRequest
     *        Contains the parameters for DeregisterImage.
     * @return A Java Future containing the result of the DeregisterImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DeregisterImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterImageResponse> deregisterImage(DeregisterImageRequest deregisterImageRequest) {

        StaxResponseHandler<DeregisterImageResponse> responseHandler = new StaxResponseHandler<DeregisterImageResponse>(
                new DeregisterImageResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeregisterImageRequest, DeregisterImageResponse>()
                .withMarshaller(new DeregisterImageRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deregisterImageRequest));
    }

    /**
     * <p>
     * Describes attributes of your AWS account. The following are the supported account attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>supported-platforms</code>: Indicates whether your account can launch instances into EC2-Classic and
     * EC2-VPC, or only into EC2-VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-instances</code>: The maximum number of On-Demand instances that you can run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to
     * a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-Classic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-VPC.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountAttributesRequest
     *        Contains the parameters for DescribeAccountAttributes.
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {

        StaxResponseHandler<DescribeAccountAttributesResponse> responseHandler = new StaxResponseHandler<DescribeAccountAttributesResponse>(
                new DescribeAccountAttributesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                        .withMarshaller(new DescribeAccountAttributesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountAttributesRequest));
    }

    /**
     * <p>
     * Describes one or more of your Elastic IP addresses.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeAddressesRequest
     *        Contains the parameters for DescribeAddresses.
     * @return A Java Future containing the result of the DescribeAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAddressesResponse> describeAddresses(DescribeAddressesRequest describeAddressesRequest) {

        StaxResponseHandler<DescribeAddressesResponse> responseHandler = new StaxResponseHandler<DescribeAddressesResponse>(
                new DescribeAddressesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeAddressesRequest, DescribeAddressesResponse>()
                .withMarshaller(new DescribeAddressesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeAddressesRequest));
    }

    /**
     * <p>
     * Describes one or more of the Availability Zones that are available to you. The results include zones only for the
     * region you're currently using. If there is an event impacting an Availability Zone, you can use this request to
     * view the state and any provided message for that Availability Zone.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and
     * Availability Zones</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeAvailabilityZonesRequest
     *        Contains the parameters for DescribeAvailabilityZones.
     * @return A Java Future containing the result of the DescribeAvailabilityZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeAvailabilityZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAvailabilityZonesResponse> describeAvailabilityZones(
            DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) {

        StaxResponseHandler<DescribeAvailabilityZonesResponse> responseHandler = new StaxResponseHandler<DescribeAvailabilityZonesResponse>(
                new DescribeAvailabilityZonesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeAvailabilityZonesRequest, DescribeAvailabilityZonesResponse>()
                        .withMarshaller(new DescribeAvailabilityZonesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeAvailabilityZonesRequest));
    }

    /**
     * <p>
     * Describes one or more of your bundling tasks.
     * </p>
     * <note>
     * <p>
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can
     * still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image
     * manifest name you provided to the bundle task.
     * </p>
     * </note>
     *
     * @param describeBundleTasksRequest
     *        Contains the parameters for DescribeBundleTasks.
     * @return A Java Future containing the result of the DescribeBundleTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeBundleTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBundleTasksResponse> describeBundleTasks(
            DescribeBundleTasksRequest describeBundleTasksRequest) {

        StaxResponseHandler<DescribeBundleTasksResponse> responseHandler = new StaxResponseHandler<DescribeBundleTasksResponse>(
                new DescribeBundleTasksResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeBundleTasksRequest, DescribeBundleTasksResponse>()
                .withMarshaller(new DescribeBundleTasksRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeBundleTasksRequest));
    }

    /**
     * <p>
     * Describes one or more of your linked EC2-Classic instances. This request only returns information about
     * EC2-Classic instances linked to a VPC through ClassicLink; you cannot use this request to return information
     * about other instances.
     * </p>
     *
     * @param describeClassicLinkInstancesRequest
     *        Contains the parameters for DescribeClassicLinkInstances.
     * @return A Java Future containing the result of the DescribeClassicLinkInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeClassicLinkInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClassicLinkInstancesResponse> describeClassicLinkInstances(
            DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest) {

        StaxResponseHandler<DescribeClassicLinkInstancesResponse> responseHandler = new StaxResponseHandler<DescribeClassicLinkInstancesResponse>(
                new DescribeClassicLinkInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeClassicLinkInstancesRequest, DescribeClassicLinkInstancesResponse>()
                        .withMarshaller(new DescribeClassicLinkInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeClassicLinkInstancesRequest));
    }

    /**
     * <p>
     * Describes one or more of your conversion tasks. For more information, see the <a
     * href="http://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide</a>.
     * </p>
     * <p>
     * For information about the import manifest referenced by this API action, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     * </p>
     *
     * @param describeConversionTasksRequest
     *        Contains the parameters for DescribeConversionTasks.
     * @return A Java Future containing the result of the DescribeConversionTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeConversionTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConversionTasksResponse> describeConversionTasks(
            DescribeConversionTasksRequest describeConversionTasksRequest) {

        StaxResponseHandler<DescribeConversionTasksResponse> responseHandler = new StaxResponseHandler<DescribeConversionTasksResponse>(
                new DescribeConversionTasksResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeConversionTasksRequest, DescribeConversionTasksResponse>()
                .withMarshaller(new DescribeConversionTasksRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeConversionTasksRequest));
    }

    /**
     * <p>
     * Describes one or more of your VPN customer gateways.
     * </p>
     * <p>
     * For more information about VPN customer gateways, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">AWS Managed VPN Connections</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeCustomerGatewaysRequest
     *        Contains the parameters for DescribeCustomerGateways.
     * @return A Java Future containing the result of the DescribeCustomerGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeCustomerGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomerGatewaysResponse> describeCustomerGateways(
            DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {

        StaxResponseHandler<DescribeCustomerGatewaysResponse> responseHandler = new StaxResponseHandler<DescribeCustomerGatewaysResponse>(
                new DescribeCustomerGatewaysResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeCustomerGatewaysRequest, DescribeCustomerGatewaysResponse>()
                        .withMarshaller(new DescribeCustomerGatewaysRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeCustomerGatewaysRequest));
    }

    /**
     * <p>
     * Describes one or more of your DHCP options sets.
     * </p>
     * <p>
     * For more information about DHCP options sets, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeDhcpOptionsRequest
     *        Contains the parameters for DescribeDhcpOptions.
     * @return A Java Future containing the result of the DescribeDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDhcpOptionsResponse> describeDhcpOptions(
            DescribeDhcpOptionsRequest describeDhcpOptionsRequest) {

        StaxResponseHandler<DescribeDhcpOptionsResponse> responseHandler = new StaxResponseHandler<DescribeDhcpOptionsResponse>(
                new DescribeDhcpOptionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeDhcpOptionsRequest, DescribeDhcpOptionsResponse>()
                .withMarshaller(new DescribeDhcpOptionsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeDhcpOptionsRequest));
    }

    /**
     * <p>
     * Describes one or more of your egress-only Internet gateways.
     * </p>
     *
     * @param describeEgressOnlyInternetGatewaysRequest
     * @return A Java Future containing the result of the DescribeEgressOnlyInternetGateways operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeEgressOnlyInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEgressOnlyInternetGatewaysResponse> describeEgressOnlyInternetGateways(
            DescribeEgressOnlyInternetGatewaysRequest describeEgressOnlyInternetGatewaysRequest) {

        StaxResponseHandler<DescribeEgressOnlyInternetGatewaysResponse> responseHandler = new StaxResponseHandler<DescribeEgressOnlyInternetGatewaysResponse>(
                new DescribeEgressOnlyInternetGatewaysResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeEgressOnlyInternetGatewaysRequest, DescribeEgressOnlyInternetGatewaysResponse>()
                        .withMarshaller(new DescribeEgressOnlyInternetGatewaysRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeEgressOnlyInternetGatewaysRequest));
    }

    /**
     * <p>
     * Describes the Elastic GPUs associated with your instances. For more information about Elastic GPUs, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-gpus.html">Amazon EC2 Elastic GPUs</a>.
     * </p>
     *
     * @param describeElasticGpusRequest
     * @return A Java Future containing the result of the DescribeElasticGpus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeElasticGpus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeElasticGpusResponse> describeElasticGpus(
            DescribeElasticGpusRequest describeElasticGpusRequest) {

        StaxResponseHandler<DescribeElasticGpusResponse> responseHandler = new StaxResponseHandler<DescribeElasticGpusResponse>(
                new DescribeElasticGpusResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeElasticGpusRequest, DescribeElasticGpusResponse>()
                .withMarshaller(new DescribeElasticGpusRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeElasticGpusRequest));
    }

    /**
     * <p>
     * Describes one or more of your export tasks.
     * </p>
     *
     * @param describeExportTasksRequest
     *        Contains the parameters for DescribeExportTasks.
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeExportTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeExportTasksResponse> describeExportTasks(
            DescribeExportTasksRequest describeExportTasksRequest) {

        StaxResponseHandler<DescribeExportTasksResponse> responseHandler = new StaxResponseHandler<DescribeExportTasksResponse>(
                new DescribeExportTasksResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeExportTasksRequest, DescribeExportTasksResponse>()
                .withMarshaller(new DescribeExportTasksRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeExportTasksRequest));
    }

    /**
     * <p>
     * Describes one or more flow logs. To view the information in your flow logs (the log streams for the network
     * interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs API.
     * </p>
     *
     * @param describeFlowLogsRequest
     *        Contains the parameters for DescribeFlowLogs.
     * @return A Java Future containing the result of the DescribeFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlowLogsResponse> describeFlowLogs(DescribeFlowLogsRequest describeFlowLogsRequest) {

        StaxResponseHandler<DescribeFlowLogsResponse> responseHandler = new StaxResponseHandler<DescribeFlowLogsResponse>(
                new DescribeFlowLogsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeFlowLogsRequest, DescribeFlowLogsResponse>()
                .withMarshaller(new DescribeFlowLogsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeFlowLogsRequest));
    }

    /**
     * <p>
     * Describes the specified attribute of the specified Amazon FPGA Image (AFI).
     * </p>
     *
     * @param describeFpgaImageAttributeRequest
     * @return A Java Future containing the result of the DescribeFpgaImageAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeFpgaImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFpgaImageAttributeResponse> describeFpgaImageAttribute(
            DescribeFpgaImageAttributeRequest describeFpgaImageAttributeRequest) {

        StaxResponseHandler<DescribeFpgaImageAttributeResponse> responseHandler = new StaxResponseHandler<DescribeFpgaImageAttributeResponse>(
                new DescribeFpgaImageAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeFpgaImageAttributeRequest, DescribeFpgaImageAttributeResponse>()
                        .withMarshaller(new DescribeFpgaImageAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeFpgaImageAttributeRequest));
    }

    /**
     * <p>
     * Describes one or more available Amazon FPGA Images (AFIs). These include public AFIs, private AFIs that you own,
     * and AFIs owned by other AWS accounts for which you have load permissions.
     * </p>
     *
     * @param describeFpgaImagesRequest
     * @return A Java Future containing the result of the DescribeFpgaImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeFpgaImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFpgaImagesResponse> describeFpgaImages(DescribeFpgaImagesRequest describeFpgaImagesRequest) {

        StaxResponseHandler<DescribeFpgaImagesResponse> responseHandler = new StaxResponseHandler<DescribeFpgaImagesResponse>(
                new DescribeFpgaImagesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeFpgaImagesRequest, DescribeFpgaImagesResponse>()
                .withMarshaller(new DescribeFpgaImagesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeFpgaImagesRequest));
    }

    /**
     * <p>
     * Describes the Dedicated Host Reservations that are available to purchase.
     * </p>
     * <p>
     * The results describe all the Dedicated Host Reservation offerings, including offerings that may not match the
     * instance family and region of your Dedicated Hosts. When purchasing an offering, ensure that the the instance
     * family and region of the offering matches that of the Dedicated Host/s it will be associated with. For an
     * overview of supported instance types, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts
     * Overview</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeHostReservationOfferingsRequest
     * @return A Java Future containing the result of the DescribeHostReservationOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeHostReservationOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHostReservationOfferingsResponse> describeHostReservationOfferings(
            DescribeHostReservationOfferingsRequest describeHostReservationOfferingsRequest) {

        StaxResponseHandler<DescribeHostReservationOfferingsResponse> responseHandler = new StaxResponseHandler<DescribeHostReservationOfferingsResponse>(
                new DescribeHostReservationOfferingsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeHostReservationOfferingsRequest, DescribeHostReservationOfferingsResponse>()
                        .withMarshaller(new DescribeHostReservationOfferingsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeHostReservationOfferingsRequest));
    }

    /**
     * <p>
     * Describes Dedicated Host Reservations which are associated with Dedicated Hosts in your account.
     * </p>
     *
     * @param describeHostReservationsRequest
     * @return A Java Future containing the result of the DescribeHostReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeHostReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHostReservationsResponse> describeHostReservations(
            DescribeHostReservationsRequest describeHostReservationsRequest) {

        StaxResponseHandler<DescribeHostReservationsResponse> responseHandler = new StaxResponseHandler<DescribeHostReservationsResponse>(
                new DescribeHostReservationsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeHostReservationsRequest, DescribeHostReservationsResponse>()
                        .withMarshaller(new DescribeHostReservationsRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeHostReservationsRequest));
    }

    /**
     * <p>
     * Describes one or more of your Dedicated Hosts.
     * </p>
     * <p>
     * The results describe only the Dedicated Hosts in the region you're currently using. All listed instances consume
     * capacity on your Dedicated Host. Dedicated Hosts that have recently been released will be listed with the state
     * <code>released</code>.
     * </p>
     *
     * @param describeHostsRequest
     *        Contains the parameters for DescribeHosts.
     * @return A Java Future containing the result of the DescribeHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHostsResponse> describeHosts(DescribeHostsRequest describeHostsRequest) {

        StaxResponseHandler<DescribeHostsResponse> responseHandler = new StaxResponseHandler<DescribeHostsResponse>(
                new DescribeHostsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeHostsRequest, DescribeHostsResponse>()
                .withMarshaller(new DescribeHostsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeHostsRequest));
    }

    /**
     * <p>
     * Describes your IAM instance profile associations.
     * </p>
     *
     * @param describeIamInstanceProfileAssociationsRequest
     * @return A Java Future containing the result of the DescribeIamInstanceProfileAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeIamInstanceProfileAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIamInstanceProfileAssociationsResponse> describeIamInstanceProfileAssociations(
            DescribeIamInstanceProfileAssociationsRequest describeIamInstanceProfileAssociationsRequest) {

        StaxResponseHandler<DescribeIamInstanceProfileAssociationsResponse> responseHandler = new StaxResponseHandler<DescribeIamInstanceProfileAssociationsResponse>(
                new DescribeIamInstanceProfileAssociationsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeIamInstanceProfileAssociationsRequest, DescribeIamInstanceProfileAssociationsResponse>()
                        .withMarshaller(new DescribeIamInstanceProfileAssociationsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeIamInstanceProfileAssociationsRequest));
    }

    /**
     * <p>
     * Describes the ID format settings for your resources on a per-region basis, for example, to view which resource
     * types are enabled for longer IDs. This request only returns information about resource types whose ID formats can
     * be modified; it does not return information about other resource types.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>instance</code> | <code>reservation</code> |
     * <code>snapshot</code> | <code>volume</code>.
     * </p>
     * <p>
     * These settings apply to the IAM user who makes the request; they do not apply to the entire AWS account. By
     * default, an IAM user defaults to the same settings as the root user, unless they explicitly override the settings
     * by running the <a>ModifyIdFormat</a> command. Resources created with longer IDs are visible to all IAM users,
     * regardless of these settings and provided that they have permission to use the relevant <code>Describe</code>
     * command for the resource type.
     * </p>
     *
     * @param describeIdFormatRequest
     *        Contains the parameters for DescribeIdFormat.
     * @return A Java Future containing the result of the DescribeIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIdFormatResponse> describeIdFormat(DescribeIdFormatRequest describeIdFormatRequest) {

        StaxResponseHandler<DescribeIdFormatResponse> responseHandler = new StaxResponseHandler<DescribeIdFormatResponse>(
                new DescribeIdFormatResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeIdFormatRequest, DescribeIdFormatResponse>()
                .withMarshaller(new DescribeIdFormatRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeIdFormatRequest));
    }

    /**
     * <p>
     * Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example,
     * you can view the resource types that are enabled for longer IDs. This request only returns information about
     * resource types whose ID formats can be modified; it does not return information about other resource types. For
     * more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource
     * IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>instance</code> | <code>reservation</code> |
     * <code>snapshot</code> | <code>volume</code>.
     * </p>
     * <p>
     * These settings apply to the principal specified in the request. They do not apply to the principal that makes the
     * request.
     * </p>
     *
     * @param describeIdentityIdFormatRequest
     *        Contains the parameters for DescribeIdentityIdFormat.
     * @return A Java Future containing the result of the DescribeIdentityIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeIdentityIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIdentityIdFormatResponse> describeIdentityIdFormat(
            DescribeIdentityIdFormatRequest describeIdentityIdFormatRequest) {

        StaxResponseHandler<DescribeIdentityIdFormatResponse> responseHandler = new StaxResponseHandler<DescribeIdentityIdFormatResponse>(
                new DescribeIdentityIdFormatResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeIdentityIdFormatRequest, DescribeIdentityIdFormatResponse>()
                        .withMarshaller(new DescribeIdentityIdFormatRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeIdentityIdFormatRequest));
    }

    /**
     * <p>
     * Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
     * </p>
     *
     * @param describeImageAttributeRequest
     *        Contains the parameters for DescribeImageAttribute.
     * @return A Java Future containing the result of the DescribeImageAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImageAttributeResponse> describeImageAttribute(
            DescribeImageAttributeRequest describeImageAttributeRequest) {

        StaxResponseHandler<DescribeImageAttributeResponse> responseHandler = new StaxResponseHandler<DescribeImageAttributeResponse>(
                new DescribeImageAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeImageAttributeRequest, DescribeImageAttributeResponse>()
                .withMarshaller(new DescribeImageAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeImageAttributeRequest));
    }

    /**
     * <p>
     * Describes one or more of the images (AMIs, AKIs, and ARIs) available to you. Images available to you include
     * public images, private images that you own, and private images owned by other AWS accounts but for which you have
     * explicit launch permissions.
     * </p>
     * <note>
     * <p>
     * Deregistered images are included in the returned results for an unspecified interval after deregistration.
     * </p>
     * </note>
     *
     * @param describeImagesRequest
     *        Contains the parameters for DescribeImages.
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImagesResponse> describeImages(DescribeImagesRequest describeImagesRequest) {

        StaxResponseHandler<DescribeImagesResponse> responseHandler = new StaxResponseHandler<DescribeImagesResponse>(
                new DescribeImagesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeImagesRequest, DescribeImagesResponse>()
                .withMarshaller(new DescribeImagesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeImagesRequest));
    }

    /**
     * <p>
     * Displays details about an import virtual machine or import snapshot tasks that are already created.
     * </p>
     *
     * @param describeImportImageTasksRequest
     *        Contains the parameters for DescribeImportImageTasks.
     * @return A Java Future containing the result of the DescribeImportImageTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeImportImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImportImageTasksResponse> describeImportImageTasks(
            DescribeImportImageTasksRequest describeImportImageTasksRequest) {

        StaxResponseHandler<DescribeImportImageTasksResponse> responseHandler = new StaxResponseHandler<DescribeImportImageTasksResponse>(
                new DescribeImportImageTasksResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeImportImageTasksRequest, DescribeImportImageTasksResponse>()
                        .withMarshaller(new DescribeImportImageTasksRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeImportImageTasksRequest));
    }

    /**
     * <p>
     * Describes your import snapshot tasks.
     * </p>
     *
     * @param describeImportSnapshotTasksRequest
     *        Contains the parameters for DescribeImportSnapshotTasks.
     * @return A Java Future containing the result of the DescribeImportSnapshotTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeImportSnapshotTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImportSnapshotTasksResponse> describeImportSnapshotTasks(
            DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {

        StaxResponseHandler<DescribeImportSnapshotTasksResponse> responseHandler = new StaxResponseHandler<DescribeImportSnapshotTasksResponse>(
                new DescribeImportSnapshotTasksResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeImportSnapshotTasksRequest, DescribeImportSnapshotTasksResponse>()
                        .withMarshaller(new DescribeImportSnapshotTasksRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeImportSnapshotTasksRequest));
    }

    /**
     * <p>
     * Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid
     * attribute values are: <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> |
     * <code>userData</code> | <code>disableApiTermination</code> | <code>instanceInitiatedShutdownBehavior</code> |
     * <code>rootDeviceName</code> | <code>blockDeviceMapping</code> | <code>productCodes</code> |
     * <code>sourceDestCheck</code> | <code>groupSet</code> | <code>ebsOptimized</code> | <code>sriovNetSupport</code>
     * </p>
     *
     * @param describeInstanceAttributeRequest
     *        Contains the parameters for DescribeInstanceAttribute.
     * @return A Java Future containing the result of the DescribeInstanceAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeInstanceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceAttributeResponse> describeInstanceAttribute(
            DescribeInstanceAttributeRequest describeInstanceAttributeRequest) {

        StaxResponseHandler<DescribeInstanceAttributeResponse> responseHandler = new StaxResponseHandler<DescribeInstanceAttributeResponse>(
                new DescribeInstanceAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeInstanceAttributeRequest, DescribeInstanceAttributeResponse>()
                        .withMarshaller(new DescribeInstanceAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeInstanceAttributeRequest));
    }

    /**
     * <p>
     * Describes the status of one or more instances. By default, only running instances are described, unless you
     * specifically indicate to return the status of all instances.
     * </p>
     * <p>
     * Instance status includes the following components:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Status checks</b> - Amazon EC2 performs status checks on running EC2 instances to identify hardware and
     * software issues. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status
     * Checks for Your Instances</a> and <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshooting Instances
     * with Failed Status Checks</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Scheduled events</b> - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances
     * related to hardware issues, software updates, or system maintenance. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled
     * Events for Your Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Instance state</b> - You can manage your instances from the moment you launch them through their termination.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance Lifecycle</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeInstanceStatusRequest
     *        Contains the parameters for DescribeInstanceStatus.
     * @return A Java Future containing the result of the DescribeInstanceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeInstanceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceStatusResponse> describeInstanceStatus(
            DescribeInstanceStatusRequest describeInstanceStatusRequest) {

        StaxResponseHandler<DescribeInstanceStatusResponse> responseHandler = new StaxResponseHandler<DescribeInstanceStatusResponse>(
                new DescribeInstanceStatusResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeInstanceStatusRequest, DescribeInstanceStatusResponse>()
                .withMarshaller(new DescribeInstanceStatusRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeInstanceStatusRequest));
    }

    /**
     * <p>
     * Describes one or more of your instances.
     * </p>
     * <p>
     * If you specify one or more instance IDs, Amazon EC2 returns information for those instances. If you do not
     * specify instance IDs, Amazon EC2 returns information for all relevant instances. If you specify an instance ID
     * that is not valid, an error is returned. If you specify an instance that you do not own, it is not included in
     * the returned results.
     * </p>
     * <p>
     * Recently terminated instances might appear in the returned results. This interval is usually less than one hour.
     * </p>
     * <p>
     * If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and
     * you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call
     * fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works
     * normally.
     * </p>
     *
     * @param describeInstancesRequest
     *        Contains the parameters for DescribeInstances.
     * @return A Java Future containing the result of the DescribeInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstancesResponse> describeInstances(DescribeInstancesRequest describeInstancesRequest) {

        StaxResponseHandler<DescribeInstancesResponse> responseHandler = new StaxResponseHandler<DescribeInstancesResponse>(
                new DescribeInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeInstancesRequest, DescribeInstancesResponse>()
                .withMarshaller(new DescribeInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeInstancesRequest));
    }

    /**
     * <p>
     * Describes one or more of your Internet gateways.
     * </p>
     *
     * @param describeInternetGatewaysRequest
     *        Contains the parameters for DescribeInternetGateways.
     * @return A Java Future containing the result of the DescribeInternetGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInternetGatewaysResponse> describeInternetGateways(
            DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {

        StaxResponseHandler<DescribeInternetGatewaysResponse> responseHandler = new StaxResponseHandler<DescribeInternetGatewaysResponse>(
                new DescribeInternetGatewaysResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeInternetGatewaysRequest, DescribeInternetGatewaysResponse>()
                        .withMarshaller(new DescribeInternetGatewaysRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeInternetGatewaysRequest));
    }

    /**
     * <p>
     * Describes one or more of your key pairs.
     * </p>
     * <p>
     * For more information about key pairs, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeKeyPairsRequest
     *        Contains the parameters for DescribeKeyPairs.
     * @return A Java Future containing the result of the DescribeKeyPairs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeKeyPairsResponse> describeKeyPairs(DescribeKeyPairsRequest describeKeyPairsRequest) {

        StaxResponseHandler<DescribeKeyPairsResponse> responseHandler = new StaxResponseHandler<DescribeKeyPairsResponse>(
                new DescribeKeyPairsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeKeyPairsRequest, DescribeKeyPairsResponse>()
                .withMarshaller(new DescribeKeyPairsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeKeyPairsRequest));
    }

    /**
     * <p>
     * Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to
     * the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your
     * account.
     * </p>
     *
     * @param describeMovingAddressesRequest
     *        Contains the parameters for DescribeMovingAddresses.
     * @return A Java Future containing the result of the DescribeMovingAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeMovingAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMovingAddressesResponse> describeMovingAddresses(
            DescribeMovingAddressesRequest describeMovingAddressesRequest) {

        StaxResponseHandler<DescribeMovingAddressesResponse> responseHandler = new StaxResponseHandler<DescribeMovingAddressesResponse>(
                new DescribeMovingAddressesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeMovingAddressesRequest, DescribeMovingAddressesResponse>()
                .withMarshaller(new DescribeMovingAddressesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeMovingAddressesRequest));
    }

    /**
     * <p>
     * Describes one or more of the your NAT gateways.
     * </p>
     *
     * @param describeNatGatewaysRequest
     *        Contains the parameters for DescribeNatGateways.
     * @return A Java Future containing the result of the DescribeNatGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeNatGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNatGatewaysResponse> describeNatGateways(
            DescribeNatGatewaysRequest describeNatGatewaysRequest) {

        StaxResponseHandler<DescribeNatGatewaysResponse> responseHandler = new StaxResponseHandler<DescribeNatGatewaysResponse>(
                new DescribeNatGatewaysResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeNatGatewaysRequest, DescribeNatGatewaysResponse>()
                .withMarshaller(new DescribeNatGatewaysRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeNatGatewaysRequest));
    }

    /**
     * <p>
     * Describes one or more of your network ACLs.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon
     * Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeNetworkAclsRequest
     *        Contains the parameters for DescribeNetworkAcls.
     * @return A Java Future containing the result of the DescribeNetworkAcls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeNetworkAcls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNetworkAclsResponse> describeNetworkAcls(
            DescribeNetworkAclsRequest describeNetworkAclsRequest) {

        StaxResponseHandler<DescribeNetworkAclsResponse> responseHandler = new StaxResponseHandler<DescribeNetworkAclsResponse>(
                new DescribeNetworkAclsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeNetworkAclsRequest, DescribeNetworkAclsResponse>()
                .withMarshaller(new DescribeNetworkAclsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeNetworkAclsRequest));
    }

    /**
     * <p>
     * Describes a network interface attribute. You can specify only one attribute at a time.
     * </p>
     *
     * @param describeNetworkInterfaceAttributeRequest
     *        Contains the parameters for DescribeNetworkInterfaceAttribute.
     * @return A Java Future containing the result of the DescribeNetworkInterfaceAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeNetworkInterfaceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNetworkInterfaceAttributeResponse> describeNetworkInterfaceAttribute(
            DescribeNetworkInterfaceAttributeRequest describeNetworkInterfaceAttributeRequest) {

        StaxResponseHandler<DescribeNetworkInterfaceAttributeResponse> responseHandler = new StaxResponseHandler<DescribeNetworkInterfaceAttributeResponse>(
                new DescribeNetworkInterfaceAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeNetworkInterfaceAttributeRequest, DescribeNetworkInterfaceAttributeResponse>()
                        .withMarshaller(new DescribeNetworkInterfaceAttributeRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeNetworkInterfaceAttributeRequest));
    }

    /**
     * <p>
     * Describes the permissions for your network interfaces.
     * </p>
     *
     * @param describeNetworkInterfacePermissionsRequest
     *        Contains the parameters for DescribeNetworkInterfacePermissions.
     * @return A Java Future containing the result of the DescribeNetworkInterfacePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeNetworkInterfacePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNetworkInterfacePermissionsResponse> describeNetworkInterfacePermissions(
            DescribeNetworkInterfacePermissionsRequest describeNetworkInterfacePermissionsRequest) {

        StaxResponseHandler<DescribeNetworkInterfacePermissionsResponse> responseHandler = new StaxResponseHandler<DescribeNetworkInterfacePermissionsResponse>(
                new DescribeNetworkInterfacePermissionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeNetworkInterfacePermissionsRequest, DescribeNetworkInterfacePermissionsResponse>()
                        .withMarshaller(new DescribeNetworkInterfacePermissionsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeNetworkInterfacePermissionsRequest));
    }

    /**
     * <p>
     * Describes one or more of your network interfaces.
     * </p>
     *
     * @param describeNetworkInterfacesRequest
     *        Contains the parameters for DescribeNetworkInterfaces.
     * @return A Java Future containing the result of the DescribeNetworkInterfaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeNetworkInterfaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNetworkInterfacesResponse> describeNetworkInterfaces(
            DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {

        StaxResponseHandler<DescribeNetworkInterfacesResponse> responseHandler = new StaxResponseHandler<DescribeNetworkInterfacesResponse>(
                new DescribeNetworkInterfacesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeNetworkInterfacesRequest, DescribeNetworkInterfacesResponse>()
                        .withMarshaller(new DescribeNetworkInterfacesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeNetworkInterfacesRequest));
    }

    /**
     * <p>
     * Describes one or more of your placement groups. For more information about placement groups and cluster
     * instances, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html">Cluster
     * Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describePlacementGroupsRequest
     *        Contains the parameters for DescribePlacementGroups.
     * @return A Java Future containing the result of the DescribePlacementGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribePlacementGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePlacementGroupsResponse> describePlacementGroups(
            DescribePlacementGroupsRequest describePlacementGroupsRequest) {

        StaxResponseHandler<DescribePlacementGroupsResponse> responseHandler = new StaxResponseHandler<DescribePlacementGroupsResponse>(
                new DescribePlacementGroupsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribePlacementGroupsRequest, DescribePlacementGroupsResponse>()
                .withMarshaller(new DescribePlacementGroupsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describePlacementGroupsRequest));
    }

    /**
     * <p>
     * Describes available AWS services in a prefix list format, which includes the prefix list name and prefix list ID
     * of the service and the IP address range for the service. A prefix list ID is required for creating an outbound
     * security group rule that allows traffic from a VPC to access an AWS service through a VPC endpoint.
     * </p>
     *
     * @param describePrefixListsRequest
     *        Contains the parameters for DescribePrefixLists.
     * @return A Java Future containing the result of the DescribePrefixLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribePrefixLists
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePrefixListsResponse> describePrefixLists(
            DescribePrefixListsRequest describePrefixListsRequest) {

        StaxResponseHandler<DescribePrefixListsResponse> responseHandler = new StaxResponseHandler<DescribePrefixListsResponse>(
                new DescribePrefixListsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribePrefixListsRequest, DescribePrefixListsResponse>()
                .withMarshaller(new DescribePrefixListsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describePrefixListsRequest));
    }

    /**
     * <p>
     * Describes one or more regions that are currently available to you.
     * </p>
     * <p>
     * For a list of the regions supported by Amazon EC2, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region">Regions and Endpoints</a>.
     * </p>
     *
     * @param describeRegionsRequest
     *        Contains the parameters for DescribeRegions.
     * @return A Java Future containing the result of the DescribeRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegionsResponse> describeRegions(DescribeRegionsRequest describeRegionsRequest) {

        StaxResponseHandler<DescribeRegionsResponse> responseHandler = new StaxResponseHandler<DescribeRegionsResponse>(
                new DescribeRegionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeRegionsRequest, DescribeRegionsResponse>()
                .withMarshaller(new DescribeRegionsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeRegionsRequest));
    }

    /**
     * <p>
     * Describes one or more of the Reserved Instances that you purchased.
     * </p>
     * <p>
     * For more information about Reserved Instances, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved
     * Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        Contains the parameters for DescribeReservedInstances.
     * @return A Java Future containing the result of the DescribeReservedInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeReservedInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedInstancesResponse> describeReservedInstances(
            DescribeReservedInstancesRequest describeReservedInstancesRequest) {

        StaxResponseHandler<DescribeReservedInstancesResponse> responseHandler = new StaxResponseHandler<DescribeReservedInstancesResponse>(
                new DescribeReservedInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeReservedInstancesRequest, DescribeReservedInstancesResponse>()
                        .withMarshaller(new DescribeReservedInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeReservedInstancesRequest));
    }

    /**
     * <p>
     * Describes your account's Reserved Instance listings in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no
     * longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the
     * Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to
     * receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available
     * for purchase.
     * </p>
     * <p>
     * As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what
     * you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to
     * you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged
     * based on the total price of all of the listings that you purchase.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeReservedInstancesListingsRequest
     *        Contains the parameters for DescribeReservedInstancesListings.
     * @return A Java Future containing the result of the DescribeReservedInstancesListings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeReservedInstancesListings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedInstancesListingsResponse> describeReservedInstancesListings(
            DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest) {

        StaxResponseHandler<DescribeReservedInstancesListingsResponse> responseHandler = new StaxResponseHandler<DescribeReservedInstancesListingsResponse>(
                new DescribeReservedInstancesListingsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeReservedInstancesListingsRequest, DescribeReservedInstancesListingsResponse>()
                        .withMarshaller(new DescribeReservedInstancesListingsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeReservedInstancesListingsRequest));
    }

    /**
     * <p>
     * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all
     * your Reserved Instances modification requests is returned. If a modification ID is specified, only information
     * about the specific modification is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in
     * the Amazon Elastic Compute Cloud User Guide.
     * </p>
     *
     * @param describeReservedInstancesModificationsRequest
     *        Contains the parameters for DescribeReservedInstancesModifications.
     * @return A Java Future containing the result of the DescribeReservedInstancesModifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeReservedInstancesModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedInstancesModificationsResponse> describeReservedInstancesModifications(
            DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest) {

        StaxResponseHandler<DescribeReservedInstancesModificationsResponse> responseHandler = new StaxResponseHandler<DescribeReservedInstancesModificationsResponse>(
                new DescribeReservedInstancesModificationsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeReservedInstancesModificationsRequest, DescribeReservedInstancesModificationsResponse>()
                        .withMarshaller(new DescribeReservedInstancesModificationsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeReservedInstancesModificationsRequest));
    }

    /**
     * <p>
     * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the
     * right to launch instances for a period of time. During that time period, you do not receive insufficient capacity
     * errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.
     * </p>
     * <p>
     * If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be
     * excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeReservedInstancesOfferingsRequest
     *        Contains the parameters for DescribeReservedInstancesOfferings.
     * @return A Java Future containing the result of the DescribeReservedInstancesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeReservedInstancesOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedInstancesOfferingsResponse> describeReservedInstancesOfferings(
            DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {

        StaxResponseHandler<DescribeReservedInstancesOfferingsResponse> responseHandler = new StaxResponseHandler<DescribeReservedInstancesOfferingsResponse>(
                new DescribeReservedInstancesOfferingsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeReservedInstancesOfferingsRequest, DescribeReservedInstancesOfferingsResponse>()
                        .withMarshaller(new DescribeReservedInstancesOfferingsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeReservedInstancesOfferingsRequest));
    }

    /**
     * <p>
     * Describes one or more of your route tables.
     * </p>
     * <p>
     * Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any
     * route table, it is implicitly associated with the main route table. This command does not return the subnet ID
     * for implicit associations.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeRouteTablesRequest
     *        Contains the parameters for DescribeRouteTables.
     * @return A Java Future containing the result of the DescribeRouteTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRouteTablesResponse> describeRouteTables(
            DescribeRouteTablesRequest describeRouteTablesRequest) {

        StaxResponseHandler<DescribeRouteTablesResponse> responseHandler = new StaxResponseHandler<DescribeRouteTablesResponse>(
                new DescribeRouteTablesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeRouteTablesRequest, DescribeRouteTablesResponse>()
                .withMarshaller(new DescribeRouteTablesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeRouteTablesRequest));
    }

    /**
     * <p>
     * Finds available schedules that meet the specified criteria.
     * </p>
     * <p>
     * You can search for an available schedule no more than 3 months in advance. You must meet the minimum required
     * duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule
     * is 24 hours, and the minimum monthly schedule is 100 hours.
     * </p>
     * <p>
     * After you find a schedule that meets your needs, call <a>PurchaseScheduledInstances</a> to purchase Scheduled
     * Instances with that schedule.
     * </p>
     *
     * @param describeScheduledInstanceAvailabilityRequest
     *        Contains the parameters for DescribeScheduledInstanceAvailability.
     * @return A Java Future containing the result of the DescribeScheduledInstanceAvailability operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeScheduledInstanceAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScheduledInstanceAvailabilityResponse> describeScheduledInstanceAvailability(
            DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest) {

        StaxResponseHandler<DescribeScheduledInstanceAvailabilityResponse> responseHandler = new StaxResponseHandler<DescribeScheduledInstanceAvailabilityResponse>(
                new DescribeScheduledInstanceAvailabilityResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeScheduledInstanceAvailabilityRequest, DescribeScheduledInstanceAvailabilityResponse>()
                        .withMarshaller(new DescribeScheduledInstanceAvailabilityRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeScheduledInstanceAvailabilityRequest));
    }

    /**
     * <p>
     * Describes one or more of your Scheduled Instances.
     * </p>
     *
     * @param describeScheduledInstancesRequest
     *        Contains the parameters for DescribeScheduledInstances.
     * @return A Java Future containing the result of the DescribeScheduledInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeScheduledInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScheduledInstancesResponse> describeScheduledInstances(
            DescribeScheduledInstancesRequest describeScheduledInstancesRequest) {

        StaxResponseHandler<DescribeScheduledInstancesResponse> responseHandler = new StaxResponseHandler<DescribeScheduledInstancesResponse>(
                new DescribeScheduledInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeScheduledInstancesRequest, DescribeScheduledInstancesResponse>()
                        .withMarshaller(new DescribeScheduledInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeScheduledInstancesRequest));
    }

    /**
     * <p>
     * [EC2-VPC only] Describes the VPCs on the other side of a VPC peering connection that are referencing the security
     * groups you've specified in this request.
     * </p>
     *
     * @param describeSecurityGroupReferencesRequest
     * @return A Java Future containing the result of the DescribeSecurityGroupReferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSecurityGroupReferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSecurityGroupReferencesResponse> describeSecurityGroupReferences(
            DescribeSecurityGroupReferencesRequest describeSecurityGroupReferencesRequest) {

        StaxResponseHandler<DescribeSecurityGroupReferencesResponse> responseHandler = new StaxResponseHandler<DescribeSecurityGroupReferencesResponse>(
                new DescribeSecurityGroupReferencesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeSecurityGroupReferencesRequest, DescribeSecurityGroupReferencesResponse>()
                        .withMarshaller(new DescribeSecurityGroupReferencesRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeSecurityGroupReferencesRequest));
    }

    /**
     * <p>
     * Describes one or more of your security groups.
     * </p>
     * <p>
     * A security group is for use with instances either in the EC2-Classic platform or in a specific VPC. For more
     * information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeSecurityGroupsRequest
     *        Contains the parameters for DescribeSecurityGroups.
     * @return A Java Future containing the result of the DescribeSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSecurityGroupsResponse> describeSecurityGroups(
            DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {

        StaxResponseHandler<DescribeSecurityGroupsResponse> responseHandler = new StaxResponseHandler<DescribeSecurityGroupsResponse>(
                new DescribeSecurityGroupsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeSecurityGroupsRequest, DescribeSecurityGroupsResponse>()
                .withMarshaller(new DescribeSecurityGroupsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeSecurityGroupsRequest));
    }

    /**
     * <p>
     * Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time.
     * </p>
     * <p>
     * For more information about EBS snapshots, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS Snapshots</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeSnapshotAttributeRequest
     *        Contains the parameters for DescribeSnapshotAttribute.
     * @return A Java Future containing the result of the DescribeSnapshotAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotAttributeResponse> describeSnapshotAttribute(
            DescribeSnapshotAttributeRequest describeSnapshotAttributeRequest) {

        StaxResponseHandler<DescribeSnapshotAttributeResponse> responseHandler = new StaxResponseHandler<DescribeSnapshotAttributeResponse>(
                new DescribeSnapshotAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeSnapshotAttributeRequest, DescribeSnapshotAttributeResponse>()
                        .withMarshaller(new DescribeSnapshotAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeSnapshotAttributeRequest));
    }

    /**
     * <p>
     * Describes one or more of the EBS snapshots available to you. Available snapshots include public snapshots
     * available for any AWS account to launch, private snapshots that you own, and private snapshots owned by another
     * AWS account but for which you've been given explicit create volume permissions.
     * </p>
     * <p>
     * The create volume permissions fall into the following categories:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>public</i>: The owner of the snapshot granted create volume permissions for the snapshot to the
     * <code>all</code> group. All AWS accounts have create volume permissions for these snapshots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>explicit</i>: The owner of the snapshot granted create volume permissions to a specific AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>implicit</i>: An AWS account has implicit create volume permissions for all snapshots it owns.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The list of snapshots returned can be modified by specifying snapshot IDs, snapshot owners, or AWS accounts with
     * create volume permissions. If no options are specified, Amazon EC2 returns all snapshots for which you have
     * create volume permissions.
     * </p>
     * <p>
     * If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify
     * an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it
     * is not included in the returned results.
     * </p>
     * <p>
     * If you specify one or more snapshot owners using the <code>OwnerIds</code> option, only snapshots from the
     * specified owners and for which you have access are returned. The results can include the AWS account IDs of the
     * specified owners, <code>amazon</code> for snapshots owned by Amazon, or <code>self</code> for snapshots that you
     * own.
     * </p>
     * <p>
     * If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are
     * returned. You can specify AWS account IDs (if you own the snapshots), <code>self</code> for snapshots for which
     * you own or have explicit permissions, or <code>all</code> for public snapshots.
     * </p>
     * <p>
     * If you are describing a long list of snapshots, you can paginate the output to make the list more manageable. The
     * <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. If the list of
     * results exceeds your <code>MaxResults</code> value, then that number of results is returned along with a
     * <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSnapshots</code> request to
     * retrieve the remaining results.
     * </p>
     * <p>
     * For more information about EBS snapshots, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS Snapshots</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeSnapshotsRequest
     *        Contains the parameters for DescribeSnapshots.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {

        StaxResponseHandler<DescribeSnapshotsResponse> responseHandler = new StaxResponseHandler<DescribeSnapshotsResponse>(
                new DescribeSnapshotsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeSnapshotsRequest, DescribeSnapshotsResponse>()
                .withMarshaller(new DescribeSnapshotsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeSnapshotsRequest));
    }

    /**
     * <p>
     * Describes the data feed for Spot instances. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance Data Feed</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DescribeSpotDatafeedSubscription.
     * @return A Java Future containing the result of the DescribeSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotDatafeedSubscriptionResponse> describeSpotDatafeedSubscription(
            DescribeSpotDatafeedSubscriptionRequest describeSpotDatafeedSubscriptionRequest) {

        StaxResponseHandler<DescribeSpotDatafeedSubscriptionResponse> responseHandler = new StaxResponseHandler<DescribeSpotDatafeedSubscriptionResponse>(
                new DescribeSpotDatafeedSubscriptionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeSpotDatafeedSubscriptionRequest, DescribeSpotDatafeedSubscriptionResponse>()
                        .withMarshaller(new DescribeSpotDatafeedSubscriptionRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeSpotDatafeedSubscriptionRequest));
    }

    /**
     * <p>
     * Describes the running instances for the specified Spot fleet.
     * </p>
     *
     * @param describeSpotFleetInstancesRequest
     *        Contains the parameters for DescribeSpotFleetInstances.
     * @return A Java Future containing the result of the DescribeSpotFleetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSpotFleetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotFleetInstancesResponse> describeSpotFleetInstances(
            DescribeSpotFleetInstancesRequest describeSpotFleetInstancesRequest) {

        StaxResponseHandler<DescribeSpotFleetInstancesResponse> responseHandler = new StaxResponseHandler<DescribeSpotFleetInstancesResponse>(
                new DescribeSpotFleetInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeSpotFleetInstancesRequest, DescribeSpotFleetInstancesResponse>()
                        .withMarshaller(new DescribeSpotFleetInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeSpotFleetInstancesRequest));
    }

    /**
     * <p>
     * Describes the events for the specified Spot fleet request during the specified time.
     * </p>
     * <p>
     * Spot fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query
     * by the last evaluated time and not miss a recorded event.
     * </p>
     *
     * @param describeSpotFleetRequestHistoryRequest
     *        Contains the parameters for DescribeSpotFleetRequestHistory.
     * @return A Java Future containing the result of the DescribeSpotFleetRequestHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSpotFleetRequestHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotFleetRequestHistoryResponse> describeSpotFleetRequestHistory(
            DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest) {

        StaxResponseHandler<DescribeSpotFleetRequestHistoryResponse> responseHandler = new StaxResponseHandler<DescribeSpotFleetRequestHistoryResponse>(
                new DescribeSpotFleetRequestHistoryResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeSpotFleetRequestHistoryRequest, DescribeSpotFleetRequestHistoryResponse>()
                        .withMarshaller(new DescribeSpotFleetRequestHistoryRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeSpotFleetRequestHistoryRequest));
    }

    /**
     * <p>
     * Describes your Spot fleet requests.
     * </p>
     * <p>
     * Spot fleet requests are deleted 48 hours after they are canceled and their instances are terminated.
     * </p>
     *
     * @param describeSpotFleetRequestsRequest
     *        Contains the parameters for DescribeSpotFleetRequests.
     * @return A Java Future containing the result of the DescribeSpotFleetRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSpotFleetRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotFleetRequestsResponse> describeSpotFleetRequests(
            DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest) {

        StaxResponseHandler<DescribeSpotFleetRequestsResponse> responseHandler = new StaxResponseHandler<DescribeSpotFleetRequestsResponse>(
                new DescribeSpotFleetRequestsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeSpotFleetRequestsRequest, DescribeSpotFleetRequestsResponse>()
                        .withMarshaller(new DescribeSpotFleetRequestsRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeSpotFleetRequestsRequest));
    }

    /**
     * <p>
     * Describes the Spot instance requests that belong to your account. Spot instances are instances that Amazon EC2
     * launches when the bid price that you specify exceeds the current Spot price. Amazon EC2 periodically sets the
     * Spot price based on available Spot instance capacity and current Spot instance requests. For more information,
     * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance Requests</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can use <code>DescribeSpotInstanceRequests</code> to find a running Spot instance by examining the response.
     * If the status of the Spot instance is <code>fulfilled</code>, the instance ID appears in the response and
     * contains the identifier of the instance. Alternatively, you can use <a>DescribeInstances</a> with a filter to
     * look for instances where the instance lifecycle is <code>spot</code>.
     * </p>
     * <p>
     * Spot instance requests are deleted 4 hours after they are canceled and their instances are terminated.
     * </p>
     *
     * @param describeSpotInstanceRequestsRequest
     *        Contains the parameters for DescribeSpotInstanceRequests.
     * @return A Java Future containing the result of the DescribeSpotInstanceRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSpotInstanceRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotInstanceRequestsResponse> describeSpotInstanceRequests(
            DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) {

        StaxResponseHandler<DescribeSpotInstanceRequestsResponse> responseHandler = new StaxResponseHandler<DescribeSpotInstanceRequestsResponse>(
                new DescribeSpotInstanceRequestsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeSpotInstanceRequestsRequest, DescribeSpotInstanceRequestsResponse>()
                        .withMarshaller(new DescribeSpotInstanceRequestsRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeSpotInstanceRequestsRequest));
    }

    /**
     * <p>
     * Describes the Spot price history. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html">Spot Instance Pricing
     * History</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * When you specify a start and end time, this operation returns the prices of the instance types within the time
     * range that you specified and the time when the price changed. The price is valid within the time period that you
     * specified; the response merely indicates the last time that the price changed.
     * </p>
     *
     * @param describeSpotPriceHistoryRequest
     *        Contains the parameters for DescribeSpotPriceHistory.
     * @return A Java Future containing the result of the DescribeSpotPriceHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSpotPriceHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotPriceHistory" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotPriceHistoryResponse> describeSpotPriceHistory(
            DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest) {

        StaxResponseHandler<DescribeSpotPriceHistoryResponse> responseHandler = new StaxResponseHandler<DescribeSpotPriceHistoryResponse>(
                new DescribeSpotPriceHistoryResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeSpotPriceHistoryRequest, DescribeSpotPriceHistoryResponse>()
                        .withMarshaller(new DescribeSpotPriceHistoryRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeSpotPriceHistoryRequest));
    }

    /**
     * <p>
     * [EC2-VPC only] Describes the stale security group rules for security groups in a specified VPC. Rules are stale
     * when they reference a deleted security group in a peer VPC, or a security group in a peer VPC for which the VPC
     * peering connection has been deleted.
     * </p>
     *
     * @param describeStaleSecurityGroupsRequest
     * @return A Java Future containing the result of the DescribeStaleSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeStaleSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStaleSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStaleSecurityGroupsResponse> describeStaleSecurityGroups(
            DescribeStaleSecurityGroupsRequest describeStaleSecurityGroupsRequest) {

        StaxResponseHandler<DescribeStaleSecurityGroupsResponse> responseHandler = new StaxResponseHandler<DescribeStaleSecurityGroupsResponse>(
                new DescribeStaleSecurityGroupsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeStaleSecurityGroupsRequest, DescribeStaleSecurityGroupsResponse>()
                        .withMarshaller(new DescribeStaleSecurityGroupsRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeStaleSecurityGroupsRequest));
    }

    /**
     * <p>
     * Describes one or more of your subnets.
     * </p>
     * <p>
     * For more information about subnets, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">Your VPC and Subnets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeSubnetsRequest
     *        Contains the parameters for DescribeSubnets.
     * @return A Java Future containing the result of the DescribeSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeSubnets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSubnets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSubnetsResponse> describeSubnets(DescribeSubnetsRequest describeSubnetsRequest) {

        StaxResponseHandler<DescribeSubnetsResponse> responseHandler = new StaxResponseHandler<DescribeSubnetsResponse>(
                new DescribeSubnetsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeSubnetsRequest, DescribeSubnetsResponse>()
                .withMarshaller(new DescribeSubnetsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeSubnetsRequest));
    }

    /**
     * <p>
     * Describes one or more of the tags for your EC2 resources.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeTagsRequest
     *        Contains the parameters for DescribeTags.
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {

        StaxResponseHandler<DescribeTagsResponse> responseHandler = new StaxResponseHandler<DescribeTagsResponse>(
                new DescribeTagsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                .withMarshaller(new DescribeTagsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeTagsRequest));
    }

    /**
     * <p>
     * Describes the specified attribute of the specified volume. You can specify only one attribute at a time.
     * </p>
     * <p>
     * For more information about EBS volumes, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS Volumes</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeVolumeAttributeRequest
     *        Contains the parameters for DescribeVolumeAttribute.
     * @return A Java Future containing the result of the DescribeVolumeAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVolumeAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVolumeAttributeResponse> describeVolumeAttribute(
            DescribeVolumeAttributeRequest describeVolumeAttributeRequest) {

        StaxResponseHandler<DescribeVolumeAttributeResponse> responseHandler = new StaxResponseHandler<DescribeVolumeAttributeResponse>(
                new DescribeVolumeAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeVolumeAttributeRequest, DescribeVolumeAttributeResponse>()
                .withMarshaller(new DescribeVolumeAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeVolumeAttributeRequest));
    }

    /**
     * <p>
     * Describes the status of the specified volumes. Volume status provides the result of the checks performed on your
     * volumes to determine events that can impair the performance of your volumes. The performance of a volume can be
     * affected if an issue occurs on the volume's underlying host. If the volume's underlying host experiences a power
     * outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume
     * events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the
     * event.
     * </p>
     * <p>
     * The <code>DescribeVolumeStatus</code> operation provides the following information about the specified volumes:
     * </p>
     * <p>
     * <i>Status</i>: Reflects the current status of the volume. The possible values are <code>ok</code>,
     * <code>impaired</code> , <code>warning</code>, or <code>insufficient-data</code>. If all checks pass, the overall
     * status of the volume is <code>ok</code>. If the check fails, the overall status is <code>impaired</code>. If the
     * status is <code>insufficient-data</code>, then the checks may still be taking place on your volume at the time.
     * We recommend that you retry the request. For more information on volume status, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html">Monitoring the Status of
     * Your Volumes</a>.
     * </p>
     * <p>
     * <i>Events</i>: Reflect the cause of a volume status and may require you to take action. For example, if your
     * volume returns an <code>impaired</code> status, then the volume event might be
     * <code>potential-data-inconsistency</code>. This means that your volume has been affected by an issue with the
     * underlying host, has all I/O operations disabled, and may have inconsistent data.
     * </p>
     * <p>
     * <i>Actions</i>: Reflect the actions you may have to take in response to an event. For example, if the status of
     * the volume is <code>impaired</code> and the volume event shows <code>potential-data-inconsistency</code>, then
     * the action shows <code>enable-volume-io</code>. This means that you may want to enable the I/O operations for the
     * volume by calling the <a>EnableVolumeIO</a> action and then check the volume for data consistency.
     * </p>
     * <note>
     * <p>
     * Volume status is based on the volume status checks, and does not reflect the volume state. Therefore, volume
     * status does not indicate volumes in the <code>error</code> state (for example, when a volume is incapable of
     * accepting I/O.)
     * </p>
     * </note>
     *
     * @param describeVolumeStatusRequest
     *        Contains the parameters for DescribeVolumeStatus.
     * @return A Java Future containing the result of the DescribeVolumeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVolumeStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVolumeStatusResponse> describeVolumeStatus(
            DescribeVolumeStatusRequest describeVolumeStatusRequest) {

        StaxResponseHandler<DescribeVolumeStatusResponse> responseHandler = new StaxResponseHandler<DescribeVolumeStatusResponse>(
                new DescribeVolumeStatusResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeVolumeStatusRequest, DescribeVolumeStatusResponse>()
                .withMarshaller(new DescribeVolumeStatusRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeVolumeStatusRequest));
    }

    /**
     * <p>
     * Describes the specified EBS volumes.
     * </p>
     * <p>
     * If you are describing a long list of volumes, you can paginate the output to make the list more manageable. The
     * <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. If the list of
     * results exceeds your <code>MaxResults</code> value, then that number of results is returned along with a
     * <code>NextToken</code> value that can be passed to a subsequent <code>DescribeVolumes</code> request to retrieve
     * the remaining results.
     * </p>
     * <p>
     * For more information about EBS volumes, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS Volumes</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeVolumesRequest
     *        Contains the parameters for DescribeVolumes.
     * @return A Java Future containing the result of the DescribeVolumes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVolumes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVolumesResponse> describeVolumes(DescribeVolumesRequest describeVolumesRequest) {

        StaxResponseHandler<DescribeVolumesResponse> responseHandler = new StaxResponseHandler<DescribeVolumesResponse>(
                new DescribeVolumesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeVolumesRequest, DescribeVolumesResponse>()
                .withMarshaller(new DescribeVolumesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeVolumesRequest));
    }

    /**
     * <p>
     * Reports the current modification status of EBS volumes.
     * </p>
     * <p>
     * Current-generation EBS volumes support modification of attributes including type, size, and (for <code>io1</code>
     * volumes) IOPS provisioning while either attached to or detached from an instance. Following an action from the
     * API or the console to modify a volume, the status of the modification may be <code>modifying</code>,
     * <code>optimizing</code>, <code>completed</code>, or <code>failed</code>. If a volume has never been modified,
     * then certain elements of the returned <code>VolumeModification</code> objects are null.
     * </p>
     * <p>
     * You can also use CloudWatch Events to check the status of a modification to an EBS volume. For information about
     * CloudWatch Events, see the <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch
     * Events User Guide</a>. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#monitoring_mods">Monitoring
     * Volume Modifications"</a>.
     * </p>
     *
     * @param describeVolumesModificationsRequest
     * @return A Java Future containing the result of the DescribeVolumesModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVolumesModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumesModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVolumesModificationsResponse> describeVolumesModifications(
            DescribeVolumesModificationsRequest describeVolumesModificationsRequest) {

        StaxResponseHandler<DescribeVolumesModificationsResponse> responseHandler = new StaxResponseHandler<DescribeVolumesModificationsResponse>(
                new DescribeVolumesModificationsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeVolumesModificationsRequest, DescribeVolumesModificationsResponse>()
                        .withMarshaller(new DescribeVolumesModificationsRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeVolumesModificationsRequest));
    }

    /**
     * <p>
     * Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.
     * </p>
     *
     * @param describeVpcAttributeRequest
     *        Contains the parameters for DescribeVpcAttribute.
     * @return A Java Future containing the result of the DescribeVpcAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVpcAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcAttributeResponse> describeVpcAttribute(
            DescribeVpcAttributeRequest describeVpcAttributeRequest) {

        StaxResponseHandler<DescribeVpcAttributeResponse> responseHandler = new StaxResponseHandler<DescribeVpcAttributeResponse>(
                new DescribeVpcAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeVpcAttributeRequest, DescribeVpcAttributeResponse>()
                .withMarshaller(new DescribeVpcAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeVpcAttributeRequest));
    }

    /**
     * <p>
     * Describes the ClassicLink status of one or more VPCs.
     * </p>
     *
     * @param describeVpcClassicLinkRequest
     *        Contains the parameters for DescribeVpcClassicLink.
     * @return A Java Future containing the result of the DescribeVpcClassicLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVpcClassicLink
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLink" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcClassicLinkResponse> describeVpcClassicLink(
            DescribeVpcClassicLinkRequest describeVpcClassicLinkRequest) {

        StaxResponseHandler<DescribeVpcClassicLinkResponse> responseHandler = new StaxResponseHandler<DescribeVpcClassicLinkResponse>(
                new DescribeVpcClassicLinkResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeVpcClassicLinkRequest, DescribeVpcClassicLinkResponse>()
                .withMarshaller(new DescribeVpcClassicLinkRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeVpcClassicLinkRequest));
    }

    /**
     * <p>
     * Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS hostname of a linked
     * EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's
     * linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed
     * from a linked EC2-Classic instance. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeVpcClassicLinkDnsSupportRequest
     *        Contains the parameters for DescribeVpcClassicLinkDnsSupport.
     * @return A Java Future containing the result of the DescribeVpcClassicLinkDnsSupport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVpcClassicLinkDnsSupport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcClassicLinkDnsSupportResponse> describeVpcClassicLinkDnsSupport(
            DescribeVpcClassicLinkDnsSupportRequest describeVpcClassicLinkDnsSupportRequest) {

        StaxResponseHandler<DescribeVpcClassicLinkDnsSupportResponse> responseHandler = new StaxResponseHandler<DescribeVpcClassicLinkDnsSupportResponse>(
                new DescribeVpcClassicLinkDnsSupportResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeVpcClassicLinkDnsSupportRequest, DescribeVpcClassicLinkDnsSupportResponse>()
                        .withMarshaller(new DescribeVpcClassicLinkDnsSupportRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeVpcClassicLinkDnsSupportRequest));
    }

    /**
     * <p>
     * Describes all supported AWS services that can be specified when creating a VPC endpoint.
     * </p>
     *
     * @param describeVpcEndpointServicesRequest
     *        Contains the parameters for DescribeVpcEndpointServices.
     * @return A Java Future containing the result of the DescribeVpcEndpointServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVpcEndpointServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcEndpointServicesResponse> describeVpcEndpointServices(
            DescribeVpcEndpointServicesRequest describeVpcEndpointServicesRequest) {

        StaxResponseHandler<DescribeVpcEndpointServicesResponse> responseHandler = new StaxResponseHandler<DescribeVpcEndpointServicesResponse>(
                new DescribeVpcEndpointServicesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeVpcEndpointServicesRequest, DescribeVpcEndpointServicesResponse>()
                        .withMarshaller(new DescribeVpcEndpointServicesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeVpcEndpointServicesRequest));
    }

    /**
     * <p>
     * Describes one or more of your VPC endpoints.
     * </p>
     *
     * @param describeVpcEndpointsRequest
     *        Contains the parameters for DescribeVpcEndpoints.
     * @return A Java Future containing the result of the DescribeVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVpcEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcEndpointsResponse> describeVpcEndpoints(
            DescribeVpcEndpointsRequest describeVpcEndpointsRequest) {

        StaxResponseHandler<DescribeVpcEndpointsResponse> responseHandler = new StaxResponseHandler<DescribeVpcEndpointsResponse>(
                new DescribeVpcEndpointsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeVpcEndpointsRequest, DescribeVpcEndpointsResponse>()
                .withMarshaller(new DescribeVpcEndpointsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeVpcEndpointsRequest));
    }

    /**
     * <p>
     * Describes one or more of your VPC peering connections.
     * </p>
     *
     * @param describeVpcPeeringConnectionsRequest
     *        Contains the parameters for DescribeVpcPeeringConnections.
     * @return A Java Future containing the result of the DescribeVpcPeeringConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVpcPeeringConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcPeeringConnectionsResponse> describeVpcPeeringConnections(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {

        StaxResponseHandler<DescribeVpcPeeringConnectionsResponse> responseHandler = new StaxResponseHandler<DescribeVpcPeeringConnectionsResponse>(
                new DescribeVpcPeeringConnectionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DescribeVpcPeeringConnectionsRequest, DescribeVpcPeeringConnectionsResponse>()
                        .withMarshaller(new DescribeVpcPeeringConnectionsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeVpcPeeringConnectionsRequest));
    }

    /**
     * <p>
     * Describes one or more of your VPCs.
     * </p>
     *
     * @param describeVpcsRequest
     *        Contains the parameters for DescribeVpcs.
     * @return A Java Future containing the result of the DescribeVpcs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVpcs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpcsResponse> describeVpcs(DescribeVpcsRequest describeVpcsRequest) {

        StaxResponseHandler<DescribeVpcsResponse> responseHandler = new StaxResponseHandler<DescribeVpcsResponse>(
                new DescribeVpcsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeVpcsRequest, DescribeVpcsResponse>()
                .withMarshaller(new DescribeVpcsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeVpcsRequest));
    }

    /**
     * <p>
     * Describes one or more of your VPN connections.
     * </p>
     * <p>
     * For more information about VPN connections, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">AWS Managed VPN Connections</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeVpnConnectionsRequest
     *        Contains the parameters for DescribeVpnConnections.
     * @return A Java Future containing the result of the DescribeVpnConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVpnConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnConnections" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpnConnectionsResponse> describeVpnConnections(
            DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {

        StaxResponseHandler<DescribeVpnConnectionsResponse> responseHandler = new StaxResponseHandler<DescribeVpnConnectionsResponse>(
                new DescribeVpnConnectionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeVpnConnectionsRequest, DescribeVpnConnectionsResponse>()
                .withMarshaller(new DescribeVpnConnectionsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeVpnConnectionsRequest));
    }

    /**
     * <p>
     * Describes one or more of your virtual private gateways.
     * </p>
     * <p>
     * For more information about virtual private gateways, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">AWS Managed VPN Connections</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeVpnGatewaysRequest
     *        Contains the parameters for DescribeVpnGateways.
     * @return A Java Future containing the result of the DescribeVpnGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DescribeVpnGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnGateways" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVpnGatewaysResponse> describeVpnGateways(
            DescribeVpnGatewaysRequest describeVpnGatewaysRequest) {

        StaxResponseHandler<DescribeVpnGatewaysResponse> responseHandler = new StaxResponseHandler<DescribeVpnGatewaysResponse>(
                new DescribeVpnGatewaysResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DescribeVpnGatewaysRequest, DescribeVpnGatewaysResponse>()
                .withMarshaller(new DescribeVpnGatewaysRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeVpnGatewaysRequest));
    }

    /**
     * <p>
     * Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC
     * security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it's
     * stopped.
     * </p>
     *
     * @param detachClassicLinkVpcRequest
     *        Contains the parameters for DetachClassicLinkVpc.
     * @return A Java Future containing the result of the DetachClassicLinkVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DetachClassicLinkVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachClassicLinkVpcResponse> detachClassicLinkVpc(
            DetachClassicLinkVpcRequest detachClassicLinkVpcRequest) {

        StaxResponseHandler<DetachClassicLinkVpcResponse> responseHandler = new StaxResponseHandler<DetachClassicLinkVpcResponse>(
                new DetachClassicLinkVpcResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DetachClassicLinkVpcRequest, DetachClassicLinkVpcResponse>()
                .withMarshaller(new DetachClassicLinkVpcRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(detachClassicLinkVpcRequest));
    }

    /**
     * <p>
     * Detaches an Internet gateway from a VPC, disabling connectivity between the Internet and the VPC. The VPC must
     * not contain any running instances with Elastic IP addresses or public IPv4 addresses.
     * </p>
     *
     * @param detachInternetGatewayRequest
     *        Contains the parameters for DetachInternetGateway.
     * @return A Java Future containing the result of the DetachInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DetachInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachInternetGatewayResponse> detachInternetGateway(
            DetachInternetGatewayRequest detachInternetGatewayRequest) {

        StaxResponseHandler<DetachInternetGatewayResponse> responseHandler = new StaxResponseHandler<DetachInternetGatewayResponse>(
                new DetachInternetGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DetachInternetGatewayRequest, DetachInternetGatewayResponse>()
                .withMarshaller(new DetachInternetGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(detachInternetGatewayRequest));
    }

    /**
     * <p>
     * Detaches a network interface from an instance.
     * </p>
     *
     * @param detachNetworkInterfaceRequest
     *        Contains the parameters for DetachNetworkInterface.
     * @return A Java Future containing the result of the DetachNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DetachNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachNetworkInterfaceResponse> detachNetworkInterface(
            DetachNetworkInterfaceRequest detachNetworkInterfaceRequest) {

        StaxResponseHandler<DetachNetworkInterfaceResponse> responseHandler = new StaxResponseHandler<DetachNetworkInterfaceResponse>(
                new DetachNetworkInterfaceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DetachNetworkInterfaceRequest, DetachNetworkInterfaceResponse>()
                .withMarshaller(new DetachNetworkInterfaceRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(detachNetworkInterfaceRequest));
    }

    /**
     * <p>
     * Detaches an EBS volume from an instance. Make sure to unmount any file systems on the device within your
     * operating system before detaching the volume. Failure to do so can result in the volume becoming stuck in the
     * <code>busy</code> state while detaching. If this happens, detachment can be delayed indefinitely until you
     * unmount the volume, force detachment, reboot the instance, or all three. If an EBS volume is the root device of
     * an instance, it can't be detached while the instance is running. To detach the root volume, stop the instance
     * first.
     * </p>
     * <p>
     * When a volume with an AWS Marketplace product code is detached from an instance, the product code is no longer
     * associated with the instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html">Detaching an Amazon EBS
     * Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param detachVolumeRequest
     *        Contains the parameters for DetachVolume.
     * @return A Java Future containing the result of the DetachVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DetachVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachVolumeResponse> detachVolume(DetachVolumeRequest detachVolumeRequest) {

        StaxResponseHandler<DetachVolumeResponse> responseHandler = new StaxResponseHandler<DetachVolumeResponse>(
                new DetachVolumeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DetachVolumeRequest, DetachVolumeResponse>()
                .withMarshaller(new DetachVolumeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(detachVolumeRequest));
    }

    /**
     * <p>
     * Detaches a virtual private gateway from a VPC. You do this if you're planning to turn off the VPC and not use it
     * anymore. You can confirm a virtual private gateway has been completely detached from a VPC by describing the
     * virtual private gateway (any attachments to the virtual private gateway are also described).
     * </p>
     * <p>
     * You must wait for the attachment's state to switch to <code>detached</code> before you can delete the VPC or
     * attach a different VPC to the virtual private gateway.
     * </p>
     *
     * @param detachVpnGatewayRequest
     *        Contains the parameters for DetachVpnGateway.
     * @return A Java Future containing the result of the DetachVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DetachVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachVpnGatewayResponse> detachVpnGateway(DetachVpnGatewayRequest detachVpnGatewayRequest) {

        StaxResponseHandler<DetachVpnGatewayResponse> responseHandler = new StaxResponseHandler<DetachVpnGatewayResponse>(
                new DetachVpnGatewayResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DetachVpnGatewayRequest, DetachVpnGatewayResponse>()
                .withMarshaller(new DetachVpnGatewayRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(detachVpnGatewayRequest));
    }

    /**
     * <p>
     * Disables a virtual private gateway (VGW) from propagating routes to a specified route table of a VPC.
     * </p>
     *
     * @param disableVgwRoutePropagationRequest
     *        Contains the parameters for DisableVgwRoutePropagation.
     * @return A Java Future containing the result of the DisableVgwRoutePropagation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DisableVgwRoutePropagation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVgwRoutePropagation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableVgwRoutePropagationResponse> disableVgwRoutePropagation(
            DisableVgwRoutePropagationRequest disableVgwRoutePropagationRequest) {

        StaxResponseHandler<DisableVgwRoutePropagationResponse> responseHandler = new StaxResponseHandler<DisableVgwRoutePropagationResponse>(
                new DisableVgwRoutePropagationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DisableVgwRoutePropagationRequest, DisableVgwRoutePropagationResponse>()
                        .withMarshaller(new DisableVgwRoutePropagationRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disableVgwRoutePropagationRequest));
    }

    /**
     * <p>
     * Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to
     * it.
     * </p>
     *
     * @param disableVpcClassicLinkRequest
     *        Contains the parameters for DisableVpcClassicLink.
     * @return A Java Future containing the result of the DisableVpcClassicLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DisableVpcClassicLink
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLink" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableVpcClassicLinkResponse> disableVpcClassicLink(
            DisableVpcClassicLinkRequest disableVpcClassicLinkRequest) {

        StaxResponseHandler<DisableVpcClassicLinkResponse> responseHandler = new StaxResponseHandler<DisableVpcClassicLinkResponse>(
                new DisableVpcClassicLinkResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DisableVpcClassicLinkRequest, DisableVpcClassicLinkResponse>()
                .withMarshaller(new DisableVpcClassicLinkRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(disableVpcClassicLinkRequest));
    }

    /**
     * <p>
     * Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to public IP addresses when
     * addressed between a linked EC2-Classic instance and instances in the VPC to which it's linked. For more
     * information about ClassicLink, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param disableVpcClassicLinkDnsSupportRequest
     *        Contains the parameters for DisableVpcClassicLinkDnsSupport.
     * @return A Java Future containing the result of the DisableVpcClassicLinkDnsSupport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DisableVpcClassicLinkDnsSupport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLinkDnsSupport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableVpcClassicLinkDnsSupportResponse> disableVpcClassicLinkDnsSupport(
            DisableVpcClassicLinkDnsSupportRequest disableVpcClassicLinkDnsSupportRequest) {

        StaxResponseHandler<DisableVpcClassicLinkDnsSupportResponse> responseHandler = new StaxResponseHandler<DisableVpcClassicLinkDnsSupportResponse>(
                new DisableVpcClassicLinkDnsSupportResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DisableVpcClassicLinkDnsSupportRequest, DisableVpcClassicLinkDnsSupportResponse>()
                        .withMarshaller(new DisableVpcClassicLinkDnsSupportRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(disableVpcClassicLinkDnsSupportRequest));
    }

    /**
     * <p>
     * Disassociates an Elastic IP address from the instance or network interface it's associated with.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     *
     * @param disassociateAddressRequest
     *        Contains the parameters for DisassociateAddress.
     * @return A Java Future containing the result of the DisassociateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DisassociateAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateAddressResponse> disassociateAddress(
            DisassociateAddressRequest disassociateAddressRequest) {

        StaxResponseHandler<DisassociateAddressResponse> responseHandler = new StaxResponseHandler<DisassociateAddressResponse>(
                new DisassociateAddressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DisassociateAddressRequest, DisassociateAddressResponse>()
                .withMarshaller(new DisassociateAddressRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(disassociateAddressRequest));
    }

    /**
     * <p>
     * Disassociates an IAM instance profile from a running or stopped instance.
     * </p>
     * <p>
     * Use <a>DescribeIamInstanceProfileAssociations</a> to get the association ID.
     * </p>
     *
     * @param disassociateIamInstanceProfileRequest
     * @return A Java Future containing the result of the DisassociateIamInstanceProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DisassociateIamInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateIamInstanceProfileResponse> disassociateIamInstanceProfile(
            DisassociateIamInstanceProfileRequest disassociateIamInstanceProfileRequest) {

        StaxResponseHandler<DisassociateIamInstanceProfileResponse> responseHandler = new StaxResponseHandler<DisassociateIamInstanceProfileResponse>(
                new DisassociateIamInstanceProfileResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateIamInstanceProfileRequest, DisassociateIamInstanceProfileResponse>()
                        .withMarshaller(new DisassociateIamInstanceProfileRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(disassociateIamInstanceProfileRequest));
    }

    /**
     * <p>
     * Disassociates a subnet from a route table.
     * </p>
     * <p>
     * After you perform this action, the subnet no longer uses the routes in the route table. Instead, it uses the
     * routes in the VPC's main route table. For more information about route tables, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param disassociateRouteTableRequest
     *        Contains the parameters for DisassociateRouteTable.
     * @return A Java Future containing the result of the DisassociateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DisassociateRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateRouteTableResponse> disassociateRouteTable(
            DisassociateRouteTableRequest disassociateRouteTableRequest) {

        StaxResponseHandler<DisassociateRouteTableResponse> responseHandler = new StaxResponseHandler<DisassociateRouteTableResponse>(
                new DisassociateRouteTableResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DisassociateRouteTableRequest, DisassociateRouteTableResponse>()
                .withMarshaller(new DisassociateRouteTableRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(disassociateRouteTableRequest));
    }

    /**
     * <p>
     * Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR block only. You must
     * detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate
     * it.
     * </p>
     *
     * @param disassociateSubnetCidrBlockRequest
     * @return A Java Future containing the result of the DisassociateSubnetCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DisassociateSubnetCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateSubnetCidrBlock"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateSubnetCidrBlockResponse> disassociateSubnetCidrBlock(
            DisassociateSubnetCidrBlockRequest disassociateSubnetCidrBlockRequest) {

        StaxResponseHandler<DisassociateSubnetCidrBlockResponse> responseHandler = new StaxResponseHandler<DisassociateSubnetCidrBlockResponse>(
                new DisassociateSubnetCidrBlockResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateSubnetCidrBlockRequest, DisassociateSubnetCidrBlockResponse>()
                        .withMarshaller(new DisassociateSubnetCidrBlockRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateSubnetCidrBlockRequest));
    }

    /**
     * <p>
     * Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must specify its association ID. You
     * can get the association ID by using <a>DescribeVpcs</a>. You must detach or delete all gateways and resources
     * that are associated with the CIDR block before you can disassociate it.
     * </p>
     * <p>
     * You cannot disassociate the CIDR block with which you originally created the VPC (the primary CIDR block).
     * </p>
     *
     * @param disassociateVpcCidrBlockRequest
     * @return A Java Future containing the result of the DisassociateVpcCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.DisassociateVpcCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateVpcCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateVpcCidrBlockResponse> disassociateVpcCidrBlock(
            DisassociateVpcCidrBlockRequest disassociateVpcCidrBlockRequest) {

        StaxResponseHandler<DisassociateVpcCidrBlockResponse> responseHandler = new StaxResponseHandler<DisassociateVpcCidrBlockResponse>(
                new DisassociateVpcCidrBlockResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateVpcCidrBlockRequest, DisassociateVpcCidrBlockResponse>()
                        .withMarshaller(new DisassociateVpcCidrBlockRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateVpcCidrBlockRequest));
    }

    /**
     * <p>
     * Enables a virtual private gateway (VGW) to propagate routes to the specified route table of a VPC.
     * </p>
     *
     * @param enableVgwRoutePropagationRequest
     *        Contains the parameters for EnableVgwRoutePropagation.
     * @return A Java Future containing the result of the EnableVgwRoutePropagation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.EnableVgwRoutePropagation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVgwRoutePropagation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableVgwRoutePropagationResponse> enableVgwRoutePropagation(
            EnableVgwRoutePropagationRequest enableVgwRoutePropagationRequest) {

        StaxResponseHandler<EnableVgwRoutePropagationResponse> responseHandler = new StaxResponseHandler<EnableVgwRoutePropagationResponse>(
                new EnableVgwRoutePropagationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<EnableVgwRoutePropagationRequest, EnableVgwRoutePropagationResponse>()
                        .withMarshaller(new EnableVgwRoutePropagationRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(enableVgwRoutePropagationRequest));
    }

    /**
     * <p>
     * Enables I/O operations for a volume that had I/O operations disabled because the data on the volume was
     * potentially inconsistent.
     * </p>
     *
     * @param enableVolumeIORequest
     *        Contains the parameters for EnableVolumeIO.
     * @return A Java Future containing the result of the EnableVolumeIO operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.EnableVolumeIO
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVolumeIO" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableVolumeIOResponse> enableVolumeIO(EnableVolumeIORequest enableVolumeIORequest) {

        StaxResponseHandler<EnableVolumeIOResponse> responseHandler = new StaxResponseHandler<EnableVolumeIOResponse>(
                new EnableVolumeIOResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<EnableVolumeIORequest, EnableVolumeIOResponse>()
                .withMarshaller(new EnableVolumeIORequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(enableVolumeIORequest));
    }

    /**
     * <p>
     * Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your ClassicLink-enabled VPC to allow
     * communication over private IP addresses. You cannot enable your VPC for ClassicLink if any of your VPC's route
     * tables have existing routes for address ranges within the <code>10.0.0.0/8</code> IP address range, excluding
     * local routes for VPCs in the <code>10.0.0.0/16</code> and <code>10.1.0.0/16</code> IP address ranges. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param enableVpcClassicLinkRequest
     *        Contains the parameters for EnableVpcClassicLink.
     * @return A Java Future containing the result of the EnableVpcClassicLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.EnableVpcClassicLink
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVpcClassicLink" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableVpcClassicLinkResponse> enableVpcClassicLink(
            EnableVpcClassicLinkRequest enableVpcClassicLinkRequest) {

        StaxResponseHandler<EnableVpcClassicLinkResponse> responseHandler = new StaxResponseHandler<EnableVpcClassicLinkResponse>(
                new EnableVpcClassicLinkResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<EnableVpcClassicLinkRequest, EnableVpcClassicLinkResponse>()
                .withMarshaller(new EnableVpcClassicLinkRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(enableVpcClassicLinkRequest));
    }

    /**
     * <p>
     * Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS hostname of a linked
     * EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's
     * linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed
     * from a linked EC2-Classic instance. For more information about ClassicLink, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param enableVpcClassicLinkDnsSupportRequest
     *        Contains the parameters for EnableVpcClassicLinkDnsSupport.
     * @return A Java Future containing the result of the EnableVpcClassicLinkDnsSupport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.EnableVpcClassicLinkDnsSupport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/EnableVpcClassicLinkDnsSupport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableVpcClassicLinkDnsSupportResponse> enableVpcClassicLinkDnsSupport(
            EnableVpcClassicLinkDnsSupportRequest enableVpcClassicLinkDnsSupportRequest) {

        StaxResponseHandler<EnableVpcClassicLinkDnsSupportResponse> responseHandler = new StaxResponseHandler<EnableVpcClassicLinkDnsSupportResponse>(
                new EnableVpcClassicLinkDnsSupportResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<EnableVpcClassicLinkDnsSupportRequest, EnableVpcClassicLinkDnsSupportResponse>()
                        .withMarshaller(new EnableVpcClassicLinkDnsSupportRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(enableVpcClassicLinkDnsSupportRequest));
    }

    /**
     * <p>
     * Gets the console output for the specified instance.
     * </p>
     * <p>
     * Instances do not have a physical monitor through which you can view their console output. They also lack physical
     * controls that allow you to power up, reboot, or shut them down. To allow these actions, we provide them through
     * the Amazon EC2 API and command line interface.
     * </p>
     * <p>
     * Instance console output is buffered and posted shortly after instance boot, reboot, and termination. Amazon EC2
     * preserves the most recent 64 KB output, which is available for at least one hour after the most recent post.
     * </p>
     * <p>
     * For Linux instances, the instance console output displays the exact console output that would normally be
     * displayed on a physical monitor attached to a computer. This output is buffered because the instance produces it
     * and then posts it to a store where the instance's owner can retrieve it.
     * </p>
     * <p>
     * For Windows instances, the instance console output includes output from the EC2Config service.
     * </p>
     *
     * @param getConsoleOutputRequest
     *        Contains the parameters for GetConsoleOutput.
     * @return A Java Future containing the result of the GetConsoleOutput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.GetConsoleOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetConsoleOutput" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetConsoleOutputResponse> getConsoleOutput(GetConsoleOutputRequest getConsoleOutputRequest) {

        StaxResponseHandler<GetConsoleOutputResponse> responseHandler = new StaxResponseHandler<GetConsoleOutputResponse>(
                new GetConsoleOutputResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetConsoleOutputRequest, GetConsoleOutputResponse>()
                .withMarshaller(new GetConsoleOutputRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getConsoleOutputRequest));
    }

    /**
     * <p>
     * Retrieve a JPG-format screenshot of a running instance to help with troubleshooting.
     * </p>
     * <p>
     * The returned content is Base64-encoded.
     * </p>
     *
     * @param getConsoleScreenshotRequest
     *        Contains the parameters for the request.
     * @return A Java Future containing the result of the GetConsoleScreenshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.GetConsoleScreenshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetConsoleScreenshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetConsoleScreenshotResponse> getConsoleScreenshot(
            GetConsoleScreenshotRequest getConsoleScreenshotRequest) {

        StaxResponseHandler<GetConsoleScreenshotResponse> responseHandler = new StaxResponseHandler<GetConsoleScreenshotResponse>(
                new GetConsoleScreenshotResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetConsoleScreenshotRequest, GetConsoleScreenshotResponse>()
                .withMarshaller(new GetConsoleScreenshotRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getConsoleScreenshotRequest));
    }

    /**
     * <p>
     * Preview a reservation purchase with configurations that match those of your Dedicated Host. You must have active
     * Dedicated Hosts in your account before you purchase a reservation.
     * </p>
     * <p>
     * This is a preview of the <a>PurchaseHostReservation</a> action and does not result in the offering being
     * purchased.
     * </p>
     *
     * @param getHostReservationPurchasePreviewRequest
     * @return A Java Future containing the result of the GetHostReservationPurchasePreview operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.GetHostReservationPurchasePreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetHostReservationPurchasePreview"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetHostReservationPurchasePreviewResponse> getHostReservationPurchasePreview(
            GetHostReservationPurchasePreviewRequest getHostReservationPurchasePreviewRequest) {

        StaxResponseHandler<GetHostReservationPurchasePreviewResponse> responseHandler = new StaxResponseHandler<GetHostReservationPurchasePreviewResponse>(
                new GetHostReservationPurchasePreviewResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<GetHostReservationPurchasePreviewRequest, GetHostReservationPurchasePreviewResponse>()
                        .withMarshaller(new GetHostReservationPurchasePreviewRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getHostReservationPurchasePreviewRequest));
    }

    /**
     * <p>
     * Retrieves the encrypted administrator password for a running Windows instance.
     * </p>
     * <p>
     * The Windows password is generated at boot by the <code>EC2Config</code> service or <code>EC2Launch</code> scripts
     * (Windows Server 2016 and later). This usually only happens the first time an instance is launched. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/UsingConfig_WinAMI.html">EC2Config</a> and <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2launch.html">EC2Launch</a> in the Amazon Elastic
     * Compute Cloud User Guide.
     * </p>
     * <p>
     * For the <code>EC2Config</code> service, the password is not generated for rebundled AMIs unless
     * <code>Ec2SetPassword</code> is enabled before bundling.
     * </p>
     * <p>
     * The password is encrypted using the key pair that you specified when you launched the instance. You must provide
     * the corresponding key pair file.
     * </p>
     * <p>
     * When you launch an instance, password generation and encryption may take a few minutes. If you try to retrieve
     * the password before it's available, the output returns an empty string. We recommend that you wait up to 15
     * minutes after launching an instance before trying to retrieve the generated password.
     * </p>
     *
     * @param getPasswordDataRequest
     *        Contains the parameters for GetPasswordData.
     * @return A Java Future containing the result of the GetPasswordData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.GetPasswordData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetPasswordData" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPasswordDataResponse> getPasswordData(GetPasswordDataRequest getPasswordDataRequest) {

        StaxResponseHandler<GetPasswordDataResponse> responseHandler = new StaxResponseHandler<GetPasswordDataResponse>(
                new GetPasswordDataResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetPasswordDataRequest, GetPasswordDataResponse>()
                .withMarshaller(new GetPasswordDataRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getPasswordDataRequest));
    }

    /**
     * <p>
     * Returns a quote and exchange information for exchanging one or more specified Convertible Reserved Instances for
     * a new Convertible Reserved Instance. If the exchange cannot be performed, the reason is returned in the response.
     * Use <a>AcceptReservedInstancesExchangeQuote</a> to perform the exchange.
     * </p>
     *
     * @param getReservedInstancesExchangeQuoteRequest
     *        Contains the parameters for GetReservedInstanceExchangeQuote.
     * @return A Java Future containing the result of the GetReservedInstancesExchangeQuote operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.GetReservedInstancesExchangeQuote
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReservedInstancesExchangeQuoteResponse> getReservedInstancesExchangeQuote(
            GetReservedInstancesExchangeQuoteRequest getReservedInstancesExchangeQuoteRequest) {

        StaxResponseHandler<GetReservedInstancesExchangeQuoteResponse> responseHandler = new StaxResponseHandler<GetReservedInstancesExchangeQuoteResponse>(
                new GetReservedInstancesExchangeQuoteResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<GetReservedInstancesExchangeQuoteRequest, GetReservedInstancesExchangeQuoteResponse>()
                        .withMarshaller(new GetReservedInstancesExchangeQuoteRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getReservedInstancesExchangeQuoteRequest));
    }

    /**
     * <p>
     * Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI). For more
     * information, see <a
     * href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html">Importing a VM as an
     * Image Using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     *
     * @param importImageRequest
     *        Contains the parameters for ImportImage.
     * @return A Java Future containing the result of the ImportImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ImportImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportImageResponse> importImage(ImportImageRequest importImageRequest) {

        StaxResponseHandler<ImportImageResponse> responseHandler = new StaxResponseHandler<ImportImageResponse>(
                new ImportImageResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ImportImageRequest, ImportImageResponse>()
                .withMarshaller(new ImportImageRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(importImageRequest));
    }

    /**
     * <p>
     * Creates an import instance task using metadata from the specified disk image. <code>ImportInstance</code> only
     * supports single-volume VMs. To import multi-volume VMs, use <a>ImportImage</a>. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a
     * Virtual Machine Using the Amazon EC2 CLI</a>.
     * </p>
     * <p>
     * For information about the import manifest referenced by this API action, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     * </p>
     *
     * @param importInstanceRequest
     *        Contains the parameters for ImportInstance.
     * @return A Java Future containing the result of the ImportInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ImportInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportInstanceResponse> importInstance(ImportInstanceRequest importInstanceRequest) {

        StaxResponseHandler<ImportInstanceResponse> responseHandler = new StaxResponseHandler<ImportInstanceResponse>(
                new ImportInstanceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ImportInstanceRequest, ImportInstanceResponse>()
                .withMarshaller(new ImportInstanceRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(importInstanceRequest));
    }

    /**
     * <p>
     * Imports the public key from an RSA key pair that you created with a third-party tool. Compare this with
     * <a>CreateKeyPair</a>, in which AWS creates the key pair and gives the keys to you (AWS keeps a copy of the public
     * key). With ImportKeyPair, you create the key pair and give AWS just the public key. The private key is never
     * transferred between you and AWS.
     * </p>
     * <p>
     * For more information about key pairs, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param importKeyPairRequest
     *        Contains the parameters for ImportKeyPair.
     * @return A Java Future containing the result of the ImportKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportKeyPairResponse> importKeyPair(ImportKeyPairRequest importKeyPairRequest) {

        StaxResponseHandler<ImportKeyPairResponse> responseHandler = new StaxResponseHandler<ImportKeyPairResponse>(
                new ImportKeyPairResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ImportKeyPairRequest, ImportKeyPairResponse>()
                .withMarshaller(new ImportKeyPairRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(importKeyPairRequest));
    }

    /**
     * <p>
     * Imports a disk into an EBS snapshot.
     * </p>
     *
     * @param importSnapshotRequest
     *        Contains the parameters for ImportSnapshot.
     * @return A Java Future containing the result of the ImportSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ImportSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportSnapshotResponse> importSnapshot(ImportSnapshotRequest importSnapshotRequest) {

        StaxResponseHandler<ImportSnapshotResponse> responseHandler = new StaxResponseHandler<ImportSnapshotResponse>(
                new ImportSnapshotResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ImportSnapshotRequest, ImportSnapshotResponse>()
                .withMarshaller(new ImportSnapshotRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(importSnapshotRequest));
    }

    /**
     * <p>
     * Creates an import volume task using metadata from the specified disk image.For more information, see <a href=
     * "http://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/importing-your-volumes-into-amazon-ebs.html"
     * >Importing Disks to Amazon EBS</a>.
     * </p>
     * <p>
     * For information about the import manifest referenced by this API action, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     * </p>
     *
     * @param importVolumeRequest
     *        Contains the parameters for ImportVolume.
     * @return A Java Future containing the result of the ImportVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ImportVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ImportVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportVolumeResponse> importVolume(ImportVolumeRequest importVolumeRequest) {

        StaxResponseHandler<ImportVolumeResponse> responseHandler = new StaxResponseHandler<ImportVolumeResponse>(
                new ImportVolumeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ImportVolumeRequest, ImportVolumeResponse>()
                .withMarshaller(new ImportVolumeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(importVolumeRequest));
    }

    /**
     * <p>
     * Modifies the specified attribute of the specified Amazon FPGA Image (AFI).
     * </p>
     *
     * @param modifyFpgaImageAttributeRequest
     * @return A Java Future containing the result of the ModifyFpgaImageAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyFpgaImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyFpgaImageAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyFpgaImageAttributeResponse> modifyFpgaImageAttribute(
            ModifyFpgaImageAttributeRequest modifyFpgaImageAttributeRequest) {

        StaxResponseHandler<ModifyFpgaImageAttributeResponse> responseHandler = new StaxResponseHandler<ModifyFpgaImageAttributeResponse>(
                new ModifyFpgaImageAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ModifyFpgaImageAttributeRequest, ModifyFpgaImageAttributeResponse>()
                        .withMarshaller(new ModifyFpgaImageAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(modifyFpgaImageAttributeRequest));
    }

    /**
     * <p>
     * Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled, AWS will place instances
     * that you launch with a tenancy of <code>host</code>, but without targeting a specific host ID, onto any available
     * Dedicated Host in your account which has auto-placement enabled. When auto-placement is disabled, you need to
     * provide a host ID if you want the instance to launch onto a specific host. If no host ID is provided, the
     * instance will be launched onto a suitable host which has auto-placement enabled.
     * </p>
     *
     * @param modifyHostsRequest
     *        Contains the parameters for ModifyHosts.
     * @return A Java Future containing the result of the ModifyHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyHosts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyHostsResponse> modifyHosts(ModifyHostsRequest modifyHostsRequest) {

        StaxResponseHandler<ModifyHostsResponse> responseHandler = new StaxResponseHandler<ModifyHostsResponse>(
                new ModifyHostsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyHostsRequest, ModifyHostsResponse>()
                .withMarshaller(new ModifyHostsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyHostsRequest));
    }

    /**
     * <p>
     * Modifies the ID format for the specified resource on a per-region basis. You can specify that resources should
     * receive longer IDs (17-character IDs) when they are created. The following resource types support longer IDs:
     * <code>instance</code> | <code>reservation</code> | <code>snapshot</code> | <code>volume</code>.
     * </p>
     * <p>
     * This setting applies to the IAM user who makes the request; it does not apply to the entire AWS account. By
     * default, an IAM user defaults to the same settings as the root user. If you're using this action as the root
     * user, then these settings apply to the entire account, unless an IAM user explicitly overrides these settings for
     * themselves. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and
     * provided that they have permission to use the relevant <code>Describe</code> command for the resource type.
     * </p>
     *
     * @param modifyIdFormatRequest
     *        Contains the parameters of ModifyIdFormat.
     * @return A Java Future containing the result of the ModifyIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyIdFormat" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyIdFormatResponse> modifyIdFormat(ModifyIdFormatRequest modifyIdFormatRequest) {

        StaxResponseHandler<ModifyIdFormatResponse> responseHandler = new StaxResponseHandler<ModifyIdFormatResponse>(
                new ModifyIdFormatResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyIdFormatRequest, ModifyIdFormatResponse>()
                .withMarshaller(new ModifyIdFormatRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyIdFormatRequest));
    }

    /**
     * <p>
     * Modifies the ID format of a resource for a specified IAM user, IAM role, or the root user for an account; or all
     * IAM users, IAM roles, and the root user for an account. You can specify that resources should receive longer IDs
     * (17-character IDs) when they are created.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>instance</code> | <code>reservation</code> |
     * <code>snapshot</code> | <code>volume</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * This setting applies to the principal specified in the request; it does not apply to the principal that makes the
     * request.
     * </p>
     * <p>
     * Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and
     * provided that they have permission to use the relevant <code>Describe</code> command for the resource type.
     * </p>
     *
     * @param modifyIdentityIdFormatRequest
     *        Contains the parameters of ModifyIdentityIdFormat.
     * @return A Java Future containing the result of the ModifyIdentityIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyIdentityIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyIdentityIdFormat" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyIdentityIdFormatResponse> modifyIdentityIdFormat(
            ModifyIdentityIdFormatRequest modifyIdentityIdFormatRequest) {

        StaxResponseHandler<ModifyIdentityIdFormatResponse> responseHandler = new StaxResponseHandler<ModifyIdentityIdFormatResponse>(
                new ModifyIdentityIdFormatResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyIdentityIdFormatRequest, ModifyIdentityIdFormatResponse>()
                .withMarshaller(new ModifyIdentityIdFormatRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyIdentityIdFormatRequest));
    }

    /**
     * <p>
     * Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time. You can use
     * the <code>Attribute</code> parameter to specify the attribute or one of the following parameters:
     * <code>Description</code>, <code>LaunchPermission</code>, or <code>ProductCode</code>.
     * </p>
     * <p>
     * AWS Marketplace product codes cannot be modified. Images with an AWS Marketplace product code cannot be made
     * public.
     * </p>
     * <p>
     * To enable the SriovNetSupport enhanced networking attribute of an image, enable SriovNetSupport on an instance
     * and create an AMI from the instance.
     * </p>
     *
     * @param modifyImageAttributeRequest
     *        Contains the parameters for ModifyImageAttribute.
     * @return A Java Future containing the result of the ModifyImageAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyImageAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyImageAttributeResponse> modifyImageAttribute(
            ModifyImageAttributeRequest modifyImageAttributeRequest) {

        StaxResponseHandler<ModifyImageAttributeResponse> responseHandler = new StaxResponseHandler<ModifyImageAttributeResponse>(
                new ModifyImageAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyImageAttributeRequest, ModifyImageAttributeResponse>()
                .withMarshaller(new ModifyImageAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyImageAttributeRequest));
    }

    /**
     * <p>
     * Modifies the specified attribute of the specified instance. You can specify only one attribute at a time.
     * </p>
     * <p>
     * To modify some attributes, the instance must be stopped. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html"
     * >Modifying Attributes of a Stopped Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param modifyInstanceAttributeRequest
     *        Contains the parameters for ModifyInstanceAttribute.
     * @return A Java Future containing the result of the ModifyInstanceAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyInstanceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstanceAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyInstanceAttributeResponse> modifyInstanceAttribute(
            ModifyInstanceAttributeRequest modifyInstanceAttributeRequest) {

        StaxResponseHandler<ModifyInstanceAttributeResponse> responseHandler = new StaxResponseHandler<ModifyInstanceAttributeResponse>(
                new ModifyInstanceAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyInstanceAttributeRequest, ModifyInstanceAttributeResponse>()
                .withMarshaller(new ModifyInstanceAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyInstanceAttributeRequest));
    }

    /**
     * <p>
     * Set the instance affinity value for a specific stopped instance and modify the instance tenancy setting.
     * </p>
     * <p>
     * Instance affinity is disabled by default. When instance affinity is <code>host</code> and it is not associated
     * with a specific Dedicated Host, the next time it is launched it will automatically be associated with the host it
     * lands on. This relationship will persist if the instance is stopped/started, or rebooted.
     * </p>
     * <p>
     * You can modify the host ID associated with a stopped instance. If a stopped instance has a new host ID
     * association, the instance will target that host when restarted.
     * </p>
     * <p>
     * You can modify the tenancy of a stopped instance with a tenancy of <code>host</code> or <code>dedicated</code>.
     * </p>
     * <p>
     * Affinity, hostID, and tenancy are not required parameters, but at least one of them must be specified in the
     * request. Affinity and tenancy can be modified in the same request, but tenancy can only be modified on instances
     * that are stopped.
     * </p>
     *
     * @param modifyInstancePlacementRequest
     *        Contains the parameters for ModifyInstancePlacement.
     * @return A Java Future containing the result of the ModifyInstancePlacement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyInstancePlacement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstancePlacement" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyInstancePlacementResponse> modifyInstancePlacement(
            ModifyInstancePlacementRequest modifyInstancePlacementRequest) {

        StaxResponseHandler<ModifyInstancePlacementResponse> responseHandler = new StaxResponseHandler<ModifyInstancePlacementResponse>(
                new ModifyInstancePlacementResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyInstancePlacementRequest, ModifyInstancePlacementResponse>()
                .withMarshaller(new ModifyInstancePlacementRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyInstancePlacementRequest));
    }

    /**
     * <p>
     * Modifies the specified network interface attribute. You can specify only one attribute at a time.
     * </p>
     *
     * @param modifyNetworkInterfaceAttributeRequest
     *        Contains the parameters for ModifyNetworkInterfaceAttribute.
     * @return A Java Future containing the result of the ModifyNetworkInterfaceAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyNetworkInterfaceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyNetworkInterfaceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyNetworkInterfaceAttributeResponse> modifyNetworkInterfaceAttribute(
            ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) {

        StaxResponseHandler<ModifyNetworkInterfaceAttributeResponse> responseHandler = new StaxResponseHandler<ModifyNetworkInterfaceAttributeResponse>(
                new ModifyNetworkInterfaceAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ModifyNetworkInterfaceAttributeRequest, ModifyNetworkInterfaceAttributeResponse>()
                        .withMarshaller(new ModifyNetworkInterfaceAttributeRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(modifyNetworkInterfaceAttributeRequest));
    }

    /**
     * <p>
     * Modifies the Availability Zone, instance count, instance type, or network platform (EC2-Classic or EC2-VPC) of
     * your Reserved Instances. The Reserved Instances to be modified must be identical, except for Availability Zone,
     * network platform, and instance type.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in
     * the Amazon Elastic Compute Cloud User Guide.
     * </p>
     *
     * @param modifyReservedInstancesRequest
     *        Contains the parameters for ModifyReservedInstances.
     * @return A Java Future containing the result of the ModifyReservedInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyReservedInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyReservedInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyReservedInstancesResponse> modifyReservedInstances(
            ModifyReservedInstancesRequest modifyReservedInstancesRequest) {

        StaxResponseHandler<ModifyReservedInstancesResponse> responseHandler = new StaxResponseHandler<ModifyReservedInstancesResponse>(
                new ModifyReservedInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyReservedInstancesRequest, ModifyReservedInstancesResponse>()
                .withMarshaller(new ModifyReservedInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyReservedInstancesRequest));
    }

    /**
     * <p>
     * Adds or removes permission settings for the specified snapshot. You may add or remove specified AWS account IDs
     * from a snapshot's list of create volume permissions, but you cannot do both in a single API call. If you need to
     * both add and remove account IDs for a snapshot, you must use multiple API calls.
     * </p>
     * <note>
     * <p>
     * Encrypted snapshots and snapshots with AWS Marketplace product codes cannot be made public. Snapshots encrypted
     * with your default CMK cannot be shared with other accounts.
     * </p>
     * </note>
     * <p>
     * For more information on modifying snapshot permissions, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Sharing
     * Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param modifySnapshotAttributeRequest
     *        Contains the parameters for ModifySnapshotAttribute.
     * @return A Java Future containing the result of the ModifySnapshotAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifySnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySnapshotAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifySnapshotAttributeResponse> modifySnapshotAttribute(
            ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {

        StaxResponseHandler<ModifySnapshotAttributeResponse> responseHandler = new StaxResponseHandler<ModifySnapshotAttributeResponse>(
                new ModifySnapshotAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifySnapshotAttributeRequest, ModifySnapshotAttributeResponse>()
                .withMarshaller(new ModifySnapshotAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifySnapshotAttributeRequest));
    }

    /**
     * <p>
     * Modifies the specified Spot fleet request.
     * </p>
     * <p>
     * While the Spot fleet request is being modified, it is in the <code>modifying</code> state.
     * </p>
     * <p>
     * To scale up your Spot fleet, increase its target capacity. The Spot fleet launches the additional Spot instances
     * according to the allocation strategy for the Spot fleet request. If the allocation strategy is
     * <code>lowestPrice</code>, the Spot fleet launches instances using the Spot pool with the lowest price. If the
     * allocation strategy is <code>diversified</code>, the Spot fleet distributes the instances across the Spot pools.
     * </p>
     * <p>
     * To scale down your Spot fleet, decrease its target capacity. First, the Spot fleet cancels any open bids that
     * exceed the new target capacity. You can request that the Spot fleet terminate Spot instances until the size of
     * the fleet no longer exceeds the new target capacity. If the allocation strategy is <code>lowestPrice</code>, the
     * Spot fleet terminates the instances with the highest price per unit. If the allocation strategy is
     * <code>diversified</code>, the Spot fleet terminates instances across the Spot pools. Alternatively, you can
     * request that the Spot fleet keep the fleet at its current size, but not replace any Spot instances that are
     * interrupted or that you terminate manually.
     * </p>
     *
     * @param modifySpotFleetRequestRequest
     *        Contains the parameters for ModifySpotFleetRequest.
     * @return A Java Future containing the result of the ModifySpotFleetRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifySpotFleetRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySpotFleetRequest" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifySpotFleetRequestResponse> modifySpotFleetRequest(
            ModifySpotFleetRequestRequest modifySpotFleetRequestRequest) {

        StaxResponseHandler<ModifySpotFleetRequestResponse> responseHandler = new StaxResponseHandler<ModifySpotFleetRequestResponse>(
                new ModifySpotFleetRequestResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifySpotFleetRequestRequest, ModifySpotFleetRequestResponse>()
                .withMarshaller(new ModifySpotFleetRequestRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifySpotFleetRequestRequest));
    }

    /**
     * <p>
     * Modifies a subnet attribute. You can only modify one attribute at a time.
     * </p>
     *
     * @param modifySubnetAttributeRequest
     *        Contains the parameters for ModifySubnetAttribute.
     * @return A Java Future containing the result of the ModifySubnetAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifySubnetAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySubnetAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifySubnetAttributeResponse> modifySubnetAttribute(
            ModifySubnetAttributeRequest modifySubnetAttributeRequest) {

        StaxResponseHandler<ModifySubnetAttributeResponse> responseHandler = new StaxResponseHandler<ModifySubnetAttributeResponse>(
                new ModifySubnetAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifySubnetAttributeRequest, ModifySubnetAttributeResponse>()
                .withMarshaller(new ModifySubnetAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifySubnetAttributeRequest));
    }

    /**
     * <p>
     * You can modify several parameters of an existing EBS volume, including volume size, volume type, and IOPS
     * capacity. If your EBS volume is attached to a current-generation EC2 instance type, you may be able to apply
     * these changes without stopping the instance or detaching the volume from it. For more information about modifying
     * an EBS volume running Linux, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html">Modifying the Size, IOPS, or
     * Type of an EBS Volume on Linux</a>. For more information about modifying an EBS volume running Windows, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html">Modifying the Size, IOPS, or
     * Type of an EBS Volume on Windows</a>.
     * </p>
     * <p>
     * When you complete a resize operation on your volume, you need to extend the volume's file-system size to take
     * advantage of the new storage capacity. For information about extending a Linux file system, see <a href=
     * "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#recognize-expanded-volume-linux"
     * >Extending a Linux File System</a>. For information about extending a Windows file system, see <a href=
     * "http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html#recognize-expanded-volume-windows"
     * >Extending a Windows File System</a>.
     * </p>
     * <p>
     * You can use CloudWatch Events to check the status of a modification to an EBS volume. For information about
     * CloudWatch Events, see the <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch
     * Events User Guide</a>. You can also track the status of a modification using the
     * <a>DescribeVolumesModifications</a> API. For information about tracking status changes using either method, see
     * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#monitoring_mods">Monitoring
     * Volume Modifications</a>.
     * </p>
     * <note>
     * <p>
     * With previous-generation instance types, resizing an EBS volume may require detaching and reattaching the volume
     * or stopping and restarting the instance. For more information about modifying an EBS volume running Linux, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html">Modifying the Size, IOPS, or
     * Type of an EBS Volume on Linux</a>. For more information about modifying an EBS volume running Windows, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html">Modifying the Size, IOPS, or
     * Type of an EBS Volume on Windows</a>.
     * </p>
     * </note> <note>
     * <p>
     * If you reach the maximum volume modification rate per volume limit, you will need to wait at least six hours
     * before applying further modifications to the affected EBS volume.
     * </p>
     * </note>
     *
     * @param modifyVolumeRequest
     * @return A Java Future containing the result of the ModifyVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyVolumeResponse> modifyVolume(ModifyVolumeRequest modifyVolumeRequest) {

        StaxResponseHandler<ModifyVolumeResponse> responseHandler = new StaxResponseHandler<ModifyVolumeResponse>(
                new ModifyVolumeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyVolumeRequest, ModifyVolumeResponse>()
                .withMarshaller(new ModifyVolumeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyVolumeRequest));
    }

    /**
     * <p>
     * Modifies a volume attribute.
     * </p>
     * <p>
     * By default, all I/O operations for the volume are suspended when the data on the volume is determined to be
     * potentially inconsistent, to prevent undetectable, latent data corruption. The I/O access to the volume can be
     * resumed by first enabling I/O access and then checking the data consistency on your volume.
     * </p>
     * <p>
     * You can change the default behavior to resume I/O operations. We recommend that you change this only for boot
     * volumes or for volumes that are stateless or disposable.
     * </p>
     *
     * @param modifyVolumeAttributeRequest
     *        Contains the parameters for ModifyVolumeAttribute.
     * @return A Java Future containing the result of the ModifyVolumeAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyVolumeAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVolumeAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyVolumeAttributeResponse> modifyVolumeAttribute(
            ModifyVolumeAttributeRequest modifyVolumeAttributeRequest) {

        StaxResponseHandler<ModifyVolumeAttributeResponse> responseHandler = new StaxResponseHandler<ModifyVolumeAttributeResponse>(
                new ModifyVolumeAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyVolumeAttributeRequest, ModifyVolumeAttributeResponse>()
                .withMarshaller(new ModifyVolumeAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyVolumeAttributeRequest));
    }

    /**
     * <p>
     * Modifies the specified attribute of the specified VPC.
     * </p>
     *
     * @param modifyVpcAttributeRequest
     *        Contains the parameters for ModifyVpcAttribute.
     * @return A Java Future containing the result of the ModifyVpcAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyVpcAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyVpcAttributeResponse> modifyVpcAttribute(ModifyVpcAttributeRequest modifyVpcAttributeRequest) {

        StaxResponseHandler<ModifyVpcAttributeResponse> responseHandler = new StaxResponseHandler<ModifyVpcAttributeResponse>(
                new ModifyVpcAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyVpcAttributeRequest, ModifyVpcAttributeResponse>()
                .withMarshaller(new ModifyVpcAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyVpcAttributeRequest));
    }

    /**
     * <p>
     * Modifies attributes of a specified VPC endpoint. The attributes that you can modify depend on the type of VPC
     * endpoint (interface or gateway). For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-endpoints.html">VPC Endpoints</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param modifyVpcEndpointRequest
     *        Contains the parameters for ModifyVpcEndpoint.
     * @return A Java Future containing the result of the ModifyVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyVpcEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyVpcEndpointResponse> modifyVpcEndpoint(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {

        StaxResponseHandler<ModifyVpcEndpointResponse> responseHandler = new StaxResponseHandler<ModifyVpcEndpointResponse>(
                new ModifyVpcEndpointResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyVpcEndpointRequest, ModifyVpcEndpointResponse>()
                .withMarshaller(new ModifyVpcEndpointRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyVpcEndpointRequest));
    }

    /**
     * <p>
     * Modifies the VPC peering connection options on one side of a VPC peering connection. You can do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Enable/disable communication over the peering connection between an EC2-Classic instance that's linked to your
     * VPC (using ClassicLink) and instances in the peer VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enable/disable communication over the peering connection between instances in your VPC and an EC2-Classic
     * instance that's linked to the peer VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enable/disable a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in
     * the peer VPC.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the peered VPCs are in different accounts, each owner must initiate a separate request to modify the peering
     * connection options, depending on whether their VPC was the requester or accepter for the VPC peering connection.
     * If the peered VPCs are in the same account, you can modify the requester and accepter options in the same
     * request. To confirm which VPC is the accepter and requester for a VPC peering connection, use the
     * <a>DescribeVpcPeeringConnections</a> command.
     * </p>
     *
     * @param modifyVpcPeeringConnectionOptionsRequest
     * @return A Java Future containing the result of the ModifyVpcPeeringConnectionOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyVpcPeeringConnectionOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcPeeringConnectionOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyVpcPeeringConnectionOptionsResponse> modifyVpcPeeringConnectionOptions(
            ModifyVpcPeeringConnectionOptionsRequest modifyVpcPeeringConnectionOptionsRequest) {

        StaxResponseHandler<ModifyVpcPeeringConnectionOptionsResponse> responseHandler = new StaxResponseHandler<ModifyVpcPeeringConnectionOptionsResponse>(
                new ModifyVpcPeeringConnectionOptionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ModifyVpcPeeringConnectionOptionsRequest, ModifyVpcPeeringConnectionOptionsResponse>()
                        .withMarshaller(new ModifyVpcPeeringConnectionOptionsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(modifyVpcPeeringConnectionOptionsRequest));
    }

    /**
     * <p>
     * Modifies the instance tenancy attribute of the specified VPC. You can change the instance tenancy attribute of a
     * VPC to <code>default</code> only. You cannot change the instance tenancy attribute to <code>dedicated</code>.
     * </p>
     * <p>
     * After you modify the tenancy of the VPC, any new instances that you launch into the VPC have a tenancy of
     * <code>default</code>, unless you specify otherwise during launch. The tenancy of any existing instances in the
     * VPC is not affected.
     * </p>
     * <p>
     * For more information about Dedicated Instances, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param modifyVpcTenancyRequest
     *        Contains the parameters for ModifyVpcTenancy.
     * @return A Java Future containing the result of the ModifyVpcTenancy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ModifyVpcTenancy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcTenancy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyVpcTenancyResponse> modifyVpcTenancy(ModifyVpcTenancyRequest modifyVpcTenancyRequest) {

        StaxResponseHandler<ModifyVpcTenancyResponse> responseHandler = new StaxResponseHandler<ModifyVpcTenancyResponse>(
                new ModifyVpcTenancyResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ModifyVpcTenancyRequest, ModifyVpcTenancyResponse>()
                .withMarshaller(new ModifyVpcTenancyRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(modifyVpcTenancyRequest));
    }

    /**
     * <p>
     * Enables detailed monitoring for a running instance. Otherwise, basic monitoring is enabled. For more information,
     * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring Your Instances
     * and Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * To disable detailed monitoring, see .
     * </p>
     *
     * @param monitorInstancesRequest
     *        Contains the parameters for MonitorInstances.
     * @return A Java Future containing the result of the MonitorInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.MonitorInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/MonitorInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<MonitorInstancesResponse> monitorInstances(MonitorInstancesRequest monitorInstancesRequest) {

        StaxResponseHandler<MonitorInstancesResponse> responseHandler = new StaxResponseHandler<MonitorInstancesResponse>(
                new MonitorInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<MonitorInstancesRequest, MonitorInstancesResponse>()
                .withMarshaller(new MonitorInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(monitorInstancesRequest));
    }

    /**
     * <p>
     * Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The Elastic IP address must be
     * allocated to your account for more than 24 hours, and it must not be associated with an instance. After the
     * Elastic IP address is moved, it is no longer available for use in the EC2-Classic platform, unless you move it
     * back using the <a>RestoreAddressToClassic</a> request. You cannot move an Elastic IP address that was originally
     * allocated for use in the EC2-VPC platform to the EC2-Classic platform.
     * </p>
     *
     * @param moveAddressToVpcRequest
     *        Contains the parameters for MoveAddressToVpc.
     * @return A Java Future containing the result of the MoveAddressToVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.MoveAddressToVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/MoveAddressToVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<MoveAddressToVpcResponse> moveAddressToVpc(MoveAddressToVpcRequest moveAddressToVpcRequest) {

        StaxResponseHandler<MoveAddressToVpcResponse> responseHandler = new StaxResponseHandler<MoveAddressToVpcResponse>(
                new MoveAddressToVpcResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<MoveAddressToVpcRequest, MoveAddressToVpcResponse>()
                .withMarshaller(new MoveAddressToVpcRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(moveAddressToVpcRequest));
    }

    /**
     * <p>
     * Purchase a reservation with configurations that match those of your Dedicated Host. You must have active
     * Dedicated Hosts in your account before you purchase a reservation. This action results in the specified
     * reservation being purchased and charged to your account.
     * </p>
     *
     * @param purchaseHostReservationRequest
     * @return A Java Future containing the result of the PurchaseHostReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.PurchaseHostReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseHostReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PurchaseHostReservationResponse> purchaseHostReservation(
            PurchaseHostReservationRequest purchaseHostReservationRequest) {

        StaxResponseHandler<PurchaseHostReservationResponse> responseHandler = new StaxResponseHandler<PurchaseHostReservationResponse>(
                new PurchaseHostReservationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<PurchaseHostReservationRequest, PurchaseHostReservationResponse>()
                .withMarshaller(new PurchaseHostReservationRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(purchaseHostReservationRequest));
    }

    /**
     * <p>
     * Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower hourly rate
     * compared to On-Demand instance pricing.
     * </p>
     * <p>
     * Use <a>DescribeReservedInstancesOfferings</a> to get a list of Reserved Instance offerings that match your
     * specifications. After you've purchased a Reserved Instance, you can check for your new Reserved Instance with
     * <a>DescribeReservedInstances</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved
     * Instances</a> and <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved
     * Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param purchaseReservedInstancesOfferingRequest
     *        Contains the parameters for PurchaseReservedInstancesOffering.
     * @return A Java Future containing the result of the PurchaseReservedInstancesOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.PurchaseReservedInstancesOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseReservedInstancesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PurchaseReservedInstancesOfferingResponse> purchaseReservedInstancesOffering(
            PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) {

        StaxResponseHandler<PurchaseReservedInstancesOfferingResponse> responseHandler = new StaxResponseHandler<PurchaseReservedInstancesOfferingResponse>(
                new PurchaseReservedInstancesOfferingResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<PurchaseReservedInstancesOfferingRequest, PurchaseReservedInstancesOfferingResponse>()
                        .withMarshaller(new PurchaseReservedInstancesOfferingRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(purchaseReservedInstancesOfferingRequest));
    }

    /**
     * <p>
     * Purchases one or more Scheduled Instances with the specified schedule.
     * </p>
     * <p>
     * Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term. Before
     * you can purchase a Scheduled Instance, you must call <a>DescribeScheduledInstanceAvailability</a> to check for
     * available schedules and obtain a purchase token. After you purchase a Scheduled Instance, you must call
     * <a>RunScheduledInstances</a> during each scheduled time period.
     * </p>
     * <p>
     * After you purchase a Scheduled Instance, you can't cancel, modify, or resell your purchase.
     * </p>
     *
     * @param purchaseScheduledInstancesRequest
     *        Contains the parameters for PurchaseScheduledInstances.
     * @return A Java Future containing the result of the PurchaseScheduledInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.PurchaseScheduledInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/PurchaseScheduledInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PurchaseScheduledInstancesResponse> purchaseScheduledInstances(
            PurchaseScheduledInstancesRequest purchaseScheduledInstancesRequest) {

        StaxResponseHandler<PurchaseScheduledInstancesResponse> responseHandler = new StaxResponseHandler<PurchaseScheduledInstancesResponse>(
                new PurchaseScheduledInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<PurchaseScheduledInstancesRequest, PurchaseScheduledInstancesResponse>()
                        .withMarshaller(new PurchaseScheduledInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(purchaseScheduledInstancesRequest));
    }

    /**
     * <p>
     * Requests a reboot of one or more instances. This operation is asynchronous; it only queues a request to reboot
     * the specified instances. The operation succeeds if the instances are valid and belong to you. Requests to reboot
     * terminated instances are ignored.
     * </p>
     * <p>
     * If an instance does not cleanly shut down within four minutes, Amazon EC2 performs a hard reboot.
     * </p>
     * <p>
     * For more information about troubleshooting, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html">Getting Console Output and
     * Rebooting Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param rebootInstancesRequest
     *        Contains the parameters for RebootInstances.
     * @return A Java Future containing the result of the RebootInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RebootInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RebootInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootInstancesResponse> rebootInstances(RebootInstancesRequest rebootInstancesRequest) {

        StaxResponseHandler<RebootInstancesResponse> responseHandler = new StaxResponseHandler<RebootInstancesResponse>(
                new RebootInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<RebootInstancesRequest, RebootInstancesResponse>()
                .withMarshaller(new RebootInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(rebootInstancesRequest));
    }

    /**
     * <p>
     * Registers an AMI. When you're creating an AMI, this is the final step you must complete before you can launch an
     * instance from the AMI. For more information about creating AMIs, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami.html">Creating Your Own AMIs</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <note>
     * <p>
     * For Amazon EBS-backed instances, <a>CreateImage</a> creates and registers the AMI in a single request, so you
     * don't have to register the AMI yourself.
     * </p>
     * </note>
     * <p>
     * You can also use <code>RegisterImage</code> to create an Amazon EBS-backed Linux AMI from a snapshot of a root
     * device volume. You specify the snapshot using the block device mapping. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-launch-snapshot.html">Launching a Linux
     * Instance from a Backup</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can't register an image where a secondary (non-root) snapshot has AWS Marketplace product codes.
     * </p>
     * <p>
     * Some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE Linux Enterprise Server (SLES), use
     * the EC2 billing product code associated with an AMI to verify the subscription status for package updates.
     * Creating an AMI from an EBS snapshot does not maintain this billing code, and subsequent instances launched from
     * such an AMI will not be able to connect to package update infrastructure. To create an AMI that must retain
     * billing codes, see <a>CreateImage</a>.
     * </p>
     * <p>
     * If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance
     * store volume invalidates its registration. If you make changes to an image, deregister the previous image and
     * register the new image.
     * </p>
     *
     * @param registerImageRequest
     *        Contains the parameters for RegisterImage.
     * @return A Java Future containing the result of the RegisterImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RegisterImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RegisterImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterImageResponse> registerImage(RegisterImageRequest registerImageRequest) {

        StaxResponseHandler<RegisterImageResponse> responseHandler = new StaxResponseHandler<RegisterImageResponse>(
                new RegisterImageResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<RegisterImageRequest, RegisterImageResponse>()
                .withMarshaller(new RegisterImageRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(registerImageRequest));
    }

    /**
     * <p>
     * Rejects a VPC peering connection request. The VPC peering connection must be in the
     * <code>pending-acceptance</code> state. Use the <a>DescribeVpcPeeringConnections</a> request to view your
     * outstanding VPC peering connection requests. To delete an active VPC peering connection, or to delete a VPC
     * peering connection request that you initiated, use <a>DeleteVpcPeeringConnection</a>.
     * </p>
     *
     * @param rejectVpcPeeringConnectionRequest
     *        Contains the parameters for RejectVpcPeeringConnection.
     * @return A Java Future containing the result of the RejectVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RejectVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RejectVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RejectVpcPeeringConnectionResponse> rejectVpcPeeringConnection(
            RejectVpcPeeringConnectionRequest rejectVpcPeeringConnectionRequest) {

        StaxResponseHandler<RejectVpcPeeringConnectionResponse> responseHandler = new StaxResponseHandler<RejectVpcPeeringConnectionResponse>(
                new RejectVpcPeeringConnectionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<RejectVpcPeeringConnectionRequest, RejectVpcPeeringConnectionResponse>()
                        .withMarshaller(new RejectVpcPeeringConnectionRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(rejectVpcPeeringConnectionRequest));
    }

    /**
     * <p>
     * Releases the specified Elastic IP address.
     * </p>
     * <p>
     * [EC2-Classic, default VPC] Releasing an Elastic IP address automatically disassociates it from any instance that
     * it's associated with. To disassociate an Elastic IP address without releasing it, use <a>DisassociateAddress</a>.
     * </p>
     * <p>
     * [Nondefault VPC] You must use <a>DisassociateAddress</a> to disassociate the Elastic IP address before you can
     * release it. Otherwise, Amazon EC2 returns an error (<code>InvalidIPAddress.InUse</code>).
     * </p>
     * <p>
     * After releasing an Elastic IP address, it is released to the IP address pool. Be sure to update your DNS records
     * and any servers or devices that communicate with the address. If you attempt to release an Elastic IP address
     * that you already released, you'll get an <code>AuthFailure</code> error if the address is already allocated to
     * another AWS account.
     * </p>
     * <p>
     * [EC2-VPC] After you release an Elastic IP address for use in a VPC, you might be able to recover it. For more
     * information, see <a>AllocateAddress</a>.
     * </p>
     *
     * @param releaseAddressRequest
     *        Contains the parameters for ReleaseAddress.
     * @return A Java Future containing the result of the ReleaseAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ReleaseAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReleaseAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ReleaseAddressResponse> releaseAddress(ReleaseAddressRequest releaseAddressRequest) {

        StaxResponseHandler<ReleaseAddressResponse> responseHandler = new StaxResponseHandler<ReleaseAddressResponse>(
                new ReleaseAddressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ReleaseAddressRequest, ReleaseAddressResponse>()
                .withMarshaller(new ReleaseAddressRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(releaseAddressRequest));
    }

    /**
     * <p>
     * When you no longer want to use an On-Demand Dedicated Host it can be released. On-Demand billing is stopped and
     * the host goes into <code>released</code> state. The host ID of Dedicated Hosts that have been released can no
     * longer be specified in another request, e.g., ModifyHosts. You must stop or terminate all instances on a host
     * before it can be released.
     * </p>
     * <p>
     * When Dedicated Hosts are released, it make take some time for them to stop counting toward your limit and you may
     * receive capacity errors when trying to allocate new Dedicated hosts. Try waiting a few minutes, and then try
     * again.
     * </p>
     * <p>
     * Released hosts will still appear in a <a>DescribeHosts</a> response.
     * </p>
     *
     * @param releaseHostsRequest
     *        Contains the parameters for ReleaseHosts.
     * @return A Java Future containing the result of the ReleaseHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ReleaseHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReleaseHosts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ReleaseHostsResponse> releaseHosts(ReleaseHostsRequest releaseHostsRequest) {

        StaxResponseHandler<ReleaseHostsResponse> responseHandler = new StaxResponseHandler<ReleaseHostsResponse>(
                new ReleaseHostsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ReleaseHostsRequest, ReleaseHostsResponse>()
                .withMarshaller(new ReleaseHostsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(releaseHostsRequest));
    }

    /**
     * <p>
     * Replaces an IAM instance profile for the specified running instance. You can use this action to change the IAM
     * instance profile that's associated with an instance without having to disassociate the existing IAM instance
     * profile first.
     * </p>
     * <p>
     * Use <a>DescribeIamInstanceProfileAssociations</a> to get the association ID.
     * </p>
     *
     * @param replaceIamInstanceProfileAssociationRequest
     * @return A Java Future containing the result of the ReplaceIamInstanceProfileAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ReplaceIamInstanceProfileAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceIamInstanceProfileAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ReplaceIamInstanceProfileAssociationResponse> replaceIamInstanceProfileAssociation(
            ReplaceIamInstanceProfileAssociationRequest replaceIamInstanceProfileAssociationRequest) {

        StaxResponseHandler<ReplaceIamInstanceProfileAssociationResponse> responseHandler = new StaxResponseHandler<ReplaceIamInstanceProfileAssociationResponse>(
                new ReplaceIamInstanceProfileAssociationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ReplaceIamInstanceProfileAssociationRequest, ReplaceIamInstanceProfileAssociationResponse>()
                        .withMarshaller(new ReplaceIamInstanceProfileAssociationRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(replaceIamInstanceProfileAssociationRequest));
    }

    /**
     * <p>
     * Changes which network ACL a subnet is associated with. By default when you create a subnet, it's automatically
     * associated with the default network ACL. For more information about network ACLs, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon
     * Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param replaceNetworkAclAssociationRequest
     *        Contains the parameters for ReplaceNetworkAclAssociation.
     * @return A Java Future containing the result of the ReplaceNetworkAclAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ReplaceNetworkAclAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ReplaceNetworkAclAssociationResponse> replaceNetworkAclAssociation(
            ReplaceNetworkAclAssociationRequest replaceNetworkAclAssociationRequest) {

        StaxResponseHandler<ReplaceNetworkAclAssociationResponse> responseHandler = new StaxResponseHandler<ReplaceNetworkAclAssociationResponse>(
                new ReplaceNetworkAclAssociationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ReplaceNetworkAclAssociationRequest, ReplaceNetworkAclAssociationResponse>()
                        .withMarshaller(new ReplaceNetworkAclAssociationRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(replaceNetworkAclAssociationRequest));
    }

    /**
     * <p>
     * Replaces an entry (rule) in a network ACL. For more information about network ACLs, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon
     * Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param replaceNetworkAclEntryRequest
     *        Contains the parameters for ReplaceNetworkAclEntry.
     * @return A Java Future containing the result of the ReplaceNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ReplaceNetworkAclEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ReplaceNetworkAclEntryResponse> replaceNetworkAclEntry(
            ReplaceNetworkAclEntryRequest replaceNetworkAclEntryRequest) {

        StaxResponseHandler<ReplaceNetworkAclEntryResponse> responseHandler = new StaxResponseHandler<ReplaceNetworkAclEntryResponse>(
                new ReplaceNetworkAclEntryResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ReplaceNetworkAclEntryRequest, ReplaceNetworkAclEntryResponse>()
                .withMarshaller(new ReplaceNetworkAclEntryRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(replaceNetworkAclEntryRequest));
    }

    /**
     * <p>
     * Replaces an existing route within a route table in a VPC. You must provide only one of the following: Internet
     * gateway or virtual private gateway, NAT instance, NAT gateway, VPC peering connection, network interface, or
     * egress-only Internet gateway.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param replaceRouteRequest
     *        Contains the parameters for ReplaceRoute.
     * @return A Java Future containing the result of the ReplaceRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ReplaceRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ReplaceRouteResponse> replaceRoute(ReplaceRouteRequest replaceRouteRequest) {

        StaxResponseHandler<ReplaceRouteResponse> responseHandler = new StaxResponseHandler<ReplaceRouteResponse>(
                new ReplaceRouteResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ReplaceRouteRequest, ReplaceRouteResponse>()
                .withMarshaller(new ReplaceRouteRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(replaceRouteRequest));
    }

    /**
     * <p>
     * Changes the route table associated with a given subnet in a VPC. After the operation completes, the subnet uses
     * the routes in the new route table it's associated with. For more information about route tables, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * You can also use ReplaceRouteTableAssociation to change which table is the main route table in the VPC. You just
     * specify the main route table's association ID and the route table to be the new main route table.
     * </p>
     *
     * @param replaceRouteTableAssociationRequest
     *        Contains the parameters for ReplaceRouteTableAssociation.
     * @return A Java Future containing the result of the ReplaceRouteTableAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ReplaceRouteTableAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReplaceRouteTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ReplaceRouteTableAssociationResponse> replaceRouteTableAssociation(
            ReplaceRouteTableAssociationRequest replaceRouteTableAssociationRequest) {

        StaxResponseHandler<ReplaceRouteTableAssociationResponse> responseHandler = new StaxResponseHandler<ReplaceRouteTableAssociationResponse>(
                new ReplaceRouteTableAssociationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ReplaceRouteTableAssociationRequest, ReplaceRouteTableAssociationResponse>()
                        .withMarshaller(new ReplaceRouteTableAssociationRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(replaceRouteTableAssociationRequest));
    }

    /**
     * <p>
     * Submits feedback about the status of an instance. The instance must be in the <code>running</code> state. If your
     * experience with the instance differs from the instance status returned by <a>DescribeInstanceStatus</a>, use
     * <a>ReportInstanceStatus</a> to report your experience with the instance. Amazon EC2 collects this information to
     * improve the accuracy of status checks.
     * </p>
     * <p>
     * Use of this action does not change the value returned by <a>DescribeInstanceStatus</a>.
     * </p>
     *
     * @param reportInstanceStatusRequest
     *        Contains the parameters for ReportInstanceStatus.
     * @return A Java Future containing the result of the ReportInstanceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ReportInstanceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReportInstanceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ReportInstanceStatusResponse> reportInstanceStatus(
            ReportInstanceStatusRequest reportInstanceStatusRequest) {

        StaxResponseHandler<ReportInstanceStatusResponse> responseHandler = new StaxResponseHandler<ReportInstanceStatusResponse>(
                new ReportInstanceStatusResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ReportInstanceStatusRequest, ReportInstanceStatusResponse>()
                .withMarshaller(new ReportInstanceStatusRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(reportInstanceStatusRequest));
    }

    /**
     * <p>
     * Creates a Spot fleet request.
     * </p>
     * <p>
     * You can submit a single request that includes multiple launch specifications that vary by instance type, AMI,
     * Availability Zone, or subnet.
     * </p>
     * <p>
     * By default, the Spot fleet requests Spot instances in the Spot pool where the price per unit is the lowest. Each
     * launch specification can include its own instance weighting that reflects the value of the instance type to your
     * application workload.
     * </p>
     * <p>
     * Alternatively, you can specify that the Spot fleet distribute the target capacity across the Spot pools included
     * in its launch specifications. By ensuring that the Spot instances in your Spot fleet are in different Spot pools,
     * you can improve the availability of your fleet.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html">Spot Fleet Requests</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param requestSpotFleetRequest
     *        Contains the parameters for RequestSpotFleet.
     * @return A Java Future containing the result of the RequestSpotFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RequestSpotFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestSpotFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RequestSpotFleetResponse> requestSpotFleet(RequestSpotFleetRequest requestSpotFleetRequest) {

        StaxResponseHandler<RequestSpotFleetResponse> responseHandler = new StaxResponseHandler<RequestSpotFleetResponse>(
                new RequestSpotFleetResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<RequestSpotFleetRequest, RequestSpotFleetResponse>()
                .withMarshaller(new RequestSpotFleetRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(requestSpotFleetRequest));
    }

    /**
     * <p>
     * Creates a Spot instance request. Spot instances are instances that Amazon EC2 launches when the bid price that
     * you specify exceeds the current Spot price. Amazon EC2 periodically sets the Spot price based on available Spot
     * Instance capacity and current Spot instance requests. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance Requests</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param requestSpotInstancesRequest
     *        Contains the parameters for RequestSpotInstances.
     * @return A Java Future containing the result of the RequestSpotInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RequestSpotInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestSpotInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RequestSpotInstancesResponse> requestSpotInstances(
            RequestSpotInstancesRequest requestSpotInstancesRequest) {

        StaxResponseHandler<RequestSpotInstancesResponse> responseHandler = new StaxResponseHandler<RequestSpotInstancesResponse>(
                new RequestSpotInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<RequestSpotInstancesRequest, RequestSpotInstancesResponse>()
                .withMarshaller(new RequestSpotInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(requestSpotInstancesRequest));
    }

    /**
     * <p>
     * Resets the specified attribute of the specified Amazon FPGA Image (AFI) to its default value. You can only reset
     * the load permission attribute.
     * </p>
     *
     * @param resetFpgaImageAttributeRequest
     * @return A Java Future containing the result of the ResetFpgaImageAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ResetFpgaImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetFpgaImageAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetFpgaImageAttributeResponse> resetFpgaImageAttribute(
            ResetFpgaImageAttributeRequest resetFpgaImageAttributeRequest) {

        StaxResponseHandler<ResetFpgaImageAttributeResponse> responseHandler = new StaxResponseHandler<ResetFpgaImageAttributeResponse>(
                new ResetFpgaImageAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ResetFpgaImageAttributeRequest, ResetFpgaImageAttributeResponse>()
                .withMarshaller(new ResetFpgaImageAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(resetFpgaImageAttributeRequest));
    }

    /**
     * <p>
     * Resets an attribute of an AMI to its default value.
     * </p>
     * <note>
     * <p>
     * The productCodes attribute can't be reset.
     * </p>
     * </note>
     *
     * @param resetImageAttributeRequest
     *        Contains the parameters for ResetImageAttribute.
     * @return A Java Future containing the result of the ResetImageAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ResetImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetImageAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetImageAttributeResponse> resetImageAttribute(
            ResetImageAttributeRequest resetImageAttributeRequest) {

        StaxResponseHandler<ResetImageAttributeResponse> responseHandler = new StaxResponseHandler<ResetImageAttributeResponse>(
                new ResetImageAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ResetImageAttributeRequest, ResetImageAttributeResponse>()
                .withMarshaller(new ResetImageAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(resetImageAttributeRequest));
    }

    /**
     * <p>
     * Resets an attribute of an instance to its default value. To reset the <code>kernel</code> or <code>ramdisk</code>
     * , the instance must be in a stopped state. To reset the <code>sourceDestCheck</code>, the instance can be either
     * running or stopped.
     * </p>
     * <p>
     * The <code>sourceDestCheck</code> attribute controls whether source/destination checking is enabled. The default
     * value is <code>true</code>, which means checking is enabled. This value must be <code>false</code> for a NAT
     * instance to perform NAT. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param resetInstanceAttributeRequest
     *        Contains the parameters for ResetInstanceAttribute.
     * @return A Java Future containing the result of the ResetInstanceAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ResetInstanceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetInstanceAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetInstanceAttributeResponse> resetInstanceAttribute(
            ResetInstanceAttributeRequest resetInstanceAttributeRequest) {

        StaxResponseHandler<ResetInstanceAttributeResponse> responseHandler = new StaxResponseHandler<ResetInstanceAttributeResponse>(
                new ResetInstanceAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ResetInstanceAttributeRequest, ResetInstanceAttributeResponse>()
                .withMarshaller(new ResetInstanceAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(resetInstanceAttributeRequest));
    }

    /**
     * <p>
     * Resets a network interface attribute. You can specify only one attribute at a time.
     * </p>
     *
     * @param resetNetworkInterfaceAttributeRequest
     *        Contains the parameters for ResetNetworkInterfaceAttribute.
     * @return A Java Future containing the result of the ResetNetworkInterfaceAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ResetNetworkInterfaceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetNetworkInterfaceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetNetworkInterfaceAttributeResponse> resetNetworkInterfaceAttribute(
            ResetNetworkInterfaceAttributeRequest resetNetworkInterfaceAttributeRequest) {

        StaxResponseHandler<ResetNetworkInterfaceAttributeResponse> responseHandler = new StaxResponseHandler<ResetNetworkInterfaceAttributeResponse>(
                new ResetNetworkInterfaceAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ResetNetworkInterfaceAttributeRequest, ResetNetworkInterfaceAttributeResponse>()
                        .withMarshaller(new ResetNetworkInterfaceAttributeRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(resetNetworkInterfaceAttributeRequest));
    }

    /**
     * <p>
     * Resets permission settings for the specified snapshot.
     * </p>
     * <p>
     * For more information on modifying snapshot permissions, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Sharing
     * Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param resetSnapshotAttributeRequest
     *        Contains the parameters for ResetSnapshotAttribute.
     * @return A Java Future containing the result of the ResetSnapshotAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.ResetSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetSnapshotAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetSnapshotAttributeResponse> resetSnapshotAttribute(
            ResetSnapshotAttributeRequest resetSnapshotAttributeRequest) {

        StaxResponseHandler<ResetSnapshotAttributeResponse> responseHandler = new StaxResponseHandler<ResetSnapshotAttributeResponse>(
                new ResetSnapshotAttributeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ResetSnapshotAttributeRequest, ResetSnapshotAttributeResponse>()
                .withMarshaller(new ResetSnapshotAttributeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(resetSnapshotAttributeRequest));
    }

    /**
     * <p>
     * Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic
     * platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP
     * address must not be associated with an instance or network interface.
     * </p>
     *
     * @param restoreAddressToClassicRequest
     *        Contains the parameters for RestoreAddressToClassic.
     * @return A Java Future containing the result of the RestoreAddressToClassic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RestoreAddressToClassic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RestoreAddressToClassic" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreAddressToClassicResponse> restoreAddressToClassic(
            RestoreAddressToClassicRequest restoreAddressToClassicRequest) {

        StaxResponseHandler<RestoreAddressToClassicResponse> responseHandler = new StaxResponseHandler<RestoreAddressToClassicResponse>(
                new RestoreAddressToClassicResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<RestoreAddressToClassicRequest, RestoreAddressToClassicResponse>()
                .withMarshaller(new RestoreAddressToClassicRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(restoreAddressToClassicRequest));
    }

    /**
     * <p>
     * [EC2-VPC only] Removes one or more egress rules from a security group for EC2-VPC. This action doesn't apply to
     * security groups for use in EC2-Classic. To remove a rule, the values that you specify (for example, ports) must
     * match the existing rule's values exactly.
     * </p>
     * <p>
     * Each rule consists of the protocol and the IPv4 or IPv6 CIDR range or source security group. For the TCP and UDP
     * protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also
     * specify the ICMP type and code. If the security group rule has a description, you do not have to specify the
     * description to revoke the rule.
     * </p>
     * <p>
     * Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay
     * might occur.
     * </p>
     *
     * @param revokeSecurityGroupEgressRequest
     *        Contains the parameters for RevokeSecurityGroupEgress.
     * @return A Java Future containing the result of the RevokeSecurityGroupEgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RevokeSecurityGroupEgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupEgress" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeSecurityGroupEgressResponse> revokeSecurityGroupEgress(
            RevokeSecurityGroupEgressRequest revokeSecurityGroupEgressRequest) {

        StaxResponseHandler<RevokeSecurityGroupEgressResponse> responseHandler = new StaxResponseHandler<RevokeSecurityGroupEgressResponse>(
                new RevokeSecurityGroupEgressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<RevokeSecurityGroupEgressRequest, RevokeSecurityGroupEgressResponse>()
                        .withMarshaller(new RevokeSecurityGroupEgressRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(revokeSecurityGroupEgressRequest));
    }

    /**
     * <p>
     * Removes one or more ingress rules from a security group. To remove a rule, the values that you specify (for
     * example, ports) must match the existing rule's values exactly.
     * </p>
     * <note>
     * <p>
     * [EC2-Classic security groups only] If the values you specify do not match the existing rule's values, no error is
     * returned. Use <a>DescribeSecurityGroups</a> to verify that the rule has been removed.
     * </p>
     * </note>
     * <p>
     * Each rule consists of the protocol and the CIDR range or source security group. For the TCP and UDP protocols,
     * you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the
     * ICMP type and code. If the security group rule has a description, you do not have to specify the description to
     * revoke the rule.
     * </p>
     * <p>
     * Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay
     * might occur.
     * </p>
     *
     * @param revokeSecurityGroupIngressRequest
     *        Contains the parameters for RevokeSecurityGroupIngress.
     * @return A Java Future containing the result of the RevokeSecurityGroupIngress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RevokeSecurityGroupIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupIngress" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeSecurityGroupIngressResponse> revokeSecurityGroupIngress(
            RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) {

        StaxResponseHandler<RevokeSecurityGroupIngressResponse> responseHandler = new StaxResponseHandler<RevokeSecurityGroupIngressResponse>(
                new RevokeSecurityGroupIngressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<RevokeSecurityGroupIngressRequest, RevokeSecurityGroupIngressResponse>()
                        .withMarshaller(new RevokeSecurityGroupIngressRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(revokeSecurityGroupIngressRequest));
    }

    /**
     * <p>
     * Launches the specified number of instances using an AMI for which you have permissions.
     * </p>
     * <p>
     * You can specify a number of options, or leave the default options. The following rules apply:
     * </p>
     * <ul>
     * <li>
     * <p>
     * [EC2-VPC] If you don't specify a subnet ID, we choose a default subnet from your default VPC for you. If you
     * don't have a default VPC, you must specify a subnet ID in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * [EC2-Classic] If don't specify an Availability Zone, we choose one for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * Some instance types must be launched into a VPC. If you do not have a default VPC, or if you do not specify a
     * subnet ID, the request fails. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-vpc.html#vpc-only-instance-types">Instance Types
     * Available Only in a VPC</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * [EC2-VPC] All instances have a network interface with a primary private IPv4 address. If you don't specify this
     * address, we choose one from the IPv4 range of your subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not all instance types support IPv6 addresses. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify a security group ID, we use the default security group. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Security Groups</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If any of the AMIs have a product code attached for which the user has not subscribed, the request fails.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To ensure faster instance launches, break up large requests into smaller batches. For example, create five
     * separate launch requests for 100 instances each instead of one launch request for 500 instances.
     * </p>
     * <p>
     * An instance is ready for you to use when it's in the <code>running</code> state. You can check the state of your
     * instance using <a>DescribeInstances</a>. You can tag instances and EBS volumes during launch, after launch, or
     * both. For more information, see <a>CreateTags</a> and <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a>.
     * </p>
     * <p>
     * Linux instances have access to the public key of the key pair at boot. You can use this key to provide secure
     * access to the instance. Amazon EC2 public images use this feature to provide secure access without passwords. For
     * more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key
     * Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For troubleshooting, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_InstanceStraightToTerminated.html">What To Do If
     * An Instance Immediately Terminates</a>, and <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesConnecting.html">Troubleshooting
     * Connecting to Your Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param runInstancesRequest
     *        Contains the parameters for RunInstances.
     * @return A Java Future containing the result of the RunInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RunInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RunInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RunInstancesResponse> runInstances(RunInstancesRequest runInstancesRequest) {

        StaxResponseHandler<RunInstancesResponse> responseHandler = new StaxResponseHandler<RunInstancesResponse>(
                new RunInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<RunInstancesRequest, RunInstancesResponse>()
                .withMarshaller(new RunInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(runInstancesRequest));
    }

    /**
     * <p>
     * Launches the specified Scheduled Instances.
     * </p>
     * <p>
     * Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using
     * <a>PurchaseScheduledInstances</a>.
     * </p>
     * <p>
     * You must launch a Scheduled Instance during its scheduled time period. You can't stop or reboot a Scheduled
     * Instance, but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled
     * time period ends, you can launch it again after a few minutes. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-scheduled-instances.html">Scheduled Instances</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param runScheduledInstancesRequest
     *        Contains the parameters for RunScheduledInstances.
     * @return A Java Future containing the result of the RunScheduledInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.RunScheduledInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RunScheduledInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RunScheduledInstancesResponse> runScheduledInstances(
            RunScheduledInstancesRequest runScheduledInstancesRequest) {

        StaxResponseHandler<RunScheduledInstancesResponse> responseHandler = new StaxResponseHandler<RunScheduledInstancesResponse>(
                new RunScheduledInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<RunScheduledInstancesRequest, RunScheduledInstancesResponse>()
                .withMarshaller(new RunScheduledInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(runScheduledInstancesRequest));
    }

    /**
     * <p>
     * Starts an Amazon EBS-backed instance that you've previously stopped.
     * </p>
     * <p>
     * Instances that use Amazon EBS volumes as their root devices can be quickly stopped and started. When an instance
     * is stopped, the compute resources are released and you are not billed for instance usage. However, your root
     * partition Amazon EBS volume remains and continues to persist your data, and you are charged for Amazon EBS volume
     * usage. You can restart your instance at any time. Every time you start your Windows instance, Amazon EC2 charges
     * you for a full instance hour. If you stop and restart your Windows instance, a new instance hour begins and
     * Amazon EC2 charges you for another full instance hour even if you are still within the same 60-minute period when
     * it was stopped. Every time you start your Linux instance, Amazon EC2 charges a one-minute minimum for instance
     * usage, and thereafter charges per second for instance usage.
     * </p>
     * <p>
     * Before stopping an instance, make sure it is in a state from which it can be restarted. Stopping an instance does
     * not preserve data stored in RAM.
     * </p>
     * <p>
     * Performing this operation on an instance that uses an instance store as its root device returns an error.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html">Stopping
     * Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param startInstancesRequest
     *        Contains the parameters for StartInstances.
     * @return A Java Future containing the result of the StartInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.StartInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StartInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartInstancesResponse> startInstances(StartInstancesRequest startInstancesRequest) {

        StaxResponseHandler<StartInstancesResponse> responseHandler = new StaxResponseHandler<StartInstancesResponse>(
                new StartInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<StartInstancesRequest, StartInstancesResponse>()
                .withMarshaller(new StartInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startInstancesRequest));
    }

    /**
     * <p>
     * Stops an Amazon EBS-backed instance.
     * </p>
     * <p>
     * We don't charge usage for a stopped instance, or data transfer fees; however, your root partition Amazon EBS
     * volume remains and continues to persist your data, and you are charged for Amazon EBS volume usage. Every time
     * you start your Windows instance, Amazon EC2 charges you for a full instance hour. If you stop and restart your
     * Windows instance, a new instance hour begins and Amazon EC2 charges you for another full instance hour even if
     * you are still within the same 60-minute period when it was stopped. Every time you start your Linux instance,
     * Amazon EC2 charges a one-minute minimum for instance usage, and thereafter charges per second for instance usage.
     * </p>
     * <p>
     * You can't start or stop Spot Instances, and you can't stop instance store-backed instances.
     * </p>
     * <p>
     * When you stop an instance, we shut it down. You can restart your instance at any time. Before stopping an
     * instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data
     * stored in RAM.
     * </p>
     * <p>
     * Stopping an instance is different to rebooting or terminating it. For example, when you stop an instance, the
     * root device and any other devices attached to the instance persist. When you terminate an instance, the root
     * device and any other devices attached during the instance launch are automatically deleted. For more information
     * about the differences between rebooting, stopping, and terminating instances, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance Lifecycle</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * When you stop an instance, we attempt to shut it down forcibly after a short while. If your instance appears
     * stuck in the stopping state after a period of time, there may be an issue with the underlying host computer. For
     * more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html">Troubleshooting
     * Stopping Your Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param stopInstancesRequest
     *        Contains the parameters for StopInstances.
     * @return A Java Future containing the result of the StopInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.StopInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StopInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopInstancesResponse> stopInstances(StopInstancesRequest stopInstancesRequest) {

        StaxResponseHandler<StopInstancesResponse> responseHandler = new StaxResponseHandler<StopInstancesResponse>(
                new StopInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<StopInstancesRequest, StopInstancesResponse>()
                .withMarshaller(new StopInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopInstancesRequest));
    }

    /**
     * <p>
     * Shuts down one or more instances. This operation is idempotent; if you terminate an instance more than once, each
     * call succeeds.
     * </p>
     * <p>
     * If you specify multiple instances and the request fails (for example, because of a single incorrect instance ID),
     * none of the instances are terminated.
     * </p>
     * <p>
     * Terminated instances remain visible after termination (for approximately one hour).
     * </p>
     * <p>
     * By default, Amazon EC2 deletes all EBS volumes that were attached when the instance launched. Volumes attached
     * after instance launch continue running.
     * </p>
     * <p>
     * You can stop, start, and terminate EBS-backed instances. You can only terminate instance store-backed instances.
     * What happens to an instance differs if you stop it or terminate it. For example, when you stop an instance, the
     * root device and any other devices attached to the instance persist. When you terminate an instance, any attached
     * EBS volumes with the <code>DeleteOnTermination</code> block device mapping parameter set to <code>true</code> are
     * automatically deleted. For more information about the differences between stopping and terminating instances, see
     * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance Lifecycle</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information about troubleshooting, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html"
     * >Troubleshooting Terminating Your Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param terminateInstancesRequest
     *        Contains the parameters for TerminateInstances.
     * @return A Java Future containing the result of the TerminateInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.TerminateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/TerminateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TerminateInstancesResponse> terminateInstances(TerminateInstancesRequest terminateInstancesRequest) {

        StaxResponseHandler<TerminateInstancesResponse> responseHandler = new StaxResponseHandler<TerminateInstancesResponse>(
                new TerminateInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<TerminateInstancesRequest, TerminateInstancesResponse>()
                .withMarshaller(new TerminateInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(terminateInstancesRequest));
    }

    /**
     * <p>
     * Unassigns one or more IPv6 addresses from a network interface.
     * </p>
     *
     * @param unassignIpv6AddressesRequest
     * @return A Java Future containing the result of the UnassignIpv6Addresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.UnassignIpv6Addresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnassignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnassignIpv6AddressesResponse> unassignIpv6Addresses(
            UnassignIpv6AddressesRequest unassignIpv6AddressesRequest) {

        StaxResponseHandler<UnassignIpv6AddressesResponse> responseHandler = new StaxResponseHandler<UnassignIpv6AddressesResponse>(
                new UnassignIpv6AddressesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<UnassignIpv6AddressesRequest, UnassignIpv6AddressesResponse>()
                .withMarshaller(new UnassignIpv6AddressesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(unassignIpv6AddressesRequest));
    }

    /**
     * <p>
     * Unassigns one or more secondary private IP addresses from a network interface.
     * </p>
     *
     * @param unassignPrivateIpAddressesRequest
     *        Contains the parameters for UnassignPrivateIpAddresses.
     * @return A Java Future containing the result of the UnassignPrivateIpAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.UnassignPrivateIpAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnassignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UnassignPrivateIpAddressesResponse> unassignPrivateIpAddresses(
            UnassignPrivateIpAddressesRequest unassignPrivateIpAddressesRequest) {

        StaxResponseHandler<UnassignPrivateIpAddressesResponse> responseHandler = new StaxResponseHandler<UnassignPrivateIpAddressesResponse>(
                new UnassignPrivateIpAddressesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<UnassignPrivateIpAddressesRequest, UnassignPrivateIpAddressesResponse>()
                        .withMarshaller(new UnassignPrivateIpAddressesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(unassignPrivateIpAddressesRequest));
    }

    /**
     * <p>
     * Disables detailed monitoring for a running instance. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring Your Instances and
     * Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param unmonitorInstancesRequest
     *        Contains the parameters for UnmonitorInstances.
     * @return A Java Future containing the result of the UnmonitorInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.UnmonitorInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UnmonitorInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnmonitorInstancesResponse> unmonitorInstances(UnmonitorInstancesRequest unmonitorInstancesRequest) {

        StaxResponseHandler<UnmonitorInstancesResponse> responseHandler = new StaxResponseHandler<UnmonitorInstancesResponse>(
                new UnmonitorInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<UnmonitorInstancesRequest, UnmonitorInstancesResponse>()
                .withMarshaller(new UnmonitorInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(unmonitorInstancesRequest));
    }

    /**
     * <p>
     * [EC2-VPC only] Updates the description of an egress (outbound) security group rule. You can replace an existing
     * description, or add a description to a rule that did not have one previously.
     * </p>
     * <p>
     * You specify the description as part of the IP permissions structure. You can remove a description for a security
     * group rule by omitting the description parameter in the request.
     * </p>
     *
     * @param updateSecurityGroupRuleDescriptionsEgressRequest
     *        Contains the parameters for UpdateSecurityGroupRuleDescriptionsEgress.
     * @return A Java Future containing the result of the UpdateSecurityGroupRuleDescriptionsEgress operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.UpdateSecurityGroupRuleDescriptionsEgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UpdateSecurityGroupRuleDescriptionsEgress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSecurityGroupRuleDescriptionsEgressResponse> updateSecurityGroupRuleDescriptionsEgress(
            UpdateSecurityGroupRuleDescriptionsEgressRequest updateSecurityGroupRuleDescriptionsEgressRequest) {

        StaxResponseHandler<UpdateSecurityGroupRuleDescriptionsEgressResponse> responseHandler = new StaxResponseHandler<UpdateSecurityGroupRuleDescriptionsEgressResponse>(
                new UpdateSecurityGroupRuleDescriptionsEgressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateSecurityGroupRuleDescriptionsEgressRequest, UpdateSecurityGroupRuleDescriptionsEgressResponse>()
                        .withMarshaller(new UpdateSecurityGroupRuleDescriptionsEgressRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateSecurityGroupRuleDescriptionsEgressRequest));
    }

    /**
     * <p>
     * Updates the description of an ingress (inbound) security group rule. You can replace an existing description, or
     * add a description to a rule that did not have one previously.
     * </p>
     * <p>
     * You specify the description as part of the IP permissions structure. You can remove a description for a security
     * group rule by omitting the description parameter in the request.
     * </p>
     *
     * @param updateSecurityGroupRuleDescriptionsIngressRequest
     *        Contains the parameters for UpdateSecurityGroupRuleDescriptionsIngress.
     * @return A Java Future containing the result of the UpdateSecurityGroupRuleDescriptionsIngress operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EC2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EC2AsyncClient.UpdateSecurityGroupRuleDescriptionsIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/UpdateSecurityGroupRuleDescriptionsIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSecurityGroupRuleDescriptionsIngressResponse> updateSecurityGroupRuleDescriptionsIngress(
            UpdateSecurityGroupRuleDescriptionsIngressRequest updateSecurityGroupRuleDescriptionsIngressRequest) {

        StaxResponseHandler<UpdateSecurityGroupRuleDescriptionsIngressResponse> responseHandler = new StaxResponseHandler<UpdateSecurityGroupRuleDescriptionsIngressResponse>(
                new UpdateSecurityGroupRuleDescriptionsIngressResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateSecurityGroupRuleDescriptionsIngressRequest, UpdateSecurityGroupRuleDescriptionsIngressResponse>()
                        .withMarshaller(new UpdateSecurityGroupRuleDescriptionsIngressRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateSecurityGroupRuleDescriptionsIngressRequest));
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private List<Unmarshaller<SdkServiceException, Node>> init() {
        List<Unmarshaller<SdkServiceException, Node>> unmarshallers = new ArrayList<>();
        unmarshallers.add(new LegacyErrorUnmarshaller(EC2Exception.class));
        return unmarshallers;
    }
}
