/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.DiskImageDescription;

public class DiskImageDescriptionUnmarshaller
implements Unmarshaller<DiskImageDescription, StaxUnmarshallerContext> {
    private static final DiskImageDescriptionUnmarshaller INSTANCE = new DiskImageDescriptionUnmarshaller();

    public DiskImageDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DiskImageDescription.Builder diskImageDescription = DiskImageDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("checksum", targetDepth)) {
                    diskImageDescription.checksum(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("format", targetDepth)) {
                    diskImageDescription.format(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("importManifestUrl", targetDepth)) {
                    diskImageDescription.importManifestUrl(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("size", targetDepth)) continue;
                diskImageDescription.size(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DiskImageDescription)diskImageDescription.build();
    }

    public static DiskImageDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

