/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;

public class CreateVolumeRequestMarshaller
implements Marshaller<Request<CreateVolumeRequest>, CreateVolumeRequest> {
    public Request<CreateVolumeRequest> marshall(CreateVolumeRequest createVolumeRequest) {
        List<TagSpecification> createVolumeRequestTagSpecificationsList;
        if (createVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createVolumeRequest, "EC2Client");
        request.addParameter("Action", "CreateVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVolumeRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createVolumeRequest.availabilityZone()));
        }
        if (createVolumeRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)createVolumeRequest.encrypted()));
        }
        if (createVolumeRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)createVolumeRequest.iops()));
        }
        if (createVolumeRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createVolumeRequest.kmsKeyId()));
        }
        if (createVolumeRequest.size() != null) {
            request.addParameter("Size", StringUtils.fromInteger((Integer)createVolumeRequest.size()));
        }
        if (createVolumeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)createVolumeRequest.snapshotId()));
        }
        if (createVolumeRequest.volumeTypeString() != null) {
            request.addParameter("VolumeType", StringUtils.fromString((String)createVolumeRequest.volumeTypeString()));
        }
        if ((createVolumeRequestTagSpecificationsList = createVolumeRequest.tagSpecifications()) != null) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVolumeRequestTagSpecificationsListValue : createVolumeRequestTagSpecificationsList) {
                List<Tag> tagSpecificationTagsList;
                if (createVolumeRequestTagSpecificationsListValue.resourceTypeString() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createVolumeRequestTagSpecificationsListValue.resourceTypeString()));
                }
                if ((tagSpecificationTagsList = createVolumeRequestTagSpecificationsListValue.tags()) != null) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.key() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.key()));
                        }
                        if (tagSpecificationTagsListValue.value() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.value()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

