/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.InstanceStatus;

public final class DescribeInstanceStatusPaginator
implements SdkIterable<DescribeInstanceStatusResponse> {
    private final EC2Client client;
    private final DescribeInstanceStatusRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeInstanceStatusPaginator(EC2Client client, DescribeInstanceStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstanceStatusResponseFetcher();
    }

    public Iterator<DescribeInstanceStatusResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<InstanceStatus> instanceStatuses() {
        Function<DescribeInstanceStatusResponse, Iterator> getIterator = response -> response != null ? response.instanceStatuses().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeInstanceStatusResponseFetcher
    implements NextPageFetcher<DescribeInstanceStatusResponse> {
        private DescribeInstanceStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeInstanceStatusResponse nextPage(DescribeInstanceStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceStatusPaginator.this.client.describeInstanceStatus(DescribeInstanceStatusPaginator.this.firstRequest);
            }
            return DescribeInstanceStatusPaginator.this.client.describeInstanceStatus((DescribeInstanceStatusRequest)((Object)DescribeInstanceStatusPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

